% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/create_function.R
\name{create_function}
\alias{create_function}
\alias{update_function}
\alias{make_function_version}
\title{Manage AWS Lambda Functions}
\usage{
create_function(name, description = name, func, handler, role,
  runtime = c("nodejs6.10", "nodejs4.3", "java8", "python2.7",
  "dotnetcore1.0", "nodejs4.3-edge"), timeout = 3L, ...)

update_function(name, func, description, handler, role,
  runtime = c("nodejs6.10", "nodejs4.3", "java8", "python2.7",
  "dotnetcore1.0", "nodejs4.3-edge"), timeout = 3L, ...)

make_function_version(name, description, ...)
}
\arguments{
\item{name}{A character string specifying the function name (either a full ARN or a max 64-character string). For functions other than \code{create_function} this can also be an object of class \dQuote{aws_lambda_function}.}

\item{description}{Optionally, a max 256-character description of the function for your own use.}

\item{func}{Either (1) a character string containing a url-style AWS S3 bucket and object key (e.g., \code{"s3://bucketname/objectkey"}) where the object is the .zip file containing the AWS Lambda deployment package; (2) a file string pointing to a .zip containing the deployment package; or (3) a single file (e.g., a javascript file) that will be zipped and used as the deployment. The third option is merely a convenience for very simple deployment packages.}

\item{handler}{A character string specifying the function within your code that Lambda calls to begin execution.}

\item{role}{A character string containing an IAM role or an object of class \dQuote{iam_role}. This is the role that is used when the function is invoked, so it must have permissions over any AWS resources needed by the function.}

\item{runtime}{A character string specifying the runtime environment for the function.}

\item{timeout}{An integer specifying the timeout for the function, in seconds.}

\item{\dots}{Additional arguments passed to \code{\link{lambdaHTTP}}.}
}
\value{
A list of class \dQuote{aws_lambda_function}.
}
\description{
Create, update, and version AWS Lambda functions
}
\details{
\code{create_function} creates a new function from a deployment package. \code{update_function} can, separately, update the code within a function or the configuration settings thereof. \code{make_function_version} records a function version (see \code{\link{list_function_versions}}; changes made between versioning are not recorded.
}
\examples{
\dontrun{
  # 'hello world!' example code
  hello <- system.file("templates", "helloworld.js", package = "aws.lambda")

  # get IAM role for Lambda execution
  library("aws.iam")
  id <- get_caller_identity()[["Account"]]
  role <- paste0("arn:aws:iam::", id, ":role/lambda_basic_execution")

  func <- create_function("helloworld", func = hello, 
                          handler = "helloworld.handler", 
                          role = role)
  
  # invoke function
  invoke_function(func)

  # delete function
  delete_function(func)
}
}
\references{
\href{http://docs.aws.amazon.com/lambda/latest/dg/API_CreateFunction.html}{API Reference: CreateFunction}
 \href{http://docs.aws.amazon.com/lambda/latest/dg/API_UpdateFunction.html}{API Reference: UpdateFunction}
 \href{http://docs.aws.amazon.com/lambda/latest/dg/API_PublishFunction.html}{API Reference: PublishFunction}
}
\seealso{
\code{\link{invoke_function}}, \code{\link{create_function_alias}}, \code{\link{list_functions}}, \code{\link{delete_function}}
}
