% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/experiment.R
\name{submit_experiment}
\alias{submit_experiment}
\title{Submit an experiment and return the active created run}
\usage{
submit_experiment(experiment, config, tags = NULL)
}
\arguments{
\item{experiment}{The \code{Experiment} object.}

\item{config}{The \code{Estimator} or \code{HyperDriveConfig} object.}

\item{tags}{A named list of tags for the submitted run, e.g.
\code{list("tag" = "value")}.}
}
\value{
The \code{ScriptRun} or \code{HyperDriveRun} object.
}
\description{
\code{submit_experiment()} is an asynchronous call to Azure Machine Learning
service to execute a trial on local or remote compute. Depending on the
configuration, \code{submit_experiment()} will automatically prepare your
execution environments, execute your code, and capture your source code
and results in the experiment's run history.

To submit an experiment you first need to create a configuration object
describing how the experiment is to be run. The configuration depends on
the type of trial required. For a script run, provide an \code{Estimator} object
to the \code{config} parameter. For a HyperDrive run for hyperparameter tuning,
provide a \code{HyperDriveConfig} to \code{config}.
}
\examples{
# This example submits an Estimator experiment
\dontrun{
ws <- load_workspace_from_config()
compute_target <- get_compute(ws, cluster_name = 'mycluster')
exp <- experiment(ws, name = 'myexperiment')
est <- estimator(source_directory = '.',
                 entry_script = 'train.R',
                 compute_target = compute_target)
run <- submit_experiment(exp, est)
}
}
\seealso{
\code{estimator()}, \code{hyperdrive_config()}
}
