% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bbt_run.R
\name{bbt_run}
\alias{bbt_run}
\title{Run BEAST2}
\usage{
bbt_run(
  fasta_filename,
  tipdates_filename = NA,
  site_model = beautier::create_jc69_site_model(),
  clock_model = beautier::create_strict_clock_model(),
  tree_prior = beautier::create_yule_tree_prior(),
  mrca_prior = NA,
  mcmc = beautier::create_mcmc(),
  beast2_input_filename = beastier::create_temp_input_filename(),
  rng_seed = 1,
  beast2_output_state_filename = beastier::create_temp_state_filename(),
  beast2_path = beastier::get_default_beast2_path(),
  overwrite = TRUE,
  verbose = FALSE
)
}
\arguments{
\item{fasta_filename}{a FASTA filename}

\item{tipdates_filename}{name of the file containing tip dates}

\item{site_model}{one site model,
see \link[beautier]{create_site_models}}

\item{clock_model}{one clock model,
see \link[beautier]{create_clock_model}}

\item{tree_prior}{one tree priors,
as created by \link[beautier]{create_tree_prior}}

\item{mrca_prior}{one Most Recent Common Ancestor prior,
as returned by \code{\link{create_mrca_prior}}}

\item{mcmc}{the MCMC options,
see \link[beautier]{create_mcmc}}

\item{beast2_input_filename}{path of the 'BEAST2'  configuration file.
By default, this file is put in a temporary folder with a random
filename, as the user needs not read it: it is used as input of 'BEAST2'.
Specifying a \code{beast2_input_filename} allows to store that file
in a more permanently stored location.}

\item{rng_seed}{the random number generator seed. Must be either
\code{NA} or a positive non-zero value. An RNG seed of \code{NA}
results in 'BEAST2'  picking a random seed.}

\item{beast2_output_state_filename}{name of the final state file created
by 'BEAST2', containing the operator acceptances. By default, this
file is put a temporary folder with a random
filename, as the user needs not read it: its content
is parsed and returned by this function.
Specifying a \code{beast2_output_state_filename} allows to store that file
in a more permanently stored location.}

\item{beast2_path}{name of either a 'BEAST2'  binary file
(usually simply \code{beast})
or a 'BEAST2'  jar file
(usually has a \code{.jar} extension).
Use \code{get_default_beast2_bin_path} to get
the default BEAST binary file's path
Use \code{get_default_beast2_jar_path} to get
the default BEAST jar file's path}

\item{overwrite}{will 'BEAST2'  overwrite files? Like 'BEAST2',
this is set to \link{TRUE} by default.
If \link{TRUE}, 'BEAST2'  will overwrite the
\code{beast2_options$output_state_filename} if its present.
If \link{FALSE}, 'BEAST2'  will not overwrite the
\code{beast2_options$output_state_filename} if its present
and \link{babette} will give an error message.
Note that if \code{overwrite} is set to \link{FALSE} when
a \code{tracelog} (see \link{create_tracelog}),
\code{screenlog} (see \link{create_screenlog})
or \code{treelog} (see \link{create_treelog})
file already exists,
'BEAST2'  (and thus \link{babette}) will freeze.}

\item{verbose}{set to TRUE for more output}
}
\value{
a list with the following elements:\cr
\itemize{
  \item{
    \code{estimates}: a data frame with 'BEAST2'
    parameter estimates
  }
  \item{
    \code{[alignment_id]_trees}: a \code{multiPhylo}
    containing the phylogenies
    in the 'BEAST2' posterior. \code{[alignment_id]}
    is the ID of the alignment. For example,
    when running \code{\link{bbt_run}} with
    \code{anthus_aco.fas}, this element will have
    name \code{anthus_aco_trees}
  }
  \item{
    \code{operators}: a data frame with the
    'BEAST2' MCMC operator acceptances
  }
  \item{
    \code{output}: a numeric vector with the output
    sent to standard output and error streams
  }
  \item{
    \code{ns}: (optional) the results of a marginal likelihood estimation,
    will exist only when \code{\link[beautier]{create_ns_mcmc}} was
    used for the MCMC.
    This structure will contain the following elements:
    \itemize{
      \item \code{marg_log_lik} the marginal log likelihood estimate
      \item \code{marg_log_lik_sd} the standard deviation around the estimate
      \item \code{estimates} the parameter estimates
        created during the marginal likelihood estimation
      \item \code{trees} the trees
        created during the marginal likelihood estimation
    }
  }
}
}
\description{
Do a full BEAST2 run: create a 'BEAST2' configuration file (like 'BEAUti 2'),
run 'BEAST2', parse results (like 'Tracer')
}
\details{
Prefer using \code{\link{bbt_run_from_model}}, as it has a cleaner interface.
}
\examples{
if (beautier::is_on_ci() && is_beast2_installed()) {
  beastier::remove_beaustier_folders()
  beastier::check_empty_beaustier_folders()

  # Setup for a short run
  mcmc <- create_test_mcmc()

  # Store filenames for cleanup.
  # Note that 'bbt_run_from_model allows for easier cleanup
  mcmc$tracelog$filename <- tempfile()
  mcmc$treelog$filename <- tempfile()
  mcmc$screenlog$filename <- tempfile()
  beast2_input_filename <- tempfile()
  beast2_output_state_filename <- tempfile()

  bbt_run(
    fasta_filename = get_babette_path("anthus_aco.fas"),
    beast2_input_filename = beast2_input_filename,
    beast2_output_state_filename = beast2_output_state_filename,
    mcmc = mcmc
  )

  # Cleanup
  # Again, note that 'bbt_run_from_model allows for easier cleanup
  file.remove(mcmc$tracelog$filename)
  file.remove(mcmc$treelog$filename)
  file.remove(mcmc$screenlog$filename)
  file.remove(beast2_input_filename)
  file.remove(beast2_output_state_filename)
  beastier::remove_beaustier_folders()
  beastier::check_empty_beaustier_folders()
}
}
\seealso{
Use \code{\link[tracerer]{remove_burn_ins}}
  to remove the burn-ins from
  the posterior's estimates (\code{posterior$estimates})
}
\author{
Richèl J.C. Bilderbeek
}
