% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sparsify.R
\name{sparsify.with.lspar}
\alias{sparsify.with.lspar}
\title{Extract Satuluri et al's (2011) L-spar backbone}
\usage{
sparsify.with.lspar(U, s, class = "original", narrative = FALSE)
}
\arguments{
\item{U}{An unweighted unipartite graph, as: (1) an adjacency matrix in the form of a matrix or sparse \code{\link{Matrix}}; (2) an edgelist in the form of a two-column dataframe; (3) an \code{\link{igraph}} object.}

\item{s}{numeric: Sparsification exponent, 0 < s < 1; smaller values yield sparser graphs}

\item{class}{string: the class of the returned backbone graph, one of c("original", "matrix", "Matrix", "igraph", "edgelist").
If "original", the backbone graph returned is of the same class as \code{U}.}

\item{narrative}{boolean: TRUE if suggested text & citations should be displayed.}
}
\value{
An unweighted, undirected, unipartite graph of class \code{class}.
}
\description{
\code{sparsify.with.lspar} is a wrapper for \code{\link[=sparsify]{sparsify()}} that extracts the L-spar backbone described by Satuluri et al. (2011).
It is equivalent to \code{sparsify(escore = "jaccard", normalize = "rank", filter = "degree", umst = FALSE)}.
}
\examples{
U <- igraph::sample_sbm(60, matrix(c(.75,.25,.25,.25,.75,.25,.25,.25,.75),3,3), c(20,20,20))
plot(U) #A hairball
sparse <- sparsify.with.lspar(U, s = 0.6, narrative = TRUE)
plot(sparse) #Clearly visible communities
}
\references{
package: {Neal, Z. P. (2022). backbone: An R Package to Extract Network Backbones. \emph{PLOS ONE, 17}, e0269137. \doi{10.1371/journal.pone.0269137}}

model: {Satuluri, V., Parthasarathy, S., & Ruan, Y. (2011, June). Local graph sparsification for scalable clustering. In Proceedings of the 2011 ACM SIGMOD International Conference on Management of data (pp. 721-732). \doi{10.1145/1989323.1989399}}
}
