% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/effect_draw.R
\name{effect_draw}
\alias{effect_draw}
\alias{posterior_predict.baggr}
\title{Make predictive draws from baggr model}
\usage{
effect_draw(
  object,
  draws = NULL,
  newdata = NULL,
  transform = NULL,
  summary = FALSE,
  message = TRUE,
  interval = 0.95
)

\method{posterior_predict}{baggr}(
  object,
  draws = NULL,
  newdata = NULL,
  transform = NULL,
  summary = FALSE,
  message = TRUE,
  interval = 0.95
)
}
\arguments{
\item{object}{A \code{baggr} class object.}

\item{draws}{How many values to draw? The default is as long as the number of samples
in the \code{baggr} object (see \emph{Details}).}

\item{newdata}{an optional data frame containing new values of covariates
that were used when fitting the \code{baggr} model}

\item{transform}{a transformation (an R function) to apply to the result of a draw.}

\item{summary}{logical; if TRUE returns summary statistics rather than samples from the distribution;}

\item{message}{logical; use to disable messages prompted by using this function with
no pooling models}

\item{interval}{uncertainty interval width (numeric between 0 and 1), if \code{summary=TRUE}}
}
\value{
A vector (with \code{draws} values) for models with one treatment effect parameter,
a matrix (\code{draws} rows and same number of columns as number of parameters) otherwise.
If \code{newdata} are specified, an array is returned instead, where the first dimension
corresponds to rows of \code{newdata}.
}
\description{
The function \code{effect_draw} and its alias, \code{posterior_predict}, take the sample
of hyperparameters from a \link{baggr} model
(typically hypermean and hyper-SD, which you can see using \link{treatment_effect})
and draws values of new realisations of treatment effect, i.e. an additional draw from the "population of studies".
This can be used for both prior and posterior draws, depending on \link{baggr} model.
By default this is done for a single new effect, but for meta-regression models
you can specify values of covariates with the \code{newdata} argument, same as in \link{predict}.
}
\details{
The predictive distribution can be used to "combine" heterogeneity between treatment effects and
uncertainty in the mean treatment effect. This is useful both in understanding impact of
heterogeneity (see Riley et al, 2011, for a simple introduction) and for study design e.g.
as priors in analysis of future data (since the draws can be seen as an expected treatment effect
in a hypothetical study).

The default number of samples is the same as what is returned by Stan model implemented in \link{baggr},
(depending on such options as \code{iter}, \code{chains}, \code{thin}). If \code{n} is larger than what is available
in Stan model, we draw values with replacement. This is not recommended and warning is printed in
these cases.

Under default settings in \link{baggr}, a \emph{posterior} predictive distribution is obtained. But
\code{effect_draw} can also be used for \emph{prior} predictive distributions when
setting \code{ppd=T} in \link{baggr}. The two outputs work exactly the same way.

If the \code{baggr} model used by the function is a meta-regression
(i.e. a \code{baggr} model with \code{covariates}), by specifying
the predicted values can be adjusted for known levels of fixed covariates by
passing \code{newdata} (same as in \link{predict}). If no adjustment is made, the
returned value should be interpreted as the effect when all covariates are 0.
}
\references{
Riley, Richard D., Julian P. T. Higgins, and Jonathan J. Deeks.
"Interpretation of Random Effects Meta-Analyses".
\emph{BMJ 342 (10 February 2011).}.
}
\seealso{
\link{treatment_effect} returns samples from hypermean(s) and hyper-SD(s)
which are used by this function
}
