% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Visualizations.R
\name{FnPCA2}
\alias{FnPCA2}
\title{Creating PCA plots with logit(fn) estimates}
\usage{
FnPCA2(obj, Model = c("MLE", "Hybrid", "MCMC"), log_kdeg = FALSE)
}
\arguments{
\item{obj}{bakRFit object}

\item{Model}{String identifying implementation for which you want to generate a PCA plot}

\item{log_kdeg}{Boolean; if TRUE, then log(kdeg) estimates used for PCA rather than logit(fn). Currently
only compatible with MLE implementation}
}
\value{
A ggplot object.
}
\description{
This function creates a 2-component PCA plot using logit(fn) or log(kdeg) estimates.
}
\examples{
\donttest{
# Simulate data for 500 genes and 2 replicates
sim <- Simulate_bakRData(500, nreps = 2)

# Fit data with fast implementation
Fit <- bakRFit(sim$bakRData)

# Fn PCA
FnPCA2(Fit, Model = "MLE")

# log(kdeg) PCA
FnPCA2(Fit, Model = "MLE", log_kdeg = TRUE)

}
}
