#' Generic summary function for metadiag object in bamdit
#' @param object The object generated by the metadiag function.
#'
#' @param digits The number of significant digits printed. The default value is 3.
#'
#' @param intervals A numeric vector of probabilities with values in [0,1]. The default value is
#'                  intervals = c(0.025, 0.5, 0.975).
#'
#' @param ... \dots
#'
#' @export
#'
summary.metadiag <- function(object, digits = 3,  intervals = c(0.025, 0.5, 0.975), ...)
{

  print(object$BUGSoutput, digits= digits, intervals = intervals, ...)

}



