% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fip.R
\name{fip_values}
\alias{fip_values}
\title{Return FIP constants per season}
\usage{
fip_values(dat = NULL, Sep.Leagues = FALSE, Fangraphs = FALSE)
}
\arguments{
\item{dat}{A full pitching table from the \code{Lahman} package or the Chadwick Bureau GitHub repository.
Any subsetting or removal of players will affect your results. All players for each year are recommended.}

\item{Sep.Leagues}{If TRUE, this will split the calculation and return unique FIP constants for the various leagues. This can be
helpful in handling Designated Hitters and National League pitchers. It also isolates the park factors to their respective leagues.}

\item{Fangraphs}{If TRUE the function will return the Fangraphs FIP constants. This can not be used in conjunction with the
\code{Sep.Leagues} argument because Fangraphs does not separate FIP constants by league.}
}
\description{
Get fip constants for each season. By default the function uses a method adapted from
Tom Tango and used by Fangraphs. The function returns FIP constants based on ERA \code{FIP_ERA} as well as constants based on RA \code{FIP_RA}.
Both the Tango and Frangraphs formulas use ERA for their FIP constants.
}
\examples{

data("Pitching2016")
head(Pitching2016)

fip_df <- fip_values(Pitching2016, Fangraphs=FALSE)
head(fip_df)


}
\keyword{average,}
\keyword{base}
\keyword{fangraphs}
\keyword{on}
\keyword{wOBA,}
\keyword{woba,}
