% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bref_standings_on_date.R
\name{bref_standings_on_date}
\alias{bref_standings_on_date}
\title{\strong{Scrape MLB Standings on a Given Date}}
\usage{
bref_standings_on_date(date, division, from = FALSE)
}
\arguments{
\item{date}{a date object}

\item{division}{One or more of AL East, AL Central, AL West,
AL Overall, NL East, NL Central, NL West, and NL Overall}

\item{from}{a logical indicating whether you want standings up to and
including the date (FALSE, default) or rather standings for games played
after the date}
}
\value{
Returns a tibble of MLB standings with the following columns:\tabular{ll}{
   col_name \tab types \cr
   Tm \tab character \cr
   W \tab integer \cr
   L \tab integer \cr
   W-L\% \tab numeric \cr
   GB \tab character \cr
   RS \tab integer \cr
   RA \tab integer \cr
   pythW-L\% \tab numeric \cr
}
}
\description{
This function allows you to scrape the standings from MLB for any date you choose.
}
\examples{
\donttest{
  try(bref_standings_on_date(date = "2015-08-04", division = "AL East"))
}
}
