% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mlb_high_low_stats.R
\name{mlb_high_low_stats}
\alias{mlb_high_low_stats}
\title{\strong{Acquire high/low stats for Major and Minor Leagues}}
\usage{
mlb_high_low_stats(
  org_type,
  season,
  sort_stat,
  team_ids = NULL,
  league_ids = NULL,
  sport_ids = NULL,
  game_type = NULL,
  stat_group = NULL,
  limit = NULL
)
}
\arguments{
\item{org_type}{The organization type for return information (\emph{Required}). Valid values include:
\itemize{
\item player
\item team
\item division
\item league
\item sport
}}

\item{season}{The season for which you want to return information (\emph{Required}).}

\item{sort_stat}{The stat to sort the return  (\emph{Required}). Valid values can be found from 'stat_lookup_param' below\tabular{lllllll}{
   stat_name \tab stat_lookup_param \tab is_counting \tab stat_label \tab stat_groups \tab org_types \tab high_low_types \cr
   at_bats \tab atBats \tab TRUE \tab At bats \tab hitting , pitching \tab PLAYER, TEAM \tab PLAYER, TEAM  , GAME \cr
   total_plate_appearances \tab plateAppearances \tab TRUE \tab Total plate appearances \tab hitting \tab PLAYER, TEAM \tab PLAYER, TEAM  , GAME \cr
   runs \tab runs \tab TRUE \tab Runs \tab hitting \tab PLAYER, TEAM \tab PLAYER, TEAM  , GAME \cr
   runs_batted_in \tab rbi \tab TRUE \tab Runs batted in \tab hitting \tab PLAYER, TEAM \tab PLAYER, TEAM  , GAME \cr
   home_team_runs \tab runs \tab TRUE \tab Home team runs \tab hitting \tab TEAM \tab GAME \cr
   away_team_runs \tab runs \tab TRUE \tab Away team runs \tab hitting \tab TEAM \tab GAME \cr
   hits \tab hits \tab TRUE \tab Hits \tab hitting \tab PLAYER, TEAM \tab PLAYER, TEAM  , GAME \cr
   hits_risp \tab hitsRisp \tab TRUE \tab Hits risp \tab hitting \tab PLAYER, TEAM \tab PLAYER, TEAM \cr
   home_team_hits \tab hits \tab TRUE \tab Home team hits \tab hitting \tab TEAM \tab GAME \cr
   away_team_hits \tab hits \tab TRUE \tab Away team hits \tab hitting \tab TEAM \tab GAME \cr
   total_bases \tab totalBases \tab TRUE \tab Total bases \tab hitting , pitching \tab PLAYER, TEAM \tab PLAYER, TEAM \cr
   doubles \tab doubles \tab TRUE \tab Doubles \tab hitting , pitching \tab PLAYER, TEAM \tab PLAYER, TEAM  , GAME \cr
   triples \tab triples \tab TRUE \tab Triples \tab hitting \tab PLAYER, TEAM \tab PLAYER, TEAM  , GAME \cr
   home_runs \tab homeRuns \tab TRUE \tab Home runs \tab hitting , pitching \tab PLAYER, TEAM \tab PLAYER, TEAM \cr
   extra_base_hits \tab extraBaseHits \tab TRUE \tab Extra base hits \tab hitting \tab PLAYER, TEAM \tab PLAYER, TEAM \cr
   walks \tab baseOnBalls \tab TRUE \tab Walks \tab hitting , pitching \tab PLAYER, TEAM \tab PLAYER, TEAM \cr
   strikeouts \tab strikeouts \tab TRUE \tab Strikeouts \tab hitting , pitching \tab PLAYER, TEAM \tab PLAYER, TEAM \cr
   stolen_bases \tab stolenBases \tab TRUE \tab Stolen bases \tab hitting \tab PLAYER, TEAM \tab PLAYER, TEAM \cr
   caught_stealing \tab caughtStealing \tab TRUE \tab Caught stealing \tab hitting , pitching, fielding \tab PLAYER, TEAM \tab PLAYER, TEAM \cr
   sacrifice_flies \tab sacFlies \tab TRUE \tab Sacrifice flies \tab hitting \tab PLAYER, TEAM \tab PLAYER, TEAM \cr
   sacrifice_bunts \tab sacBunts \tab TRUE \tab Sacrifice bunts \tab hitting \tab PLAYER, TEAM \tab PLAYER, TEAM \cr
   hit_by_pitches \tab hitByPitch \tab TRUE \tab Hit by pitches \tab hitting , pitching \tab PLAYER, TEAM \tab PLAYER, TEAM \cr
   left_on_base \tab leftOnBase \tab TRUE \tab Left on base \tab hitting \tab PLAYER, TEAM \tab PLAYER, TEAM \cr
   ground_into_double_plays \tab groundIntoDoublePlay \tab TRUE \tab Ground into double plays \tab hitting , pitching \tab PLAYER, TEAM \tab PLAYER, TEAM \cr
   strikes \tab strikes \tab TRUE \tab Strikes \tab pitching \tab PLAYER, TEAM \tab PLAYER, TEAM  , GAME \cr
   pitches \tab pitchesThrown \tab TRUE \tab Pitches \tab pitching \tab PLAYER, TEAM \tab PLAYER, TEAM  , GAME \cr
   balks \tab balks \tab TRUE \tab Balks \tab pitching \tab PLAYER, TEAM \tab PLAYER, TEAM  , GAME \cr
   innings_pitched \tab inningsPitched \tab TRUE \tab Innings pitched \tab pitching \tab PLAYER \tab PLAYER \cr
   errors \tab errors \tab TRUE \tab Errors \tab fielding \tab TEAM \tab  \cr
   home_team_errors \tab errors \tab TRUE \tab Home team errors \tab fielding \tab TEAM \tab  \cr
   away_team_errors \tab errors \tab TRUE \tab Away team errors \tab fielding \tab TEAM \tab  \cr
   chances \tab chances \tab TRUE \tab Chances \tab fielding \tab TEAM \tab  \cr
   put_outs \tab putOuts \tab TRUE \tab Put outs \tab fielding \tab TEAM \tab  \cr
   assists \tab assists \tab TRUE \tab Assists \tab fielding \tab TEAM \tab  \cr
   double_plays \tab doublePlays \tab TRUE \tab Double plays \tab fielding \tab TEAM \tab  \cr
   attendance \tab attendance \tab TRUE \tab Attendance \tab game \tab TEAM \tab GAME \cr
   game_time \tab gameDuration \tab TRUE \tab Game time \tab game \tab TEAM \tab GAME \cr
   delay_time \tab gameDuration \tab TRUE \tab Delay time \tab game \tab TEAM \tab GAME \cr
   longest \tab gameDuration \tab TRUE \tab Longest \tab game \tab TEAM \tab  \cr
   shortest \tab gameDuration \tab TRUE \tab Shortest \tab game \tab TEAM \tab  \cr
   inning \tab innings \tab TRUE \tab Inning \tab game \tab TEAM \tab GAME \cr
   win_streak \tab winStreak \tab TRUE \tab Win streak \tab streak \tab TEAM \tab  \cr
   loss_streak \tab lossStreak \tab TRUE \tab Loss streak \tab streak \tab TEAM \tab  \cr
}}

\item{team_ids}{The team_id(s) for which to return information.}

\item{league_ids}{The league_id(s) for which to return information.}

\item{sport_ids}{The sport_id(s) for which to return information.}

\item{game_type}{The game_type for which to return information.}

\item{stat_group}{Stat group for which to return information. Valid values include:\tabular{l}{
   stat_group \cr
   hitting \cr
   pitching \cr
   fielding \cr
   catching \cr
   running \cr
   game \cr
   team \cr
   streak \cr
}}

\item{limit}{Number of records as the limit of the return.}
}
\value{
Returns a tibble with the following columns\tabular{ll}{
   col_name \tab types \cr
   total_splits \tab integer \cr
   season \tab integer \cr
   date \tab character \cr
   is_home \tab logical \cr
   rank \tab integer \cr
   game_innings \tab integer \cr
   stat_at_bats \tab integer \cr
   team_id \tab integer \cr
   team_name \tab character \cr
   team_link \tab character \cr
   opponent_id \tab integer \cr
   opponent_name \tab character \cr
   opponent_link \tab character \cr
   game_pk \tab integer \cr
   game_link \tab character \cr
   game_number \tab integer \cr
   game_content_link \tab character \cr
   home_team_id \tab integer \cr
   home_team_name \tab character \cr
   home_team_link \tab character \cr
   away_team_id \tab integer \cr
   away_team_name \tab character \cr
   away_team_link \tab character \cr
   combined_stats \tab logical \cr
   group_display_name \tab character \cr
   game_type_id \tab character \cr
   game_type_description \tab character \cr
   sort_stat_name \tab character \cr
   sort_stat_lookup_param \tab character \cr
   sort_stat_is_counting \tab logical \cr
   sort_stat_label \tab character \cr
}
}
\description{
\strong{Acquire high/low stats for Major and Minor Leagues}
}
\examples{
\donttest{
  try(mlb_high_low_stats(org_type = 'Team', season = 2020, sort_stat = 'atBats'))
}
}
