% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mlb_standings.R
\name{mlb_standings}
\alias{mlb_standings}
\title{\strong{MLB Standings}}
\usage{
mlb_standings(
  season = NULL,
  date = NULL,
  standings_type = NULL,
  league_id = NULL
)
}
\arguments{
\item{season}{Year(s) to return to return standings information for.}

\item{date}{Date to return to return standings information for.}

\item{standings_type}{The standings_type(s) to return standings information for.
\strong{Description of all standings_types}
\enumerate{
\item regularSeason - Regular Season Standings
\item wildCard - Wild card standings
\item divisionLeaders - Division Leader standings
\item wildCardWithLeaders - Wild card standings with Division Leaders
\item firstHalf - First half standings.  Only valid for leagues with a split season (Mexican League).
\item secondHalf - Second half standings. Only valid for leagues with a split season (Mexican League).
\item springTraining - Spring Training Standings
\item postseason - Postseason Standings
\item byDivision - Standings by Division
\item byConference - Standings by Conference
\item byLeague - Standings by League
}}

\item{league_id}{The league_id(s) to return standings information for.}
}
\value{
Returns a tibble with the following columns\tabular{ll}{
   col_name \tab types \cr
   standings_type \tab character \cr
   last_updated \tab character \cr
   team_records_season \tab character \cr
   team_records_clinch_indicator \tab character \cr
   team_records_division_rank \tab character \cr
   team_records_league_rank \tab character \cr
   team_records_sport_rank \tab character \cr
   team_records_games_played \tab integer \cr
   team_records_games_back \tab character \cr
   team_records_wild_card_games_back \tab character \cr
   team_records_league_games_back \tab character \cr
   team_records_spring_league_games_back \tab character \cr
   team_records_sport_games_back \tab character \cr
   team_records_division_games_back \tab character \cr
   team_records_conference_games_back \tab character \cr
   team_records_last_updated \tab character \cr
   team_records_runs_allowed \tab integer \cr
   team_records_runs_scored \tab integer \cr
   team_records_division_champ \tab logical \cr
   team_records_division_leader \tab logical \cr
   team_records_has_wildcard \tab logical \cr
   team_records_clinched \tab logical \cr
   team_records_elimination_number \tab character \cr
   team_records_wild_card_elimination_number \tab character \cr
   team_records_magic_number \tab character \cr
   team_records_wins \tab integer \cr
   team_records_losses \tab integer \cr
   team_records_run_differential \tab integer \cr
   team_records_winning_percentage \tab character \cr
   team_records_wild_card_rank \tab character \cr
   team_records_wild_card_leader \tab logical \cr
   team_records_team_id \tab integer \cr
   team_records_team_name \tab character \cr
   team_records_team_link \tab character \cr
   team_records_streak_streak_type \tab character \cr
   team_records_streak_streak_number \tab integer \cr
   team_records_streak_streak_code \tab character \cr
   team_records_league_record_wins \tab integer \cr
   team_records_league_record_losses \tab integer \cr
   team_records_league_record_ties \tab integer \cr
   team_records_league_record_pct \tab character \cr
   team_records_records_split_records \tab list \cr
   team_records_records_division_records \tab list \cr
   team_records_records_overall_records \tab list \cr
   team_records_records_league_records \tab list \cr
   team_records_records_expected_records \tab list \cr
   league_id \tab integer \cr
   league_link \tab character \cr
   division_id \tab integer \cr
   division_link \tab character \cr
   sport_id \tab integer \cr
   sport_link \tab character \cr
}
}
\description{
\strong{MLB Standings}
}
\examples{
\donttest{
  try(mlb_standings(season = 2021, league_id = 103))
}
}
