% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sch_statline_from_statcast.R
\name{statline_from_statcast}
\alias{statline_from_statcast}
\title{\strong{Create stat lines from Statcast data}}
\usage{
statline_from_statcast(df, base = "pa")
}
\arguments{
\item{df}{A data frame of statistics that includes, at a minimum, the following columns: events, description, game_date, and type.}

\item{base}{Tells the function what to use as the population of pitches to use for the stat line. Options include "swings", "contact", or "pa". Defaults to "pa".}
}
\value{
A tibble with the additional columns calculated using the Statcast data.
}
\description{
This function allows you to create stat lines of statistics for players or groups of players from raw Statcast. When calculating wOBA, the most recent year in the data frame is used for weighting.
}
\details{
\if{html}{\out{<div class="sourceCode r">}}\preformatted{statline_from_statcast(df, base = "contact")
}\if{html}{\out{</div>}}
}
