% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mlb_teams.R
\name{mlb_teams}
\alias{mlb_teams}
\title{\strong{MLB Teams}}
\usage{
mlb_teams(
  season = NULL,
  active_status = NULL,
  all_star_statuses = NULL,
  league_ids = NULL,
  sport_ids = NULL,
  game_type = NULL
)
}
\arguments{
\item{season}{Year to return to return team information for.}

\item{active_status}{The active statuses to populate teams for a given season.}

\item{all_star_statuses}{The all-star statuses to populate teams for a given season.}

\item{league_ids}{The league_id(s) to return team information for.}

\item{sport_ids}{The sport_id(s) to return team information for.}

\item{game_type}{The game_type to return team information for.}
}
\value{
Returns a tibble with the following columns\tabular{ll}{
   col_name \tab types \cr
   team_id \tab integer \cr
   team_full_name \tab character \cr
   link \tab character \cr
   season \tab integer \cr
   team_code \tab character \cr
   file_code \tab character \cr
   team_abbreviation \tab character \cr
   team_name \tab character \cr
   location_name \tab character \cr
   first_year_of_play \tab character \cr
   short_name \tab character \cr
   franchise_name \tab character \cr
   club_name \tab character \cr
   all_star_status \tab character \cr
   active \tab logical \cr
   venue_id \tab integer \cr
   venue_name \tab character \cr
   venue_link \tab character \cr
   spring_venue_id \tab integer \cr
   spring_venue_link \tab character \cr
   league_id \tab integer \cr
   league_name \tab character \cr
   league_link \tab character \cr
   division_id \tab integer \cr
   division_name \tab character \cr
   division_link \tab character \cr
   sport_id \tab integer \cr
   sport_link \tab character \cr
   sport_name \tab character \cr
   spring_league_id \tab integer \cr
   spring_league_name \tab character \cr
   spring_league_link \tab character \cr
   spring_league_abbreviation \tab character \cr
}
}
\description{
\strong{MLB Teams}
}
\examples{
\donttest{
  try(mlb_teams(season = 2021, sport_ids = c(1)))
}
}
