% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hillModel.R
\name{calculateHillAUC}
\alias{calculateHillAUC}
\title{Calculate the area under the curve for a Hill dose response model}
\usage{
calculateHillAUC(hpar, range, baseline = 0, logbase = 10)
}
\arguments{
\item{hpar}{A four parameter vector specifying the Hill model. Parameter
details are found in the documentation for \code{\link[=evalHillModel]{evalHillModel()}}}

\item{range}{A two element vector specifying the lower and upper bound of
area being calculated}

\item{baseline}{The reference baseline response around which the area is
being calculated. The default value of 0 is generally the most intuitive
choice, but a value of 1 (or 100 in percent) could be used if the
dose-response model is fitting relative survival.}

\item{logbase}{The base of the logarithm applied to concentrations}
}
\value{
A single value specifying the area under the curve in the given range
}
\description{
The area under the curve, or AUC, is a commonly used and robust metric
for evaluating and comparing dose response models. The area is calculated in
a log-concentration space, and so is dependent not only on the concentration
bounds, but also on the base of the logarithm used.  By default, this
function follows the common convention of using base 10.
}
\examples{
auc <- calculateHillAUC(c(1,3,0,75), c(0.05,10))

# Area *over* the curve in survival studies
aoc <- -calculateHillAUC(c(0.1,2,1,0.1), c(0.01,1), baseline=1)
}
