// Generated by rstantools.  Do not edit by hand.

/*
    bayes4psy is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    bayes4psy is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with bayes4psy.  If not, see <http://www.gnu.org/licenses/>.
*/
#ifndef MODELS_HPP
#define MODELS_HPP
#define STAN__SERVICES__COMMAND_HPP
#ifndef USE_STANC3
#define USE_STANC3
#endif
#include <rstan/rstaninc.hpp>
// Code generated by %%NAME%% %%VERSION%%
#include <stan/model/model_header.hpp>
namespace model_reaction_time_namespace {
inline void validate_positive_index(const char* var_name, const char* expr,
                                    int val) {
  if (val < 1) {
    std::stringstream msg;
    msg << "Found dimension size less than one in simplex declaration"
        << "; variable=" << var_name << "; dimension size expression=" << expr
        << "; expression value=" << val;
    std::string msg_str(msg.str());
    throw std::invalid_argument(msg_str.c_str());
  }
}
inline void validate_unit_vector_index(const char* var_name, const char* expr,
                                       int val) {
  if (val <= 1) {
    std::stringstream msg;
    if (val == 1) {
      msg << "Found dimension size one in unit vector declaration."
          << " One-dimensional unit vector is discrete"
          << " but the target distribution must be continuous."
          << " variable=" << var_name << "; dimension size expression=" << expr;
    } else {
      msg << "Found dimension size less than one in unit vector declaration"
          << "; variable=" << var_name << "; dimension size expression=" << expr
          << "; expression value=" << val;
    }
    std::string msg_str(msg.str());
    throw std::invalid_argument(msg_str.c_str());
  }
}
using std::istream;
using std::string;
using std::stringstream;
using std::vector;
using std::pow;
using stan::io::dump;
using stan::math::lgamma;
using stan::model::model_base_crtp;
using stan::model::rvalue;
using stan::model::cons_list;
using stan::model::index_uni;
using stan::model::index_max;
using stan::model::index_min;
using stan::model::index_min_max;
using stan::model::index_multi;
using stan::model::index_omni;
using stan::model::nil_index_list;
using namespace stan::math;
using stan::math::pow; 
stan::math::profile_map profiles__;
static int current_statement__= 0;
static const std::vector<string> locations_array__ = {" (found before start of program)",
                                                      " (in 'string', line 12, column 2 to column 24)",
                                                      " (in 'string', line 13, column 2 to column 27)",
                                                      " (in 'string', line 14, column 2 to column 28)",
                                                      " (in 'string', line 16, column 2 to column 21)",
                                                      " (in 'string', line 17, column 2 to column 24)",
                                                      " (in 'string', line 18, column 2 to column 21)",
                                                      " (in 'string', line 19, column 2 to column 24)",
                                                      " (in 'string', line 20, column 2 to column 24)",
                                                      " (in 'string', line 21, column 2 to column 24)",
                                                      " (in 'string', line 100, column 2 to column 10)",
                                                      " (in 'string', line 101, column 2 to column 24)",
                                                      " (in 'string', line 102, column 2 to column 21)",
                                                      " (in 'string', line 104, column 4 to column 41)",
                                                      " (in 'string', line 103, column 17 to line 105, column 3)",
                                                      " (in 'string', line 103, column 2 to line 105, column 3)",
                                                      " (in 'string', line 26, column 2 to column 13)",
                                                      " (in 'string', line 34, column 4 to column 50)",
                                                      " (in 'string', line 33, column 29 to line 35, column 3)",
                                                      " (in 'string', line 33, column 9 to line 35, column 3)",
                                                      " (in 'string', line 32, column 4 to column 51)",
                                                      " (in 'string', line 31, column 29 to line 33, column 3)",
                                                      " (in 'string', line 31, column 9 to line 35, column 3)",
                                                      " (in 'string', line 30, column 4 to column 52)",
                                                      " (in 'string', line 29, column 29 to line 31, column 3)",
                                                      " (in 'string', line 29, column 9 to line 35, column 3)",
                                                      " (in 'string', line 28, column 4 to column 53)",
                                                      " (in 'string', line 27, column 22 to line 29, column 3)",
                                                      " (in 'string', line 27, column 2 to line 35, column 3)",
                                                      " (in 'string', line 37, column 2 to column 9)",
                                                      " (in 'string', line 45, column 4 to column 53)",
                                                      " (in 'string', line 44, column 29 to line 46, column 3)",
                                                      " (in 'string', line 44, column 9 to line 46, column 3)",
                                                      " (in 'string', line 43, column 4 to column 54)",
                                                      " (in 'string', line 42, column 29 to line 44, column 3)",
                                                      " (in 'string', line 42, column 9 to line 46, column 3)",
                                                      " (in 'string', line 41, column 4 to column 55)",
                                                      " (in 'string', line 40, column 29 to line 42, column 3)",
                                                      " (in 'string', line 40, column 9 to line 46, column 3)",
                                                      " (in 'string', line 39, column 4 to column 56)",
                                                      " (in 'string', line 38, column 22 to line 40, column 3)",
                                                      " (in 'string', line 38, column 2 to line 46, column 3)",
                                                      " (in 'string', line 48, column 2 to column 9)",
                                                      " (in 'string', line 56, column 4 to column 50)",
                                                      " (in 'string', line 55, column 29 to line 57, column 3)",
                                                      " (in 'string', line 55, column 9 to line 57, column 3)",
                                                      " (in 'string', line 54, column 4 to column 51)",
                                                      " (in 'string', line 53, column 29 to line 55, column 3)",
                                                      " (in 'string', line 53, column 9 to line 57, column 3)",
                                                      " (in 'string', line 52, column 4 to column 52)",
                                                      " (in 'string', line 51, column 29 to line 53, column 3)",
                                                      " (in 'string', line 51, column 9 to line 57, column 3)",
                                                      " (in 'string', line 50, column 4 to column 53)",
                                                      " (in 'string', line 49, column 22 to line 51, column 3)",
                                                      " (in 'string', line 49, column 2 to line 57, column 3)",
                                                      " (in 'string', line 59, column 2 to column 9)",
                                                      " (in 'string', line 67, column 4 to column 53)",
                                                      " (in 'string', line 66, column 29 to line 68, column 3)",
                                                      " (in 'string', line 66, column 9 to line 68, column 3)",
                                                      " (in 'string', line 65, column 4 to column 54)",
                                                      " (in 'string', line 64, column 29 to line 66, column 3)",
                                                      " (in 'string', line 64, column 9 to line 68, column 3)",
                                                      " (in 'string', line 63, column 4 to column 55)",
                                                      " (in 'string', line 62, column 29 to line 64, column 3)",
                                                      " (in 'string', line 62, column 9 to line 68, column 3)",
                                                      " (in 'string', line 61, column 4 to column 56)",
                                                      " (in 'string', line 60, column 22 to line 62, column 3)",
                                                      " (in 'string', line 60, column 2 to line 68, column 3)",
                                                      " (in 'string', line 70, column 2 to column 9)",
                                                      " (in 'string', line 78, column 4 to column 50)",
                                                      " (in 'string', line 77, column 29 to line 79, column 3)",
                                                      " (in 'string', line 77, column 9 to line 79, column 3)",
                                                      " (in 'string', line 76, column 4 to column 51)",
                                                      " (in 'string', line 75, column 29 to line 77, column 3)",
                                                      " (in 'string', line 75, column 9 to line 79, column 3)",
                                                      " (in 'string', line 74, column 4 to column 52)",
                                                      " (in 'string', line 73, column 29 to line 75, column 3)",
                                                      " (in 'string', line 73, column 9 to line 79, column 3)",
                                                      " (in 'string', line 72, column 4 to column 53)",
                                                      " (in 'string', line 71, column 22 to line 73, column 3)",
                                                      " (in 'string', line 71, column 2 to line 79, column 3)",
                                                      " (in 'string', line 81, column 2 to column 9)",
                                                      " (in 'string', line 89, column 4 to column 53)",
                                                      " (in 'string', line 88, column 29 to line 90, column 3)",
                                                      " (in 'string', line 88, column 9 to line 90, column 3)",
                                                      " (in 'string', line 87, column 4 to column 54)",
                                                      " (in 'string', line 86, column 29 to line 88, column 3)",
                                                      " (in 'string', line 86, column 9 to line 90, column 3)",
                                                      " (in 'string', line 85, column 4 to column 55)",
                                                      " (in 'string', line 84, column 29 to line 86, column 3)",
                                                      " (in 'string', line 84, column 9 to line 90, column 3)",
                                                      " (in 'string', line 83, column 4 to column 56)",
                                                      " (in 'string', line 82, column 22 to line 84, column 3)",
                                                      " (in 'string', line 82, column 2 to line 90, column 3)",
                                                      " (in 'string', line 91, column 2 to column 29)",
                                                      " (in 'string', line 92, column 2 to column 32)",
                                                      " (in 'string', line 93, column 2 to column 33)",
                                                      " (in 'string', line 96, column 4 to column 63)",
                                                      " (in 'string', line 95, column 17 to line 97, column 3)",
                                                      " (in 'string', line 95, column 2 to line 97, column 3)",
                                                      " (in 'string', line 2, column 2 to column 17)",
                                                      " (in 'string', line 3, column 2 to column 17)",
                                                      " (in 'string', line 4, column 18 to column 19)",
                                                      " (in 'string', line 4, column 2 to column 23)",
                                                      " (in 'string', line 5, column 17 to column 18)",
                                                      " (in 'string', line 5, column 2 to column 20)",
                                                      " (in 'string', line 7, column 2 to column 15)",
                                                      " (in 'string', line 8, column 2 to column 20)",
                                                      " (in 'string', line 12, column 18 to column 19)",
                                                      " (in 'string', line 13, column 18 to column 19)",
                                                      " (in 'string', line 14, column 18 to column 19)",
                                                      " (in 'string', line 101, column 9 to column 10)"};
#include <stan_meta_header.hpp>
class model_reaction_time final : public model_base_crtp<model_reaction_time> {
private:
  int n;
  int m;
  Eigen::Matrix<double, -1, 1> t;
  std::vector<int> s;
  std::vector<int> p_ids;
  std::vector<double> p_values;
 
public:
  ~model_reaction_time() { }
  
  inline std::string model_name() const final { return "model_reaction_time"; }
  inline std::vector<std::string> model_compile_info() const noexcept {
    return std::vector<std::string>{"stanc_version = %%NAME%%3 %%VERSION%%", "stancflags = "};
  }
  
  
  model_reaction_time(stan::io::var_context& context__,
                      unsigned int random_seed__ = 0,
                      std::ostream* pstream__ = nullptr) : model_base_crtp(0) {
    using local_scalar_t__ = double ;
    boost::ecuyer1988 base_rng__ = 
        stan::services::util::create_rng(random_seed__, 0);
    (void) base_rng__;  // suppress unused var warning
    static const char* function__ = "model_reaction_time_namespace::model_reaction_time";
    (void) function__;  // suppress unused var warning
    local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
    (void) DUMMY_VAR__;  // suppress unused var warning
    
    try {
      int pos__;
      pos__ = std::numeric_limits<int>::min();
      
      pos__ = 1;
      current_statement__ = 100;
      context__.validate_dims("data initialization","n","int",
          context__.to_vec());
      n = std::numeric_limits<int>::min();
      
      current_statement__ = 100;
      n = context__.vals_i("n")[(1 - 1)];
      current_statement__ = 100;
      current_statement__ = 100;
      check_greater_or_equal(function__, "n", n, 0);
      current_statement__ = 101;
      context__.validate_dims("data initialization","m","int",
          context__.to_vec());
      m = std::numeric_limits<int>::min();
      
      current_statement__ = 101;
      m = context__.vals_i("m")[(1 - 1)];
      current_statement__ = 101;
      current_statement__ = 101;
      check_greater_or_equal(function__, "m", m, 0);
      current_statement__ = 102;
      validate_non_negative_index("t", "n", n);
      current_statement__ = 103;
      context__.validate_dims("data initialization","t","double",
          context__.to_vec(n));
      t = Eigen::Matrix<double, -1, 1>(n);
      stan::math::fill(t, std::numeric_limits<double>::quiet_NaN());
      
      {
        std::vector<local_scalar_t__> t_flat__;
        current_statement__ = 103;
        assign(t_flat__, nil_index_list(), context__.vals_r("t"),
          "assigning variable t_flat__");
        current_statement__ = 103;
        pos__ = 1;
        current_statement__ = 103;
        for (int sym1__ = 1; sym1__ <= n; ++sym1__) {
          current_statement__ = 103;
          assign(t, cons_list(index_uni(sym1__), nil_index_list()),
            t_flat__[(pos__ - 1)], "assigning variable t");
          current_statement__ = 103;
          pos__ = (pos__ + 1);}
      }
      current_statement__ = 103;
      for (int sym1__ = 1; sym1__ <= n; ++sym1__) {
        current_statement__ = 103;
        current_statement__ = 103;
        check_greater_or_equal(function__, "t[sym1__]", t[(sym1__ - 1)], 0);}
      current_statement__ = 104;
      validate_non_negative_index("s", "n", n);
      current_statement__ = 105;
      context__.validate_dims("data initialization","s","int",
          context__.to_vec(n));
      s = std::vector<int>(n, std::numeric_limits<int>::min());
      
      current_statement__ = 105;
      assign(s, nil_index_list(), context__.vals_i("s"),
        "assigning variable s");
      current_statement__ = 105;
      for (int sym1__ = 1; sym1__ <= n; ++sym1__) {
        current_statement__ = 105;
        current_statement__ = 105;
        check_greater_or_equal(function__, "s[sym1__]", s[(sym1__ - 1)], 0);}
      current_statement__ = 106;
      context__.validate_dims("data initialization","p_ids","int",
          context__.to_vec(6));
      p_ids = std::vector<int>(6, std::numeric_limits<int>::min());
      
      current_statement__ = 106;
      assign(p_ids, nil_index_list(), context__.vals_i("p_ids"),
        "assigning variable p_ids");
      current_statement__ = 107;
      context__.validate_dims("data initialization","p_values","double",
          context__.to_vec(12));
      p_values = std::vector<double>(12, std::numeric_limits<double>::quiet_NaN());
      
      current_statement__ = 107;
      assign(p_values, nil_index_list(), context__.vals_r("p_values"),
        "assigning variable p_values");
      current_statement__ = 108;
      validate_non_negative_index("mu", "m", m);
      current_statement__ = 109;
      validate_non_negative_index("sigma", "m", m);
      current_statement__ = 110;
      validate_non_negative_index("lambda", "m", m);
      current_statement__ = 111;
      validate_non_negative_index("rt_subjects", "m", m);
    } catch (const std::exception& e) {
      stan::lang::rethrow_located(e, locations_array__[current_statement__]);
      // Next line prevents compiler griping about no return
      throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***"); 
    }
    num_params_r__ = 0U;
    
    try {
      num_params_r__ += m;
      num_params_r__ += m;
      num_params_r__ += m;
      num_params_r__ += 1;
      num_params_r__ += 1;
      num_params_r__ += 1;
      num_params_r__ += 1;
      num_params_r__ += 1;
      num_params_r__ += 1;
    } catch (const std::exception& e) {
      stan::lang::rethrow_located(e, locations_array__[current_statement__]);
      // Next line prevents compiler griping about no return
      throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***"); 
    }
  }
  template <bool propto__, bool jacobian__, typename VecR, typename VecI, stan::require_vector_like_t<VecR>* = nullptr, stan::require_vector_like_vt<std::is_integral, VecI>* = nullptr>
  inline stan::scalar_type_t<VecR> log_prob_impl(VecR& params_r__,
                                                 VecI& params_i__,
                                                 std::ostream* pstream__ = nullptr) const {
    using T__ = stan::scalar_type_t<VecR>;
    using local_scalar_t__ = T__;
    T__ lp__(0.0);
    stan::math::accumulator<T__> lp_accum__;
    static const char* function__ = "model_reaction_time_namespace::log_prob";
(void) function__;  // suppress unused var warning
    stan::io::reader<local_scalar_t__> in__(params_r__, params_i__);
    local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
    (void) DUMMY_VAR__;  // suppress unused var warning
    
    try {
      Eigen::Matrix<local_scalar_t__, -1, 1> mu;
      mu = Eigen::Matrix<local_scalar_t__, -1, 1>(m);
      stan::math::fill(mu, DUMMY_VAR__);
      
      current_statement__ = 1;
      mu = in__.vector(m);
      current_statement__ = 1;
      for (int sym1__ = 1; sym1__ <= m; ++sym1__) {
        current_statement__ = 1;
        if (jacobian__) {
          current_statement__ = 1;
          assign(mu, cons_list(index_uni(sym1__), nil_index_list()),
            stan::math::lb_constrain(mu[(sym1__ - 1)], 0, lp__),
            "assigning variable mu");
        } else {
          current_statement__ = 1;
          assign(mu, cons_list(index_uni(sym1__), nil_index_list()),
            stan::math::lb_constrain(mu[(sym1__ - 1)], 0),
            "assigning variable mu");
        }}
      Eigen::Matrix<local_scalar_t__, -1, 1> sigma;
      sigma = Eigen::Matrix<local_scalar_t__, -1, 1>(m);
      stan::math::fill(sigma, DUMMY_VAR__);
      
      current_statement__ = 2;
      sigma = in__.vector(m);
      current_statement__ = 2;
      for (int sym1__ = 1; sym1__ <= m; ++sym1__) {
        current_statement__ = 2;
        if (jacobian__) {
          current_statement__ = 2;
          assign(sigma, cons_list(index_uni(sym1__), nil_index_list()),
            stan::math::lb_constrain(sigma[(sym1__ - 1)], 0, lp__),
            "assigning variable sigma");
        } else {
          current_statement__ = 2;
          assign(sigma, cons_list(index_uni(sym1__), nil_index_list()),
            stan::math::lb_constrain(sigma[(sym1__ - 1)], 0),
            "assigning variable sigma");
        }}
      Eigen::Matrix<local_scalar_t__, -1, 1> lambda;
      lambda = Eigen::Matrix<local_scalar_t__, -1, 1>(m);
      stan::math::fill(lambda, DUMMY_VAR__);
      
      current_statement__ = 3;
      lambda = in__.vector(m);
      current_statement__ = 3;
      for (int sym1__ = 1; sym1__ <= m; ++sym1__) {
        current_statement__ = 3;
        if (jacobian__) {
          current_statement__ = 3;
          assign(lambda, cons_list(index_uni(sym1__), nil_index_list()),
            stan::math::lb_constrain(lambda[(sym1__ - 1)], 0, lp__),
            "assigning variable lambda");
        } else {
          current_statement__ = 3;
          assign(lambda, cons_list(index_uni(sym1__), nil_index_list()),
            stan::math::lb_constrain(lambda[(sym1__ - 1)], 0),
            "assigning variable lambda");
        }}
      local_scalar_t__ mu_m;
      mu_m = DUMMY_VAR__;
      
      current_statement__ = 4;
      mu_m = in__.scalar();
      current_statement__ = 4;
      if (jacobian__) {
        current_statement__ = 4;
        mu_m = stan::math::lb_constrain(mu_m, 0, lp__);
      } else {
        current_statement__ = 4;
        mu_m = stan::math::lb_constrain(mu_m, 0);
      }
      local_scalar_t__ mu_l;
      mu_l = DUMMY_VAR__;
      
      current_statement__ = 5;
      mu_l = in__.scalar();
      current_statement__ = 5;
      if (jacobian__) {
        current_statement__ = 5;
        mu_l = stan::math::lb_constrain(mu_l, 0.05, lp__);
      } else {
        current_statement__ = 5;
        mu_l = stan::math::lb_constrain(mu_l, 0.05);
      }
      local_scalar_t__ mu_s;
      mu_s = DUMMY_VAR__;
      
      current_statement__ = 6;
      mu_s = in__.scalar();
      current_statement__ = 6;
      if (jacobian__) {
        current_statement__ = 6;
        mu_s = stan::math::lb_constrain(mu_s, 0, lp__);
      } else {
        current_statement__ = 6;
        mu_s = stan::math::lb_constrain(mu_s, 0);
      }
      local_scalar_t__ sigma_m;
      sigma_m = DUMMY_VAR__;
      
      current_statement__ = 7;
      sigma_m = in__.scalar();
      current_statement__ = 7;
      if (jacobian__) {
        current_statement__ = 7;
        sigma_m = stan::math::lb_constrain(sigma_m, 0, lp__);
      } else {
        current_statement__ = 7;
        sigma_m = stan::math::lb_constrain(sigma_m, 0);
      }
      local_scalar_t__ sigma_l;
      sigma_l = DUMMY_VAR__;
      
      current_statement__ = 8;
      sigma_l = in__.scalar();
      current_statement__ = 8;
      if (jacobian__) {
        current_statement__ = 8;
        sigma_l = stan::math::lb_constrain(sigma_l, 0, lp__);
      } else {
        current_statement__ = 8;
        sigma_l = stan::math::lb_constrain(sigma_l, 0);
      }
      local_scalar_t__ sigma_s;
      sigma_s = DUMMY_VAR__;
      
      current_statement__ = 9;
      sigma_s = in__.scalar();
      current_statement__ = 9;
      if (jacobian__) {
        current_statement__ = 9;
        sigma_s = stan::math::lb_constrain(sigma_s, 0, lp__);
      } else {
        current_statement__ = 9;
        sigma_s = stan::math::lb_constrain(sigma_s, 0);
      }
      {
        int id;
        id = std::numeric_limits<int>::min();
        
        current_statement__ = 16;
        id = 1;
        current_statement__ = 28;
        if (logical_eq(p_ids[(id - 1)], 1)) {
          current_statement__ = 26;
          lp_accum__.add(
            uniform_lpdf<propto__>(mu_m, p_values[(((id * 2) - 1) - 1)],
              p_values[((id * 2) - 1)]));
        } else {
          current_statement__ = 25;
          if (logical_eq(p_ids[(id - 1)], 2)) {
            current_statement__ = 23;
            lp_accum__.add(
              normal_lpdf<propto__>(mu_m, p_values[(((id * 2) - 1) - 1)],
                p_values[((id * 2) - 1)]));
          } else {
            current_statement__ = 22;
            if (logical_eq(p_ids[(id - 1)], 3)) {
              current_statement__ = 20;
              lp_accum__.add(
                gamma_lpdf<propto__>(mu_m, p_values[(((id * 2) - 1) - 1)],
                  p_values[((id * 2) - 1)]));
            } else {
              current_statement__ = 19;
              if (logical_eq(p_ids[(id - 1)], 4)) {
                current_statement__ = 17;
                lp_accum__.add(
                  beta_lpdf<propto__>(mu_m, p_values[(((id * 2) - 1) - 1)],
                    p_values[((id * 2) - 1)]));
              } 
            }
          }
        }
        current_statement__ = 29;
        id = 2;
        current_statement__ = 41;
        if (logical_eq(p_ids[(id - 1)], 1)) {
          current_statement__ = 39;
          lp_accum__.add(
            uniform_lpdf<propto__>(sigma_m, p_values[(((id * 2) - 1) - 1)],
              p_values[((id * 2) - 1)]));
        } else {
          current_statement__ = 38;
          if (logical_eq(p_ids[(id - 1)], 2)) {
            current_statement__ = 36;
            lp_accum__.add(
              normal_lpdf<propto__>(sigma_m, p_values[(((id * 2) - 1) - 1)],
                p_values[((id * 2) - 1)]));
          } else {
            current_statement__ = 35;
            if (logical_eq(p_ids[(id - 1)], 3)) {
              current_statement__ = 33;
              lp_accum__.add(
                gamma_lpdf<propto__>(sigma_m, p_values[(((id * 2) - 1) - 1)],
                  p_values[((id * 2) - 1)]));
            } else {
              current_statement__ = 32;
              if (logical_eq(p_ids[(id - 1)], 4)) {
                current_statement__ = 30;
                lp_accum__.add(
                  beta_lpdf<propto__>(sigma_m,
                    p_values[(((id * 2) - 1) - 1)], p_values[((id * 2) - 1)]));
              } 
            }
          }
        }
        current_statement__ = 42;
        id = 3;
        current_statement__ = 54;
        if (logical_eq(p_ids[(id - 1)], 1)) {
          current_statement__ = 52;
          lp_accum__.add(
            uniform_lpdf<propto__>(mu_s, p_values[(((id * 2) - 1) - 1)],
              p_values[((id * 2) - 1)]));
        } else {
          current_statement__ = 51;
          if (logical_eq(p_ids[(id - 1)], 2)) {
            current_statement__ = 49;
            lp_accum__.add(
              normal_lpdf<propto__>(mu_s, p_values[(((id * 2) - 1) - 1)],
                p_values[((id * 2) - 1)]));
          } else {
            current_statement__ = 48;
            if (logical_eq(p_ids[(id - 1)], 3)) {
              current_statement__ = 46;
              lp_accum__.add(
                gamma_lpdf<propto__>(mu_s, p_values[(((id * 2) - 1) - 1)],
                  p_values[((id * 2) - 1)]));
            } else {
              current_statement__ = 45;
              if (logical_eq(p_ids[(id - 1)], 4)) {
                current_statement__ = 43;
                lp_accum__.add(
                  beta_lpdf<propto__>(mu_s, p_values[(((id * 2) - 1) - 1)],
                    p_values[((id * 2) - 1)]));
              } 
            }
          }
        }
        current_statement__ = 55;
        id = 4;
        current_statement__ = 67;
        if (logical_eq(p_ids[(id - 1)], 1)) {
          current_statement__ = 65;
          lp_accum__.add(
            uniform_lpdf<propto__>(sigma_s, p_values[(((id * 2) - 1) - 1)],
              p_values[((id * 2) - 1)]));
        } else {
          current_statement__ = 64;
          if (logical_eq(p_ids[(id - 1)], 2)) {
            current_statement__ = 62;
            lp_accum__.add(
              normal_lpdf<propto__>(sigma_s, p_values[(((id * 2) - 1) - 1)],
                p_values[((id * 2) - 1)]));
          } else {
            current_statement__ = 61;
            if (logical_eq(p_ids[(id - 1)], 3)) {
              current_statement__ = 59;
              lp_accum__.add(
                gamma_lpdf<propto__>(sigma_s, p_values[(((id * 2) - 1) - 1)],
                  p_values[((id * 2) - 1)]));
            } else {
              current_statement__ = 58;
              if (logical_eq(p_ids[(id - 1)], 4)) {
                current_statement__ = 56;
                lp_accum__.add(
                  beta_lpdf<propto__>(sigma_s,
                    p_values[(((id * 2) - 1) - 1)], p_values[((id * 2) - 1)]));
              } 
            }
          }
        }
        current_statement__ = 68;
        id = 5;
        current_statement__ = 80;
        if (logical_eq(p_ids[(id - 1)], 1)) {
          current_statement__ = 78;
          lp_accum__.add(
            uniform_lpdf<propto__>(mu_l, p_values[(((id * 2) - 1) - 1)],
              p_values[((id * 2) - 1)]));
        } else {
          current_statement__ = 77;
          if (logical_eq(p_ids[(id - 1)], 2)) {
            current_statement__ = 75;
            lp_accum__.add(
              normal_lpdf<propto__>(mu_l, p_values[(((id * 2) - 1) - 1)],
                p_values[((id * 2) - 1)]));
          } else {
            current_statement__ = 74;
            if (logical_eq(p_ids[(id - 1)], 3)) {
              current_statement__ = 72;
              lp_accum__.add(
                gamma_lpdf<propto__>(mu_l, p_values[(((id * 2) - 1) - 1)],
                  p_values[((id * 2) - 1)]));
            } else {
              current_statement__ = 71;
              if (logical_eq(p_ids[(id - 1)], 4)) {
                current_statement__ = 69;
                lp_accum__.add(
                  beta_lpdf<propto__>(mu_l, p_values[(((id * 2) - 1) - 1)],
                    p_values[((id * 2) - 1)]));
              } 
            }
          }
        }
        current_statement__ = 81;
        id = 6;
        current_statement__ = 93;
        if (logical_eq(p_ids[(id - 1)], 1)) {
          current_statement__ = 91;
          lp_accum__.add(
            uniform_lpdf<propto__>(sigma_l, p_values[(((id * 2) - 1) - 1)],
              p_values[((id * 2) - 1)]));
        } else {
          current_statement__ = 90;
          if (logical_eq(p_ids[(id - 1)], 2)) {
            current_statement__ = 88;
            lp_accum__.add(
              normal_lpdf<propto__>(sigma_l, p_values[(((id * 2) - 1) - 1)],
                p_values[((id * 2) - 1)]));
          } else {
            current_statement__ = 87;
            if (logical_eq(p_ids[(id - 1)], 3)) {
              current_statement__ = 85;
              lp_accum__.add(
                gamma_lpdf<propto__>(sigma_l, p_values[(((id * 2) - 1) - 1)],
                  p_values[((id * 2) - 1)]));
            } else {
              current_statement__ = 84;
              if (logical_eq(p_ids[(id - 1)], 4)) {
                current_statement__ = 82;
                lp_accum__.add(
                  beta_lpdf<propto__>(sigma_l,
                    p_values[(((id * 2) - 1) - 1)], p_values[((id * 2) - 1)]));
              } 
            }
          }
        }
        current_statement__ = 94;
        lp_accum__.add(normal_lpdf<propto__>(mu, mu_m, sigma_m));
        current_statement__ = 95;
        lp_accum__.add(normal_lpdf<propto__>(sigma, mu_s, sigma_s));
        current_statement__ = 96;
        lp_accum__.add(normal_lpdf<propto__>(lambda, mu_l, sigma_l));
        current_statement__ = 99;
        for (int i = 1; i <= n; ++i) {
          current_statement__ = 97;
          lp_accum__.add(
            exp_mod_normal_lpdf<propto__>(t[(i - 1)], mu[(s[(i - 1)] - 1)],
              sigma[(s[(i - 1)] - 1)], lambda[(s[(i - 1)] - 1)]));}
      }
    } catch (const std::exception& e) {
      stan::lang::rethrow_located(e, locations_array__[current_statement__]);
      // Next line prevents compiler griping about no return
      throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***"); 
    }
    lp_accum__.add(lp__);
    return lp_accum__.sum();
    } // log_prob_impl() 
    
  template <typename RNG, typename VecR, typename VecI, typename VecVar, stan::require_vector_like_vt<std::is_floating_point, VecR>* = nullptr, stan::require_vector_like_vt<std::is_integral, VecI>* = nullptr, stan::require_std_vector_vt<std::is_floating_point, VecVar>* = nullptr>
  inline void write_array_impl(RNG& base_rng__, VecR& params_r__,
                               VecI& params_i__, VecVar& vars__,
                               const bool emit_transformed_parameters__ = true,
                               const bool emit_generated_quantities__ = true,
                               std::ostream* pstream__ = nullptr) const {
    using local_scalar_t__ = double;
    vars__.resize(0);
    stan::io::reader<local_scalar_t__> in__(params_r__, params_i__);
    static const char* function__ = "model_reaction_time_namespace::write_array";
(void) function__;  // suppress unused var warning
    (void) function__;  // suppress unused var warning
    double lp__ = 0.0;
    (void) lp__;  // dummy to suppress unused var warning
    stan::math::accumulator<double> lp_accum__;
    local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
    (void) DUMMY_VAR__;  // suppress unused var warning
    
    try {
      Eigen::Matrix<double, -1, 1> mu;
      mu = Eigen::Matrix<double, -1, 1>(m);
      stan::math::fill(mu, std::numeric_limits<double>::quiet_NaN());
      
      current_statement__ = 1;
      mu = in__.vector(m);
      current_statement__ = 1;
      for (int sym1__ = 1; sym1__ <= m; ++sym1__) {
        current_statement__ = 1;
        assign(mu, cons_list(index_uni(sym1__), nil_index_list()),
          stan::math::lb_constrain(mu[(sym1__ - 1)], 0),
          "assigning variable mu");}
      Eigen::Matrix<double, -1, 1> sigma;
      sigma = Eigen::Matrix<double, -1, 1>(m);
      stan::math::fill(sigma, std::numeric_limits<double>::quiet_NaN());
      
      current_statement__ = 2;
      sigma = in__.vector(m);
      current_statement__ = 2;
      for (int sym1__ = 1; sym1__ <= m; ++sym1__) {
        current_statement__ = 2;
        assign(sigma, cons_list(index_uni(sym1__), nil_index_list()),
          stan::math::lb_constrain(sigma[(sym1__ - 1)], 0),
          "assigning variable sigma");}
      Eigen::Matrix<double, -1, 1> lambda;
      lambda = Eigen::Matrix<double, -1, 1>(m);
      stan::math::fill(lambda, std::numeric_limits<double>::quiet_NaN());
      
      current_statement__ = 3;
      lambda = in__.vector(m);
      current_statement__ = 3;
      for (int sym1__ = 1; sym1__ <= m; ++sym1__) {
        current_statement__ = 3;
        assign(lambda, cons_list(index_uni(sym1__), nil_index_list()),
          stan::math::lb_constrain(lambda[(sym1__ - 1)], 0),
          "assigning variable lambda");}
      double mu_m;
      mu_m = std::numeric_limits<double>::quiet_NaN();
      
      current_statement__ = 4;
      mu_m = in__.scalar();
      current_statement__ = 4;
      mu_m = stan::math::lb_constrain(mu_m, 0);
      double mu_l;
      mu_l = std::numeric_limits<double>::quiet_NaN();
      
      current_statement__ = 5;
      mu_l = in__.scalar();
      current_statement__ = 5;
      mu_l = stan::math::lb_constrain(mu_l, 0.05);
      double mu_s;
      mu_s = std::numeric_limits<double>::quiet_NaN();
      
      current_statement__ = 6;
      mu_s = in__.scalar();
      current_statement__ = 6;
      mu_s = stan::math::lb_constrain(mu_s, 0);
      double sigma_m;
      sigma_m = std::numeric_limits<double>::quiet_NaN();
      
      current_statement__ = 7;
      sigma_m = in__.scalar();
      current_statement__ = 7;
      sigma_m = stan::math::lb_constrain(sigma_m, 0);
      double sigma_l;
      sigma_l = std::numeric_limits<double>::quiet_NaN();
      
      current_statement__ = 8;
      sigma_l = in__.scalar();
      current_statement__ = 8;
      sigma_l = stan::math::lb_constrain(sigma_l, 0);
      double sigma_s;
      sigma_s = std::numeric_limits<double>::quiet_NaN();
      
      current_statement__ = 9;
      sigma_s = in__.scalar();
      current_statement__ = 9;
      sigma_s = stan::math::lb_constrain(sigma_s, 0);
      for (int sym1__ = 1; sym1__ <= m; ++sym1__) {
        vars__.emplace_back(mu[(sym1__ - 1)]);}
      for (int sym1__ = 1; sym1__ <= m; ++sym1__) {
        vars__.emplace_back(sigma[(sym1__ - 1)]);}
      for (int sym1__ = 1; sym1__ <= m; ++sym1__) {
        vars__.emplace_back(lambda[(sym1__ - 1)]);}
      vars__.emplace_back(mu_m);
      vars__.emplace_back(mu_l);
      vars__.emplace_back(mu_s);
      vars__.emplace_back(sigma_m);
      vars__.emplace_back(sigma_l);
      vars__.emplace_back(sigma_s);
      if (logical_negation((primitive_value(emit_transformed_parameters__) ||
            primitive_value(emit_generated_quantities__)))) {
        return ;
      } 
      if (logical_negation(emit_generated_quantities__)) {
        return ;
      } 
      double rt;
      rt = std::numeric_limits<double>::quiet_NaN();
      
      Eigen::Matrix<double, -1, 1> rt_subjects;
      rt_subjects = Eigen::Matrix<double, -1, 1>(m);
      stan::math::fill(rt_subjects, std::numeric_limits<double>::quiet_NaN());
      
      current_statement__ = 12;
      rt = (mu_m + (1 / mu_l));
      current_statement__ = 15;
      for (int i = 1; i <= m; ++i) {
        current_statement__ = 13;
        assign(rt_subjects, cons_list(index_uni(i), nil_index_list()),
          (mu[(i - 1)] + (1 / lambda[(i - 1)])),
          "assigning variable rt_subjects");}
      vars__.emplace_back(rt);
      for (int sym1__ = 1; sym1__ <= m; ++sym1__) {
        vars__.emplace_back(rt_subjects[(sym1__ - 1)]);}
    } catch (const std::exception& e) {
      stan::lang::rethrow_located(e, locations_array__[current_statement__]);
      // Next line prevents compiler griping about no return
      throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***"); 
    }
    } // write_array_impl() 
    
  template <typename VecVar, typename VecI, stan::require_std_vector_t<VecVar>* = nullptr, stan::require_vector_like_vt<std::is_integral, VecI>* = nullptr>
  inline void transform_inits_impl(const stan::io::var_context& context__,
                                   VecI& params_i__, VecVar& vars__,
                                   std::ostream* pstream__ = nullptr) const {
    using local_scalar_t__ = double;
    vars__.clear();
    vars__.reserve(num_params_r__);
    
    try {
      int pos__;
      pos__ = std::numeric_limits<int>::min();
      
      pos__ = 1;
      Eigen::Matrix<double, -1, 1> mu;
      mu = Eigen::Matrix<double, -1, 1>(m);
      stan::math::fill(mu, std::numeric_limits<double>::quiet_NaN());
      
      {
        std::vector<local_scalar_t__> mu_flat__;
        current_statement__ = 1;
        assign(mu_flat__, nil_index_list(), context__.vals_r("mu"),
          "assigning variable mu_flat__");
        current_statement__ = 1;
        pos__ = 1;
        current_statement__ = 1;
        for (int sym1__ = 1; sym1__ <= m; ++sym1__) {
          current_statement__ = 1;
          assign(mu, cons_list(index_uni(sym1__), nil_index_list()),
            mu_flat__[(pos__ - 1)], "assigning variable mu");
          current_statement__ = 1;
          pos__ = (pos__ + 1);}
      }
      Eigen::Matrix<double, -1, 1> mu_free__;
      mu_free__ = Eigen::Matrix<double, -1, 1>(m);
      stan::math::fill(mu_free__, std::numeric_limits<double>::quiet_NaN());
      
      current_statement__ = 1;
      for (int sym1__ = 1; sym1__ <= m; ++sym1__) {
        current_statement__ = 1;
        assign(mu_free__, cons_list(index_uni(sym1__), nil_index_list()),
          stan::math::lb_free(mu[(sym1__ - 1)], 0),
          "assigning variable mu_free__");}
      Eigen::Matrix<double, -1, 1> sigma;
      sigma = Eigen::Matrix<double, -1, 1>(m);
      stan::math::fill(sigma, std::numeric_limits<double>::quiet_NaN());
      
      {
        std::vector<local_scalar_t__> sigma_flat__;
        current_statement__ = 2;
        assign(sigma_flat__, nil_index_list(), context__.vals_r("sigma"),
          "assigning variable sigma_flat__");
        current_statement__ = 2;
        pos__ = 1;
        current_statement__ = 2;
        for (int sym1__ = 1; sym1__ <= m; ++sym1__) {
          current_statement__ = 2;
          assign(sigma, cons_list(index_uni(sym1__), nil_index_list()),
            sigma_flat__[(pos__ - 1)], "assigning variable sigma");
          current_statement__ = 2;
          pos__ = (pos__ + 1);}
      }
      Eigen::Matrix<double, -1, 1> sigma_free__;
      sigma_free__ = Eigen::Matrix<double, -1, 1>(m);
      stan::math::fill(sigma_free__, std::numeric_limits<double>::quiet_NaN());
      
      current_statement__ = 2;
      for (int sym1__ = 1; sym1__ <= m; ++sym1__) {
        current_statement__ = 2;
        assign(sigma_free__, cons_list(index_uni(sym1__), nil_index_list()),
          stan::math::lb_free(sigma[(sym1__ - 1)], 0),
          "assigning variable sigma_free__");}
      Eigen::Matrix<double, -1, 1> lambda;
      lambda = Eigen::Matrix<double, -1, 1>(m);
      stan::math::fill(lambda, std::numeric_limits<double>::quiet_NaN());
      
      {
        std::vector<local_scalar_t__> lambda_flat__;
        current_statement__ = 3;
        assign(lambda_flat__, nil_index_list(), context__.vals_r("lambda"),
          "assigning variable lambda_flat__");
        current_statement__ = 3;
        pos__ = 1;
        current_statement__ = 3;
        for (int sym1__ = 1; sym1__ <= m; ++sym1__) {
          current_statement__ = 3;
          assign(lambda, cons_list(index_uni(sym1__), nil_index_list()),
            lambda_flat__[(pos__ - 1)], "assigning variable lambda");
          current_statement__ = 3;
          pos__ = (pos__ + 1);}
      }
      Eigen::Matrix<double, -1, 1> lambda_free__;
      lambda_free__ = Eigen::Matrix<double, -1, 1>(m);
      stan::math::fill(lambda_free__, std::numeric_limits<double>::quiet_NaN());
      
      current_statement__ = 3;
      for (int sym1__ = 1; sym1__ <= m; ++sym1__) {
        current_statement__ = 3;
        assign(lambda_free__, cons_list(index_uni(sym1__), nil_index_list()),
          stan::math::lb_free(lambda[(sym1__ - 1)], 0),
          "assigning variable lambda_free__");}
      double mu_m;
      mu_m = std::numeric_limits<double>::quiet_NaN();
      
      current_statement__ = 4;
      mu_m = context__.vals_r("mu_m")[(1 - 1)];
      double mu_m_free__;
      mu_m_free__ = std::numeric_limits<double>::quiet_NaN();
      
      current_statement__ = 4;
      mu_m_free__ = stan::math::lb_free(mu_m, 0);
      double mu_l;
      mu_l = std::numeric_limits<double>::quiet_NaN();
      
      current_statement__ = 5;
      mu_l = context__.vals_r("mu_l")[(1 - 1)];
      double mu_l_free__;
      mu_l_free__ = std::numeric_limits<double>::quiet_NaN();
      
      current_statement__ = 5;
      mu_l_free__ = stan::math::lb_free(mu_l, 0.05);
      double mu_s;
      mu_s = std::numeric_limits<double>::quiet_NaN();
      
      current_statement__ = 6;
      mu_s = context__.vals_r("mu_s")[(1 - 1)];
      double mu_s_free__;
      mu_s_free__ = std::numeric_limits<double>::quiet_NaN();
      
      current_statement__ = 6;
      mu_s_free__ = stan::math::lb_free(mu_s, 0);
      double sigma_m;
      sigma_m = std::numeric_limits<double>::quiet_NaN();
      
      current_statement__ = 7;
      sigma_m = context__.vals_r("sigma_m")[(1 - 1)];
      double sigma_m_free__;
      sigma_m_free__ = std::numeric_limits<double>::quiet_NaN();
      
      current_statement__ = 7;
      sigma_m_free__ = stan::math::lb_free(sigma_m, 0);
      double sigma_l;
      sigma_l = std::numeric_limits<double>::quiet_NaN();
      
      current_statement__ = 8;
      sigma_l = context__.vals_r("sigma_l")[(1 - 1)];
      double sigma_l_free__;
      sigma_l_free__ = std::numeric_limits<double>::quiet_NaN();
      
      current_statement__ = 8;
      sigma_l_free__ = stan::math::lb_free(sigma_l, 0);
      double sigma_s;
      sigma_s = std::numeric_limits<double>::quiet_NaN();
      
      current_statement__ = 9;
      sigma_s = context__.vals_r("sigma_s")[(1 - 1)];
      double sigma_s_free__;
      sigma_s_free__ = std::numeric_limits<double>::quiet_NaN();
      
      current_statement__ = 9;
      sigma_s_free__ = stan::math::lb_free(sigma_s, 0);
      for (int sym1__ = 1; sym1__ <= m; ++sym1__) {
        vars__.emplace_back(mu_free__[(sym1__ - 1)]);}
      for (int sym1__ = 1; sym1__ <= m; ++sym1__) {
        vars__.emplace_back(sigma_free__[(sym1__ - 1)]);}
      for (int sym1__ = 1; sym1__ <= m; ++sym1__) {
        vars__.emplace_back(lambda_free__[(sym1__ - 1)]);}
      vars__.emplace_back(mu_m_free__);
      vars__.emplace_back(mu_l_free__);
      vars__.emplace_back(mu_s_free__);
      vars__.emplace_back(sigma_m_free__);
      vars__.emplace_back(sigma_l_free__);
      vars__.emplace_back(sigma_s_free__);
    } catch (const std::exception& e) {
      stan::lang::rethrow_located(e, locations_array__[current_statement__]);
      // Next line prevents compiler griping about no return
      throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***"); 
    }
    } // transform_inits_impl() 
    
  inline void get_param_names(std::vector<std::string>& names__) const {
    
    names__.clear();
    names__.emplace_back("mu");
    names__.emplace_back("sigma");
    names__.emplace_back("lambda");
    names__.emplace_back("mu_m");
    names__.emplace_back("mu_l");
    names__.emplace_back("mu_s");
    names__.emplace_back("sigma_m");
    names__.emplace_back("sigma_l");
    names__.emplace_back("sigma_s");
    names__.emplace_back("rt");
    names__.emplace_back("rt_subjects");
    } // get_param_names() 
    
  inline void get_dims(std::vector<std::vector<size_t>>& dimss__) const {
    dimss__.clear();
    dimss__.emplace_back(std::vector<size_t>{static_cast<size_t>(m)});
    
    dimss__.emplace_back(std::vector<size_t>{static_cast<size_t>(m)});
    
    dimss__.emplace_back(std::vector<size_t>{static_cast<size_t>(m)});
    
    dimss__.emplace_back(std::vector<size_t>{});
    
    dimss__.emplace_back(std::vector<size_t>{});
    
    dimss__.emplace_back(std::vector<size_t>{});
    
    dimss__.emplace_back(std::vector<size_t>{});
    
    dimss__.emplace_back(std::vector<size_t>{});
    
    dimss__.emplace_back(std::vector<size_t>{});
    
    dimss__.emplace_back(std::vector<size_t>{});
    
    dimss__.emplace_back(std::vector<size_t>{static_cast<size_t>(m)});
    
    } // get_dims() 
    
  inline void constrained_param_names(
                                      std::vector<std::string>& param_names__,
                                      bool emit_transformed_parameters__ = true,
                                      bool emit_generated_quantities__ = true) const
    final {
    
    for (int sym1__ = 1; sym1__ <= m; ++sym1__) {
      {
        param_names__.emplace_back(std::string() + "mu" + '.' + std::to_string(sym1__));
      }}
    for (int sym1__ = 1; sym1__ <= m; ++sym1__) {
      {
        param_names__.emplace_back(std::string() + "sigma" + '.' + std::to_string(sym1__));
      }}
    for (int sym1__ = 1; sym1__ <= m; ++sym1__) {
      {
        param_names__.emplace_back(std::string() + "lambda" + '.' + std::to_string(sym1__));
      }}
    param_names__.emplace_back(std::string() + "mu_m");
    param_names__.emplace_back(std::string() + "mu_l");
    param_names__.emplace_back(std::string() + "mu_s");
    param_names__.emplace_back(std::string() + "sigma_m");
    param_names__.emplace_back(std::string() + "sigma_l");
    param_names__.emplace_back(std::string() + "sigma_s");
    if (emit_transformed_parameters__) {
      
    }
    
    if (emit_generated_quantities__) {
      param_names__.emplace_back(std::string() + "rt");
      for (int sym1__ = 1; sym1__ <= m; ++sym1__) {
        {
          param_names__.emplace_back(std::string() + "rt_subjects" + '.' + std::to_string(sym1__));
        }}
    }
    
    } // constrained_param_names() 
    
  inline void unconstrained_param_names(
                                        std::vector<std::string>& param_names__,
                                        bool emit_transformed_parameters__ = true,
                                        bool emit_generated_quantities__ = true) const
    final {
    
    for (int sym1__ = 1; sym1__ <= m; ++sym1__) {
      {
        param_names__.emplace_back(std::string() + "mu" + '.' + std::to_string(sym1__));
      }}
    for (int sym1__ = 1; sym1__ <= m; ++sym1__) {
      {
        param_names__.emplace_back(std::string() + "sigma" + '.' + std::to_string(sym1__));
      }}
    for (int sym1__ = 1; sym1__ <= m; ++sym1__) {
      {
        param_names__.emplace_back(std::string() + "lambda" + '.' + std::to_string(sym1__));
      }}
    param_names__.emplace_back(std::string() + "mu_m");
    param_names__.emplace_back(std::string() + "mu_l");
    param_names__.emplace_back(std::string() + "mu_s");
    param_names__.emplace_back(std::string() + "sigma_m");
    param_names__.emplace_back(std::string() + "sigma_l");
    param_names__.emplace_back(std::string() + "sigma_s");
    if (emit_transformed_parameters__) {
      
    }
    
    if (emit_generated_quantities__) {
      param_names__.emplace_back(std::string() + "rt");
      for (int sym1__ = 1; sym1__ <= m; ++sym1__) {
        {
          param_names__.emplace_back(std::string() + "rt_subjects" + '.' + std::to_string(sym1__));
        }}
    }
    
    } // unconstrained_param_names() 
    
  inline std::string get_constrained_sizedtypes() const {
    stringstream s__;
    s__ << "[{\"name\":\"mu\",\"type\":{\"name\":\"vector\",\"length\":" << m << "},\"block\":\"parameters\"},{\"name\":\"sigma\",\"type\":{\"name\":\"vector\",\"length\":" << m << "},\"block\":\"parameters\"},{\"name\":\"lambda\",\"type\":{\"name\":\"vector\",\"length\":" << m << "},\"block\":\"parameters\"},{\"name\":\"mu_m\",\"type\":{\"name\":\"real\"},\"block\":\"parameters\"},{\"name\":\"mu_l\",\"type\":{\"name\":\"real\"},\"block\":\"parameters\"},{\"name\":\"mu_s\",\"type\":{\"name\":\"real\"},\"block\":\"parameters\"},{\"name\":\"sigma_m\",\"type\":{\"name\":\"real\"},\"block\":\"parameters\"},{\"name\":\"sigma_l\",\"type\":{\"name\":\"real\"},\"block\":\"parameters\"},{\"name\":\"sigma_s\",\"type\":{\"name\":\"real\"},\"block\":\"parameters\"},{\"name\":\"rt\",\"type\":{\"name\":\"real\"},\"block\":\"generated_quantities\"},{\"name\":\"rt_subjects\",\"type\":{\"name\":\"vector\",\"length\":" << m << "},\"block\":\"generated_quantities\"}]";
    return s__.str();
    } // get_constrained_sizedtypes() 
    
  inline std::string get_unconstrained_sizedtypes() const {
    stringstream s__;
    s__ << "[{\"name\":\"mu\",\"type\":{\"name\":\"vector\",\"length\":" << m << "},\"block\":\"parameters\"},{\"name\":\"sigma\",\"type\":{\"name\":\"vector\",\"length\":" << m << "},\"block\":\"parameters\"},{\"name\":\"lambda\",\"type\":{\"name\":\"vector\",\"length\":" << m << "},\"block\":\"parameters\"},{\"name\":\"mu_m\",\"type\":{\"name\":\"real\"},\"block\":\"parameters\"},{\"name\":\"mu_l\",\"type\":{\"name\":\"real\"},\"block\":\"parameters\"},{\"name\":\"mu_s\",\"type\":{\"name\":\"real\"},\"block\":\"parameters\"},{\"name\":\"sigma_m\",\"type\":{\"name\":\"real\"},\"block\":\"parameters\"},{\"name\":\"sigma_l\",\"type\":{\"name\":\"real\"},\"block\":\"parameters\"},{\"name\":\"sigma_s\",\"type\":{\"name\":\"real\"},\"block\":\"parameters\"},{\"name\":\"rt\",\"type\":{\"name\":\"real\"},\"block\":\"generated_quantities\"},{\"name\":\"rt_subjects\",\"type\":{\"name\":\"vector\",\"length\":" << m << "},\"block\":\"generated_quantities\"}]";
    return s__.str();
    } // get_unconstrained_sizedtypes() 
    
  
    // Begin method overload boilerplate
    template <typename RNG>
    inline void write_array(RNG& base_rng,
                            Eigen::Matrix<double,Eigen::Dynamic,1>& params_r,
                            Eigen::Matrix<double,Eigen::Dynamic,1>& vars,
                            const bool emit_transformed_parameters = true,
                            const bool emit_generated_quantities = true,
                            std::ostream* pstream = nullptr) const {
      std::vector<double> vars_vec(vars.size());
      std::vector<int> params_i;
      write_array_impl(base_rng, params_r, params_i, vars_vec,
          emit_transformed_parameters, emit_generated_quantities, pstream);
      vars.resize(vars_vec.size());
      for (int i = 0; i < vars.size(); ++i) {
        vars.coeffRef(i) = vars_vec[i];
      }
    }
    template <typename RNG>
    inline void write_array(RNG& base_rng, std::vector<double>& params_r,
                            std::vector<int>& params_i,
                            std::vector<double>& vars,
                            bool emit_transformed_parameters = true,
                            bool emit_generated_quantities = true,
                            std::ostream* pstream = nullptr) const {
      write_array_impl(base_rng, params_r, params_i, vars, emit_transformed_parameters, emit_generated_quantities, pstream);
    }
    template <bool propto__, bool jacobian__, typename T_>
    inline T_ log_prob(Eigen::Matrix<T_,Eigen::Dynamic,1>& params_r,
                       std::ostream* pstream = nullptr) const {
      Eigen::Matrix<int, -1, 1> params_i;
      return log_prob_impl<propto__, jacobian__>(params_r, params_i, pstream);
    }
    template <bool propto__, bool jacobian__, typename T__>
    inline T__ log_prob(std::vector<T__>& params_r,
                        std::vector<int>& params_i,
                        std::ostream* pstream = nullptr) const {
      return log_prob_impl<propto__, jacobian__>(params_r, params_i, pstream);
    }
  
    inline void transform_inits(const stan::io::var_context& context,
                         Eigen::Matrix<double, Eigen::Dynamic, 1>& params_r,
                         std::ostream* pstream = nullptr) const final {
      std::vector<double> params_r_vec(params_r.size());
      std::vector<int> params_i;
      transform_inits_impl(context, params_i, params_r_vec, pstream);
      params_r.resize(params_r_vec.size());
      for (int i = 0; i < params_r.size(); ++i) {
        params_r.coeffRef(i) = params_r_vec[i];
      }
    }
    inline void transform_inits(const stan::io::var_context& context,
                                std::vector<int>& params_i,
                                std::vector<double>& vars,
                                std::ostream* pstream = nullptr) const final {
      transform_inits_impl(context, params_i, vars, pstream);
    }        
};
}
using stan_model = model_reaction_time_namespace::model_reaction_time;
#ifndef USING_R
// Boilerplate
stan::model::model_base& new_model(
        stan::io::var_context& data_context,
        unsigned int seed,
        std::ostream* msg_stream) {
  stan_model* m = new stan_model(data_context, seed, msg_stream);
  return *m;
}
stan::math::profile_map& get_stan_profile_data() {
  return model_reaction_time_namespace::profiles__;
}
#endif
#endif
