% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/binomial.R
\name{binomial_analysis}
\alias{binomial_analysis}
\title{Analyzing Bayesian trial for binomial counts}
\usage{
binomial_analysis(treatment, outcome, complete = NULL,
  y0_treatment = NULL, N0_treatment = NULL, y0_control = NULL,
  N0_control = NULL, alternative = "greater", N_impute = 10,
  h0 = 0, number_mcmc = 10000, prob_ha = 0.95, futility_prob = 0.1,
  expected_success_prob = 0.9, prior = c(1, 1),
  discount_function = "identity", fix_alpha = FALSE, alpha_max = 1,
  weibull_scale = 0.135, weibull_shape = 3, method = "fixed")
}
\arguments{
\item{treatment}{vector. treatment assignment for patients, 1 for treatment group and
0 for control group}

\item{outcome}{vector. binomial outcome of the trial, 1 for response (success or
failure), 0 for no response.}

\item{complete}{vector. similar length as treatment and outcome variable,
1 for complete outcome, 0 for loss to follow up. If complete is not provided,
the dataset is assumed to be complete.}

\item{y0_treatment}{scalar. Number of events for the historical treatment
arm.}

\item{N0_treatment}{scalar. Number of observations of the historical treatment group.}

\item{y0_control}{scalar. Number of events for the historical control arm.}

\item{N0_control}{scalar. Number of observations of the historical control group.}

\item{alternative}{character. The string specifying the alternative
hypothesis, must be one of \code{"greater"} (default), \code{"less"} or
\code{"two.sided"}.}

\item{N_impute}{scalar. Number of imputations for Monte Carlo simulation of
missing data.}

\item{h0}{scalar. Threshold for comparing two mean values. Default is
\code{h0=0}.}

\item{number_mcmc}{scalar. Number of Monte Carlo Markov Chain draws in
sampling posterior.}

\item{prob_ha}{scalar. Probability of alternative hypothesis.}

\item{futility_prob}{scalar. Probability of stopping early for futility.}

\item{expected_success_prob}{scalar. Probability of stopping early for success.}

\item{prior}{vector. Prior values of beta rate, Beta(a0, b0). The default is
set to Beta(1, 1).}

\item{discount_function}{character. If incorporating historical data, specify
the discount function. Currently supports the Weibull function
(\code{discount_function="weibull"}), the scaled-Weibull function
(\code{discount_function="scaledweibull"}), and the identity function
(\code{discount_function="identity"}). The scaled-Weibull discount function
scales the output of the Weibull CDF to have a max value of 1. The identity
discount function uses the posterior probability directly as the discount
weight. Default value is \code{"identity"}. See \code{\link{bdpnormal}} for
more details.}

\item{fix_alpha}{logical. Fix alpha at alpha_max? Default value is FALSE.}

\item{alpha_max}{scalar. Maximum weight the discount function can apply.
Default is 1. For a two-arm trial, users may specify a vector of two values
where the first value is used to weight the historical treatment group and
the second value is used to weight the historical control group.}

\item{weibull_scale}{scalar. Scale parameter of the Weibull discount function
used to compute alpha, the weight parameter of the historical data. Default
value is 0.135. For a two-arm trial, users may specify a vector of two
values where the first value is used to estimate the weight of the
historical treatment group and the second value is used to estimate the
weight of the historical control group. Not used when discount_function =
"identity".}

\item{weibull_shape}{scalar. Shape parameter of the Weibull discount function
used to compute alpha, the weight parameter of the historical data. Default
value is 3. For a two-arm trial, users may specify a vector of two values
where the first value is used to estimate the weight of the historical
treatment group and the second value is used to estimate the weight of the
historical control group. Not used when discount_function = "identity".}

\item{method}{character. Analysis method with respect to estimation of the weight
paramter alpha. Default method "\code{mc}" estimates alpha for each
Monte Carlo iteration. Alternate value "\code{fixed}" estimates alpha once
and holds it fixed throughout the analysis.  See the the
\code{bdpsurvival} vignette \cr
\code{vignette("bdpsurvival-vignette", package="bayesDP")} for more details.}
}
\value{
a list of output for the Bayesian trial for binomial count.

\describe{
  \item{\code{prob_of_accepting_alternative}}{
    scalar. The input parameter of probability of accepting the alternative.}
  \item{\code{margin}}{
    scalar. The margin input value of difference between mean estimate of treatment
     and mean estimate of the control.}
  \item{\code{alternative}}{
    character. The input parameter of alternative hypothesis. }
  \item{\code{N_treatment}}{
    scalar. The number of patients enrolled in the experimental group for
    each simulation.}
  \item{\code{N_control}}{
    scalar. The number of patients enrolled in the control group for
    each simulation.}
  \item{\code{N_enrolled}}{
    vector. The number of patients enrolled in the trial (sum of control
    and experimental group for each simulation. )}
  \item{\code{N_complete}}{
    scalar. The number of patients who completed the trial and had no
    loss to follow-up.}
  \item{\code{post_prob_accept_alternative}}{
    vector. The final probability of accepting the alternative
    hypothesis after the analysis is done.}
  \item{\code{est_final}}{
    scalar. The final estimate of the difference in posterior estimate of
    treatment and posterior estimate of the control group.}
  \item{\code{stop_futility}}{
    scalar. Did the trial stop for futility during imputation of patient
    who had loss to follow up? 1 for yes and 0 for no.}
  \item{\code{stop_expected_success}}{
    scalar. Did the trial stop for early success during imputation of patient
    who had loss to follow up? 1 for yes and 0 for no.}

}
}
\description{
Function to analyze Bayesian trial for binomial count data
 which allows early stopping and incorporation of historical data using
 the discount function approach
}
