% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/binomial.R
\name{historical_binomial}
\alias{historical_binomial}
\title{Historical data for binomial distribution}
\usage{
historical_binomial(
  y0_treatment = NULL,
  N0_treatment = NULL,
  discount_function = "identity",
  y0_control = NULL,
  N0_control = NULL,
  alpha_max = 1,
  fix_alpha = FALSE,
  weibull_scale = 0.135,
  weibull_shape = 3,
  method = "fixed",
  .data = NULL
)
}
\arguments{
\item{y0_treatment}{scalar. Number of events for the historical treatment
arm.}

\item{N0_treatment}{scalar. Number of observations of the historical treatment group.}

\item{discount_function}{character. If incorporating historical data, specify
the discount function. Currently supports the Weibull function
(\code{discount_function="weibull"}), the scaled-Weibull function
(\code{discount_function="scaledweibull"}), and the identity function
(\code{discount_function="identity"}). The scaled-Weibull discount function
scales the output of the Weibull CDF to have a max value of 1. The identity
discount function uses the posterior probability directly as the discount
weight. Default value is \code{"identity"}. See \code{\link{bdpnormal}} for
more details.}

\item{y0_control}{scalar. Number of events for the historical control arm.}

\item{N0_control}{scalar. Number of observations of the historical control group.}

\item{alpha_max}{scalar. Maximum weight the discount function can apply.
Default is 1. For a two-arm trial, users may specify a vector of two values
where the first value is used to weight the historical treatment group and
the second value is used to weight the historical control group.}

\item{fix_alpha}{logical. Fix alpha at alpha_max? Default value is FALSE.}

\item{weibull_scale}{scalar. Scale parameter of the Weibull discount function
used to compute alpha, the weight parameter of the historical data. Default
value is 0.135. For a two-arm trial, users may specify a vector of two
values where the first value is used to estimate the weight of the
historical treatment group and the second value is used to estimate the
weight of the historical control group. Not used when discount_function =
"identity".}

\item{weibull_shape}{scalar. Shape parameter of the Weibull discount function
used to compute alpha, the weight parameter of the historical data. Default
value is 3. For a two-arm trial, users may specify a vector of two values
where the first value is used to estimate the weight of the historical
treatment group and the second value is used to estimate the weight of the
historical control group. Not used when discount_function = "identity".}

\item{method}{character. Analysis method with respect to estimation of the weight
paramter alpha. Default method "\code{mc}" estimates alpha for each
Monte Carlo iteration. Alternate value "\code{fixed}" estimates alpha once
and holds it fixed throughout the analysis.  See the the
\code{bdpsurvival} vignette \cr
\code{vignette("bdpsurvival-vignette", package="bayesDP")} for more details.}

\item{.data}{NULL. stores the proportion of control and treatment, please do not fill it in.}
}
\value{
a list with historical data for control and treatment group with the discount function.
}
\description{
Wrapper function for historical data from binomial outcome.
}
\examples{
historical_binomial(y0_treatment = 5, N0_treatment = 10, y0_control = 15, N0_control = 23)
historical_binomial(y0_treatment = 5, N0_treatment = 10, y0_control = 15, N0_control = 23,
                     discount_function = "weibull", alpha_max = 1, fix_alpha = FALSE,
                     weibull_scale = 0.135, weibull_shape = 3)
}
