QRc.AL <- function(Data, Prior, Mcmc){

# Error handling:

    pandterm = function(message) {
        stop(message, call. = FALSE)
    }
    if (missing(Data)) {
        pandterm("Requires Data argument -- list of y, X and p")
    }
    if (is.null(Data$X)) {
        pandterm("Requires Data element X")
    }
    X = Data$X
    if (is.null(Data$y)) {
        pandterm("Requires Data element y")
    }
    y = Data$y
    nvar = ncol(X)
    n = length(y)
    if (n != nrow(X)) {
        pandterm("length(y) ne nrow(X)")
    }
    if (is.null(Data$p)) {
        pandterm("Requires Data element p")
    }
    p = Data$p
    if ((p<=0)|(p>=1)) {
        pandterm("Unvalid quantile p")
    }

    if (missing(Prior)) {
	a = 0.01
	b = 0.01
	c = 0.01
	d = 0.01
    }
    else {
        if (is.null(Prior$sigma_shape)) {
	    a = 0.01
        }
        else {
            a = Prior$sigma_shape
        }
        if (is.null(Prior$sigma_scale)) {
	    b = 0.01
        }
        else {
            b = Prior$sigma_scale
        }
        if (is.null(Prior$etasq_shape)) {
	    c = 0.01
        }
        else {
            c = Prior$etasq_shape
        }
        if (is.null(Prior$etasq_scale)) {
	    d = 1/0.01
        }
        else {
            d = 1/Prior$etasq_scale
        }
    }

    if (missing(Mcmc)) {
        pandterm("Requires Mcmc argument")
    }
    else {
        if (is.null(Mcmc$R)) {
            pandterm("Requires Mcmc element R")
        }
        else {
            r = Mcmc$R
        }
        if (is.null(Mcmc$keep)) {
            keep = 1
        }
        else {
            keep = Mcmc$keep
        }
    }


# Start of algorithm:

    ## Assign correct variable types
    n <- as.integer(n)
    nvar <- as.integer(nvar)
    r <- as.integer(r)
    keep <- as.integer(keep)
    y <- as.double(y)
    p <- as.double(p)
    x <- as.double(X)
    a <- as.double(a)
    b <- as.double(b)
    c <- as.double(c)
    d <- as.double(d)
    betadraw <- double(nvar*r/keep)
    sigmadraw <- double(r/keep)

    ## Call Fortran routine
    fn_val <- .Fortran("QRc_AL_mcmc",n, nvar, r, keep, y, p, x, a, b, c, d, betadraw, sigmadraw) 

    return(list(method="QRc.AL",
		            p=p,
		            betadraw=matrix(fn_val[[12]], nrow=r/keep, ncol=nvar),
		            sigmadraw=fn_val[[13]]
		            )
					)
}
