% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/loo.R
\name{loo.bayesdfa}
\alias{loo.bayesdfa}
\alias{loo}
\title{LOO information criteria}
\usage{
\method{loo}{bayesdfa}(x, ...)
}
\arguments{
\item{x}{Output from \code{\link[=fit_dfa]{fit_dfa()}}.}

\item{...}{Arguments for \code{\link[loo:relative_eff]{loo::relative_eff()}} and \code{\link[loo:loo.array]{loo::loo.array()}}.}
}
\description{
Extract the LOOIC (leave-one-out information criterion) using
\code{\link[loo:loo]{loo::loo()}}. Note that we've implemented slightly different variants
of loo, based on whether the DFA observation model includes correlation
between time series or not (default is no correlation). Importantly,
these different versions are not directly comparable to evaluate data support
for including correlation or not in a DFA. If time series are not correlated,
the point-wise log-likelihood for each observation is calculated and used
in the loo calculations. However if time series are correlated, then each
time slice is assumed to be a joint observation of
all variables, and the point-wise log-likelihood is calculated as the
joint likelihood of all variables under the multivariate normal distribution.
}
\examples{
\donttest{
set.seed(1)
s <- sim_dfa(num_trends = 1, num_years = 50, num_ts = 3)
m <- fit_dfa(y = s$y_sim, iter = 300, chains = 1, num_trends = 1)
loo(m)
}
}
