// Generated by rstantools.  Do not edit by hand.

/*
    path is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    path is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with path.  If not, see <http://www.gnu.org/licenses/>.
*/
#ifndef MODELS_HPP
#define MODELS_HPP
#define STAN__SERVICES__COMMAND_HPP
#ifndef USE_STANC3
#define USE_STANC3
#endif
#include <rstan/rstaninc.hpp>
// Code generated by stanc v2.26.1-4-gd72b68b7-dirty
#include <stan/model/model_header.hpp>
namespace model_hmm_gaussian_namespace {
inline void validate_positive_index(const char* var_name, const char* expr,
                                    int val) {
  if (val < 1) {
    std::stringstream msg;
    msg << "Found dimension size less than one in simplex declaration"
        << "; variable=" << var_name << "; dimension size expression=" << expr
        << "; expression value=" << val;
    std::string msg_str(msg.str());
    throw std::invalid_argument(msg_str.c_str());
  }
}
inline void validate_unit_vector_index(const char* var_name, const char* expr,
                                       int val) {
  if (val <= 1) {
    std::stringstream msg;
    if (val == 1) {
      msg << "Found dimension size one in unit vector declaration."
          << " One-dimensional unit vector is discrete"
          << " but the target distribution must be continuous."
          << " variable=" << var_name << "; dimension size expression=" << expr;
    } else {
      msg << "Found dimension size less than one in unit vector declaration"
          << "; variable=" << var_name << "; dimension size expression=" << expr
          << "; expression value=" << val;
    }
    std::string msg_str(msg.str());
    throw std::invalid_argument(msg_str.c_str());
  }
}
using std::istream;
using std::string;
using std::stringstream;
using std::vector;
using std::pow;
using stan::io::dump;
using stan::math::lgamma;
using stan::model::model_base_crtp;
using stan::model::rvalue;
using stan::model::cons_list;
using stan::model::index_uni;
using stan::model::index_max;
using stan::model::index_min;
using stan::model::index_min_max;
using stan::model::index_multi;
using stan::model::index_omni;
using stan::model::nil_index_list;
using namespace stan::math;
using stan::math::pow; 
stan::math::profile_map profiles__;
static int current_statement__= 0;
static const std::vector<string> locations_array__ = {" (found before start of program)",
                                                      " (in 'hmm_gaussian', line 17, column 2 to column 18)",
                                                      " (in 'hmm_gaussian', line 18, column 2 to column 21)",
                                                      " (in 'hmm_gaussian', line 21, column 2 to column 18)",
                                                      " (in 'hmm_gaussian', line 22, column 2 to column 27)",
                                                      " (in 'hmm_gaussian', line 25, column 2 to column 26)",
                                                      " (in 'hmm_gaussian', line 27, column 21 to column 22)",
                                                      " (in 'hmm_gaussian', line 27, column 4 to column 24)",
                                                      " (in 'hmm_gaussian', line 33, column 6 to column 73)",
                                                      " (in 'hmm_gaussian', line 31, column 11 to line 34, column 5)",
                                                      " (in 'hmm_gaussian', line 30, column 6 to column 70)",
                                                      " (in 'hmm_gaussian', line 28, column 23 to line 31, column 5)",
                                                      " (in 'hmm_gaussian', line 28, column 4 to line 34, column 5)",
                                                      " (in 'hmm_gaussian', line 45, column 14 to column 112)",
                                                      " (in 'hmm_gaussian', line 43, column 19 to line 46, column 13)",
                                                      " (in 'hmm_gaussian', line 42, column 14 to column 112)",
                                                      " (in 'hmm_gaussian', line 40, column 31 to line 43, column 13)",
                                                      " (in 'hmm_gaussian', line 40, column 12 to line 46, column 13)",
                                                      " (in 'hmm_gaussian', line 37, column 23 to line 47, column 9)",
                                                      " (in 'hmm_gaussian', line 37, column 8 to line 47, column 9)",
                                                      " (in 'hmm_gaussian', line 48, column 8 to column 52)",
                                                      " (in 'hmm_gaussian', line 36, column 21 to line 49, column 7)",
                                                      " (in 'hmm_gaussian', line 36, column 6 to line 49, column 7)",
                                                      " (in 'hmm_gaussian', line 35, column 19 to line 50, column 5)",
                                                      " (in 'hmm_gaussian', line 35, column 4 to line 50, column 5)",
                                                      " (in 'hmm_gaussian', line 26, column 2 to line 51, column 3)",
                                                      " (in 'hmm_gaussian', line 59, column 2 to column 25)",
                                                      " (in 'hmm_gaussian', line 60, column 2 to column 26)",
                                                      " (in 'hmm_gaussian', line 61, column 2 to column 24)",
                                                      " (in 'hmm_gaussian', line 62, column 2 to column 23)",
                                                      " (in 'hmm_gaussian', line 63, column 2 to column 24)",
                                                      " (in 'hmm_gaussian', line 64, column 2 to column 20)",
                                                      " (in 'hmm_gaussian', line 65, column 2 to column 35)",
                                                      " (in 'hmm_gaussian', line 66, column 2 to column 20)",
                                                      " (in 'hmm_gaussian', line 69, column 6 to column 43)",
                                                      " (in 'hmm_gaussian', line 68, column 4 to line 69, column 43)",
                                                      " (in 'hmm_gaussian', line 67, column 2 to line 70, column 3)",
                                                      " (in 'hmm_gaussian', line 72, column 21 to column 22)",
                                                      " (in 'hmm_gaussian', line 72, column 4 to column 24)",
                                                      " (in 'hmm_gaussian', line 74, column 6 to column 26)",
                                                      " (in 'hmm_gaussian', line 73, column 4 to line 74, column 26)",
                                                      " (in 'hmm_gaussian', line 76, column 6 to column 12)",
                                                      " (in 'hmm_gaussian', line 77, column 6 to column 23)",
                                                      " (in 'hmm_gaussian', line 85, column 14 to column 109)",
                                                      " (in 'hmm_gaussian', line 84, column 19 to line 86, column 13)",
                                                      " (in 'hmm_gaussian', line 83, column 14 to column 109)",
                                                      " (in 'hmm_gaussian', line 82, column 31 to line 84, column 13)",
                                                      " (in 'hmm_gaussian', line 82, column 12 to line 86, column 13)",
                                                      " (in 'hmm_gaussian', line 79, column 23 to line 87, column 11)",
                                                      " (in 'hmm_gaussian', line 79, column 8 to line 87, column 11)",
                                                      " (in 'hmm_gaussian', line 88, column 8 to column 53)",
                                                      " (in 'hmm_gaussian', line 78, column 21 to line 89, column 7)",
                                                      " (in 'hmm_gaussian', line 78, column 6 to line 89, column 7)",
                                                      " (in 'hmm_gaussian', line 75, column 30 to line 90, column 5)",
                                                      " (in 'hmm_gaussian', line 75, column 4 to line 90, column 5)",
                                                      " (in 'hmm_gaussian', line 92, column 6 to column 41)",
                                                      " (in 'hmm_gaussian', line 91, column 4 to line 92, column 41)",
                                                      " (in 'hmm_gaussian', line 71, column 2 to line 93, column 3)",
                                                      " (in 'hmm_gaussian', line 96, column 8 to column 50)",
                                                      " (in 'hmm_gaussian', line 97, column 8 to column 47)",
                                                      " (in 'hmm_gaussian', line 95, column 18 to line 98, column 5)",
                                                      " (in 'hmm_gaussian', line 95, column 4 to line 98, column 5)",
                                                      " (in 'hmm_gaussian', line 101, column 6 to column 21)",
                                                      " (in 'hmm_gaussian', line 107, column 10 to column 64)",
                                                      " (in 'hmm_gaussian', line 106, column 21 to line 108, column 7)",
                                                      " (in 'hmm_gaussian', line 106, column 6 to line 108, column 7)",
                                                      " (in 'hmm_gaussian', line 113, column 6 to column 35)",
                                                      " (in 'hmm_gaussian', line 99, column 18 to line 114, column 5)",
                                                      " (in 'hmm_gaussian', line 99, column 4 to line 114, column 5)",
                                                      " (in 'hmm_gaussian', line 94, column 2 to line 115, column 3)",
                                                      " (in 'hmm_gaussian', line 117, column 13 to column 14)",
                                                      " (in 'hmm_gaussian', line 117, column 16 to column 17)",
                                                      " (in 'hmm_gaussian', line 117, column 4 to column 19)",
                                                      " (in 'hmm_gaussian', line 118, column 18 to column 19)",
                                                      " (in 'hmm_gaussian', line 118, column 21 to column 22)",
                                                      " (in 'hmm_gaussian', line 118, column 4 to column 24)",
                                                      " (in 'hmm_gaussian', line 125, column 6 to column 65)",
                                                      " (in 'hmm_gaussian', line 124, column 4 to line 125, column 65)",
                                                      " (in 'hmm_gaussian', line 123, column 11 to line 126, column 5)",
                                                      " (in 'hmm_gaussian', line 122, column 6 to column 65)",
                                                      " (in 'hmm_gaussian', line 121, column 4 to line 122, column 65)",
                                                      " (in 'hmm_gaussian', line 120, column 23 to line 123, column 5)",
                                                      " (in 'hmm_gaussian', line 120, column 4 to line 126, column 5)",
                                                      " (in 'hmm_gaussian', line 129, column 8 to column 45)",
                                                      " (in 'hmm_gaussian', line 131, column 10 to column 20)",
                                                      " (in 'hmm_gaussian', line 135, column 12 to column 98)",
                                                      " (in 'hmm_gaussian', line 134, column 17 to line 136, column 11)",
                                                      " (in 'hmm_gaussian', line 133, column 10 to column 96)",
                                                      " (in 'hmm_gaussian', line 132, column 29 to line 134, column 11)",
                                                      " (in 'hmm_gaussian', line 132, column 10 to line 136, column 11)",
                                                      " (in 'hmm_gaussian', line 138, column 12 to column 27)",
                                                      " (in 'hmm_gaussian', line 139, column 12 to column 34)",
                                                      " (in 'hmm_gaussian', line 137, column 37 to line 140, column 11)",
                                                      " (in 'hmm_gaussian', line 137, column 10 to line 140, column 11)",
                                                      " (in 'hmm_gaussian', line 130, column 23 to line 141, column 9)",
                                                      " (in 'hmm_gaussian', line 130, column 8 to line 141, column 9)",
                                                      " (in 'hmm_gaussian', line 128, column 21 to line 142, column 7)",
                                                      " (in 'hmm_gaussian', line 128, column 6 to line 142, column 7)",
                                                      " (in 'hmm_gaussian', line 127, column 19 to line 143, column 5)",
                                                      " (in 'hmm_gaussian', line 127, column 4 to line 143, column 5)",
                                                      " (in 'hmm_gaussian', line 144, column 4 to column 36)",
                                                      " (in 'hmm_gaussian', line 147, column 8 to column 23)",
                                                      " (in 'hmm_gaussian', line 146, column 6 to line 147, column 23)",
                                                      " (in 'hmm_gaussian', line 145, column 4 to line 147, column 23)",
                                                      " (in 'hmm_gaussian', line 149, column 6 to column 59)",
                                                      " (in 'hmm_gaussian', line 148, column 25 to line 150, column 5)",
                                                      " (in 'hmm_gaussian', line 148, column 4 to line 150, column 5)",
                                                      " (in 'hmm_gaussian', line 116, column 2 to line 151, column 3)",
                                                      " (in 'hmm_gaussian', line 54, column 2 to column 31)",
                                                      " (in 'hmm_gaussian', line 55, column 2 to column 28)",
                                                      " (in 'hmm_gaussian', line 56, column 2 to column 39)",
                                                      " (in 'hmm_gaussian', line 9, column 2 to column 17)",
                                                      " (in 'hmm_gaussian', line 10, column 2 to column 17)",
                                                      " (in 'hmm_gaussian', line 11, column 11 to column 12)",
                                                      " (in 'hmm_gaussian', line 11, column 2 to column 14)",
                                                      " (in 'hmm_gaussian', line 12, column 2 to column 25)",
                                                      " (in 'hmm_gaussian', line 13, column 15 to column 16)",
                                                      " (in 'hmm_gaussian', line 13, column 2 to column 18)",
                                                      " (in 'hmm_gaussian', line 17, column 10 to column 11)",
                                                      " (in 'hmm_gaussian', line 18, column 18 to column 19)",
                                                      " (in 'hmm_gaussian', line 18, column 10 to column 11)",
                                                      " (in 'hmm_gaussian', line 21, column 10 to column 11)",
                                                      " (in 'hmm_gaussian', line 22, column 24 to column 25)",
                                                      " (in 'hmm_gaussian', line 25, column 23 to column 24)",
                                                      " (in 'hmm_gaussian', line 25, column 9 to column 10)",
                                                      " (in 'hmm_gaussian', line 59, column 22 to column 23)",
                                                      " (in 'hmm_gaussian', line 59, column 9 to column 10)",
                                                      " (in 'hmm_gaussian', line 60, column 23 to column 24)",
                                                      " (in 'hmm_gaussian', line 60, column 9 to column 10)",
                                                      " (in 'hmm_gaussian', line 61, column 21 to column 22)",
                                                      " (in 'hmm_gaussian', line 61, column 9 to column 10)",
                                                      " (in 'hmm_gaussian', line 62, column 20 to column 21)",
                                                      " (in 'hmm_gaussian', line 62, column 9 to column 10)",
                                                      " (in 'hmm_gaussian', line 63, column 21 to column 22)",
                                                      " (in 'hmm_gaussian', line 63, column 9 to column 10)",
                                                      " (in 'hmm_gaussian', line 64, column 9 to column 10)",
                                                      " (in 'hmm_gaussian', line 65, column 32 to column 33)",
                                                      " (in 'hmm_gaussian', line 5, column 4 to column 22)",
                                                      " (in 'hmm_gaussian', line 4, column 29 to line 6, column 3)"};
template <typename T0__>
Eigen::Matrix<stan::promote_args_t<stan::value_type_t<T0__>>, -1, 1>
normalize(const T0__& x_arg__, std::ostream* pstream__) {
  using local_scalar_t__ = stan::promote_args_t<stan::value_type_t<T0__>>;
  const auto& x = to_ref(x_arg__);
  const static bool propto__ = true;
  (void) propto__;
  local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
  (void) DUMMY_VAR__;  // suppress unused var warning
  
  try {
    current_statement__ = 137;
    return divide(x, sum(x));
  } catch (const std::exception& e) {
    stan::lang::rethrow_located(e, locations_array__[current_statement__]);
      // Next line prevents compiler griping about no return
      throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***"); 
  }
  
}
struct normalize_functor__ {
template <typename T0__>
Eigen::Matrix<stan::promote_args_t<stan::value_type_t<T0__>>, -1, 1>
operator()(const T0__& x, std::ostream* pstream__)  const 
{
return normalize(x, pstream__);
}
};
#include <stan_meta_header.hpp>
class model_hmm_gaussian final : public model_base_crtp<model_hmm_gaussian> {
private:
  int T;
  int K;
  std::vector<double> x_t;
  int est_sigma;
  std::vector<double> sigma_t;
 
public:
  ~model_hmm_gaussian() { }
  
  inline std::string model_name() const final { return "model_hmm_gaussian"; }
  inline std::vector<std::string> model_compile_info() const noexcept {
    return std::vector<std::string>{"stanc_version = stanc3 v2.26.1-4-gd72b68b7-dirty", "stancflags = "};
  }
  
  
  model_hmm_gaussian(stan::io::var_context& context__,
                     unsigned int random_seed__ = 0,
                     std::ostream* pstream__ = nullptr) : model_base_crtp(0) {
    using local_scalar_t__ = double ;
    boost::ecuyer1988 base_rng__ = 
        stan::services::util::create_rng(random_seed__, 0);
    (void) base_rng__;  // suppress unused var warning
    static const char* function__ = "model_hmm_gaussian_namespace::model_hmm_gaussian";
    (void) function__;  // suppress unused var warning
    local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
    (void) DUMMY_VAR__;  // suppress unused var warning
    
    try {
      int pos__;
      pos__ = std::numeric_limits<int>::min();
      
      pos__ = 1;
      current_statement__ = 111;
      context__.validate_dims("data initialization","T","int",
          context__.to_vec());
      T = std::numeric_limits<int>::min();
      
      current_statement__ = 111;
      T = context__.vals_i("T")[(1 - 1)];
      current_statement__ = 111;
      current_statement__ = 111;
      check_greater_or_equal(function__, "T", T, 1);
      current_statement__ = 112;
      context__.validate_dims("data initialization","K","int",
          context__.to_vec());
      K = std::numeric_limits<int>::min();
      
      current_statement__ = 112;
      K = context__.vals_i("K")[(1 - 1)];
      current_statement__ = 112;
      current_statement__ = 112;
      check_greater_or_equal(function__, "K", K, 1);
      current_statement__ = 113;
      validate_non_negative_index("x_t", "T", T);
      current_statement__ = 114;
      context__.validate_dims("data initialization","x_t","double",
          context__.to_vec(T));
      x_t = std::vector<double>(T, std::numeric_limits<double>::quiet_NaN());
      
      current_statement__ = 114;
      assign(x_t, nil_index_list(), context__.vals_r("x_t"),
        "assigning variable x_t");
      current_statement__ = 115;
      context__.validate_dims("data initialization","est_sigma","int",
          context__.to_vec());
      est_sigma = std::numeric_limits<int>::min();
      
      current_statement__ = 115;
      est_sigma = context__.vals_i("est_sigma")[(1 - 1)];
      current_statement__ = 115;
      current_statement__ = 115;
      check_greater_or_equal(function__, "est_sigma", est_sigma, 0);
      current_statement__ = 116;
      validate_non_negative_index("sigma_t", "T", T);
      current_statement__ = 117;
      context__.validate_dims("data initialization","sigma_t","double",
          context__.to_vec(T));
      sigma_t = std::vector<double>(T, std::numeric_limits<double>::quiet_NaN());
      
      current_statement__ = 117;
      assign(sigma_t, nil_index_list(), context__.vals_r("sigma_t"),
        "assigning variable sigma_t");
      current_statement__ = 118;
      validate_positive_index("p_1k", "K", K);
      current_statement__ = 119;
      validate_non_negative_index("A_ij", "K", K);
      current_statement__ = 120;
      validate_positive_index("A_ij", "K", K);
      current_statement__ = 121;
      validate_non_negative_index("mu_k", "K", K);
      current_statement__ = 122;
      validate_non_negative_index("sigma_k", "K", K);
      current_statement__ = 123;
      validate_non_negative_index("unalpha_tk", "T", T);
      current_statement__ = 124;
      validate_non_negative_index("unalpha_tk", "K", K);
      current_statement__ = 125;
      validate_non_negative_index("unbeta_tk", "T", T);
      current_statement__ = 126;
      validate_non_negative_index("unbeta_tk", "K", K);
      current_statement__ = 127;
      validate_non_negative_index("ungamma_tk", "T", T);
      current_statement__ = 128;
      validate_non_negative_index("ungamma_tk", "K", K);
      current_statement__ = 129;
      validate_non_negative_index("alpha_tk", "T", T);
      current_statement__ = 130;
      validate_non_negative_index("alpha_tk", "K", K);
      current_statement__ = 131;
      validate_non_negative_index("beta_tk", "T", T);
      current_statement__ = 132;
      validate_non_negative_index("beta_tk", "K", K);
      current_statement__ = 133;
      validate_non_negative_index("gamma_tk", "T", T);
      current_statement__ = 134;
      validate_non_negative_index("gamma_tk", "K", K);
      current_statement__ = 135;
      validate_non_negative_index("log_lik", "T", T);
      current_statement__ = 136;
      validate_non_negative_index("zstar_t", "T", T);
    } catch (const std::exception& e) {
      stan::lang::rethrow_located(e, locations_array__[current_statement__]);
      // Next line prevents compiler griping about no return
      throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***"); 
    }
    num_params_r__ = 0U;
    
    try {
      num_params_r__ += (K - 1);
      num_params_r__ += K * (K - 1);
      num_params_r__ += K;
      num_params_r__ += K;
    } catch (const std::exception& e) {
      stan::lang::rethrow_located(e, locations_array__[current_statement__]);
      // Next line prevents compiler griping about no return
      throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***"); 
    }
  }
  template <bool propto__, bool jacobian__, typename VecR, typename VecI, stan::require_vector_like_t<VecR>* = nullptr, stan::require_vector_like_vt<std::is_integral, VecI>* = nullptr>
  inline stan::scalar_type_t<VecR> log_prob_impl(VecR& params_r__,
                                                 VecI& params_i__,
                                                 std::ostream* pstream__ = nullptr) const {
    using T__ = stan::scalar_type_t<VecR>;
    using local_scalar_t__ = T__;
    T__ lp__(0.0);
    stan::math::accumulator<T__> lp_accum__;
    static const char* function__ = "model_hmm_gaussian_namespace::log_prob";
(void) function__;  // suppress unused var warning
    stan::io::reader<local_scalar_t__> in__(params_r__, params_i__);
    local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
    (void) DUMMY_VAR__;  // suppress unused var warning
    
    try {
      Eigen::Matrix<local_scalar_t__, -1, 1> p_1k;
      p_1k = Eigen::Matrix<local_scalar_t__, -1, 1>(K);
      stan::math::fill(p_1k, DUMMY_VAR__);
      
      Eigen::Matrix<local_scalar_t__, -1, 1> p_1k_in__;
      p_1k_in__ = Eigen::Matrix<local_scalar_t__, -1, 1>((K - 1));
      stan::math::fill(p_1k_in__, DUMMY_VAR__);
      
      current_statement__ = 1;
      p_1k_in__ = in__.vector((K - 1));
      current_statement__ = 1;
      if (jacobian__) {
        current_statement__ = 1;
        assign(p_1k, nil_index_list(),
          stan::math::simplex_constrain(p_1k_in__, lp__),
          "assigning variable p_1k");
      } else {
        current_statement__ = 1;
        assign(p_1k, nil_index_list(),
          stan::math::simplex_constrain(p_1k_in__), "assigning variable p_1k");
      }
      std::vector<Eigen::Matrix<local_scalar_t__, -1, 1>> A_ij;
      A_ij = std::vector<Eigen::Matrix<local_scalar_t__, -1, 1>>(K, Eigen::Matrix<local_scalar_t__, -1, 1>(K));
      stan::math::fill(A_ij, DUMMY_VAR__);
      
      std::vector<Eigen::Matrix<local_scalar_t__, -1, 1>> A_ij_in__;
      A_ij_in__ = std::vector<Eigen::Matrix<local_scalar_t__, -1, 1>>(K, Eigen::Matrix<local_scalar_t__, -1, 1>(
        (K - 1)));
      stan::math::fill(A_ij_in__, DUMMY_VAR__);
      
      current_statement__ = 2;
      for (int sym1__ = 1; sym1__ <= K; ++sym1__) {
        current_statement__ = 2;
        assign(A_ij_in__, cons_list(index_uni(sym1__), nil_index_list()),
          in__.vector((K - 1)), "assigning variable A_ij_in__");}
      current_statement__ = 2;
      for (int sym1__ = 1; sym1__ <= K; ++sym1__) {
        current_statement__ = 2;
        if (jacobian__) {
          current_statement__ = 2;
          assign(A_ij, cons_list(index_uni(sym1__), nil_index_list()),
            stan::math::simplex_constrain(A_ij_in__[(sym1__ - 1)], lp__),
            "assigning variable A_ij");
        } else {
          current_statement__ = 2;
          assign(A_ij, cons_list(index_uni(sym1__), nil_index_list()),
            stan::math::simplex_constrain(A_ij_in__[(sym1__ - 1)]),
            "assigning variable A_ij");
        }}
      Eigen::Matrix<local_scalar_t__, -1, 1> mu_k;
      mu_k = Eigen::Matrix<local_scalar_t__, -1, 1>(K);
      stan::math::fill(mu_k, DUMMY_VAR__);
      
      current_statement__ = 3;
      mu_k = in__.vector(K);
      current_statement__ = 3;
      if (jacobian__) {
        current_statement__ = 3;
        assign(mu_k, nil_index_list(),
          stan::math::ordered_constrain(mu_k, lp__),
          "assigning variable mu_k");
      } else {
        current_statement__ = 3;
        assign(mu_k, nil_index_list(), stan::math::ordered_constrain(mu_k),
          "assigning variable mu_k");
      }
      std::vector<local_scalar_t__> sigma_k;
      sigma_k = std::vector<local_scalar_t__>(K, DUMMY_VAR__);
      
      current_statement__ = 4;
      for (int sym1__ = 1; sym1__ <= K; ++sym1__) {
        current_statement__ = 4;
        assign(sigma_k, cons_list(index_uni(sym1__), nil_index_list()),
          in__.scalar(), "assigning variable sigma_k");}
      current_statement__ = 4;
      for (int sym1__ = 1; sym1__ <= K; ++sym1__) {
        current_statement__ = 4;
        if (jacobian__) {
          current_statement__ = 4;
          assign(sigma_k, cons_list(index_uni(sym1__), nil_index_list()),
            stan::math::lb_constrain(sigma_k[(sym1__ - 1)], 0, lp__),
            "assigning variable sigma_k");
        } else {
          current_statement__ = 4;
          assign(sigma_k, cons_list(index_uni(sym1__), nil_index_list()),
            stan::math::lb_constrain(sigma_k[(sym1__ - 1)], 0),
            "assigning variable sigma_k");
        }}
      std::vector<Eigen::Matrix<local_scalar_t__, -1, 1>> unalpha_tk;
      unalpha_tk = std::vector<Eigen::Matrix<local_scalar_t__, -1, 1>>(T, Eigen::Matrix<local_scalar_t__, -1, 1>(K));
      stan::math::fill(unalpha_tk, DUMMY_VAR__);
      
      {
        current_statement__ = 6;
        validate_non_negative_index("accumulator", "K", K);
        std::vector<local_scalar_t__> accumulator;
        accumulator = std::vector<local_scalar_t__>(K, DUMMY_VAR__);
        
        current_statement__ = 12;
        if (logical_eq(est_sigma, 1)) {
          current_statement__ = 10;
          assign(unalpha_tk, cons_list(index_uni(1), nil_index_list()),
            add(stan::math::log(p_1k),
              normal_lpdf<false>(x_t[(1 - 1)], mu_k, sigma_k)),
            "assigning variable unalpha_tk");
        } else {
          current_statement__ = 8;
          assign(unalpha_tk, cons_list(index_uni(1), nil_index_list()),
            add(stan::math::log(p_1k),
              normal_lpdf<false>(x_t[(1 - 1)], mu_k, sigma_t[(1 - 1)])),
            "assigning variable unalpha_tk");
        }
        current_statement__ = 24;
        for (int t = 2; t <= T; ++t) {
          current_statement__ = 22;
          for (int j = 1; j <= K; ++j) {
            current_statement__ = 19;
            for (int i = 1; i <= K; ++i) {
              current_statement__ = 17;
              if (logical_eq(est_sigma, 1)) {
                current_statement__ = 15;
                assign(accumulator,
                  cons_list(index_uni(i), nil_index_list()),
                  ((unalpha_tk[((t - 1) - 1)][(i - 1)] +
                     stan::math::log(A_ij[(i - 1)][(j - 1)])) +
                    normal_lpdf<false>(x_t[(t - 1)], mu_k[(j - 1)],
                      sigma_k[(j - 1)])), "assigning variable accumulator");
              } else {
                current_statement__ = 13;
                assign(accumulator,
                  cons_list(index_uni(i), nil_index_list()),
                  ((unalpha_tk[((t - 1) - 1)][(i - 1)] +
                     stan::math::log(A_ij[(i - 1)][(j - 1)])) +
                    normal_lpdf<false>(x_t[(t - 1)], mu_k[(j - 1)],
                      sigma_t[(t - 1)])), "assigning variable accumulator");
              }}
            current_statement__ = 20;
            assign(unalpha_tk,
              cons_list(index_uni(t),
                cons_list(index_uni(j), nil_index_list())),
              log_sum_exp(accumulator), "assigning variable unalpha_tk");}}
      }
      {
        current_statement__ = 108;
        lp_accum__.add(student_t_lpdf<propto__>(sigma_k, 3, 0, 1));
        current_statement__ = 109;
        lp_accum__.add(student_t_lpdf<propto__>(mu_k, 3, 0, 3));
        current_statement__ = 110;
        lp_accum__.add(log_sum_exp(unalpha_tk[(T - 1)]));
      }
    } catch (const std::exception& e) {
      stan::lang::rethrow_located(e, locations_array__[current_statement__]);
      // Next line prevents compiler griping about no return
      throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***"); 
    }
    lp_accum__.add(lp__);
    return lp_accum__.sum();
    } // log_prob_impl() 
    
  template <typename RNG, typename VecR, typename VecI, typename VecVar, stan::require_vector_like_vt<std::is_floating_point, VecR>* = nullptr, stan::require_vector_like_vt<std::is_integral, VecI>* = nullptr, stan::require_std_vector_vt<std::is_floating_point, VecVar>* = nullptr>
  inline void write_array_impl(RNG& base_rng__, VecR& params_r__,
                               VecI& params_i__, VecVar& vars__,
                               const bool emit_transformed_parameters__ = true,
                               const bool emit_generated_quantities__ = true,
                               std::ostream* pstream__ = nullptr) const {
    using local_scalar_t__ = double;
    vars__.resize(0);
    stan::io::reader<local_scalar_t__> in__(params_r__, params_i__);
    static const char* function__ = "model_hmm_gaussian_namespace::write_array";
(void) function__;  // suppress unused var warning
    (void) function__;  // suppress unused var warning
    double lp__ = 0.0;
    (void) lp__;  // dummy to suppress unused var warning
    stan::math::accumulator<double> lp_accum__;
    local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
    (void) DUMMY_VAR__;  // suppress unused var warning
    
    try {
      Eigen::Matrix<double, -1, 1> p_1k;
      p_1k = Eigen::Matrix<double, -1, 1>(K);
      stan::math::fill(p_1k, std::numeric_limits<double>::quiet_NaN());
      
      Eigen::Matrix<local_scalar_t__, -1, 1> p_1k_in__;
      p_1k_in__ = Eigen::Matrix<local_scalar_t__, -1, 1>((K - 1));
      stan::math::fill(p_1k_in__, DUMMY_VAR__);
      
      current_statement__ = 1;
      p_1k_in__ = in__.vector((K - 1));
      current_statement__ = 1;
      assign(p_1k, nil_index_list(),
        stan::math::simplex_constrain(p_1k_in__), "assigning variable p_1k");
      std::vector<Eigen::Matrix<double, -1, 1>> A_ij;
      A_ij = std::vector<Eigen::Matrix<double, -1, 1>>(K, Eigen::Matrix<double, -1, 1>(K));
      stan::math::fill(A_ij, std::numeric_limits<double>::quiet_NaN());
      
      std::vector<Eigen::Matrix<local_scalar_t__, -1, 1>> A_ij_in__;
      A_ij_in__ = std::vector<Eigen::Matrix<local_scalar_t__, -1, 1>>(K, Eigen::Matrix<local_scalar_t__, -1, 1>(
        (K - 1)));
      stan::math::fill(A_ij_in__, DUMMY_VAR__);
      
      current_statement__ = 2;
      for (int sym1__ = 1; sym1__ <= K; ++sym1__) {
        current_statement__ = 2;
        assign(A_ij_in__, cons_list(index_uni(sym1__), nil_index_list()),
          in__.vector((K - 1)), "assigning variable A_ij_in__");}
      current_statement__ = 2;
      for (int sym1__ = 1; sym1__ <= K; ++sym1__) {
        current_statement__ = 2;
        assign(A_ij, cons_list(index_uni(sym1__), nil_index_list()),
          stan::math::simplex_constrain(A_ij_in__[(sym1__ - 1)]),
          "assigning variable A_ij");}
      Eigen::Matrix<double, -1, 1> mu_k;
      mu_k = Eigen::Matrix<double, -1, 1>(K);
      stan::math::fill(mu_k, std::numeric_limits<double>::quiet_NaN());
      
      current_statement__ = 3;
      mu_k = in__.vector(K);
      current_statement__ = 3;
      assign(mu_k, nil_index_list(), stan::math::ordered_constrain(mu_k),
        "assigning variable mu_k");
      std::vector<double> sigma_k;
      sigma_k = std::vector<double>(K, std::numeric_limits<double>::quiet_NaN());
      
      current_statement__ = 4;
      for (int sym1__ = 1; sym1__ <= K; ++sym1__) {
        current_statement__ = 4;
        assign(sigma_k, cons_list(index_uni(sym1__), nil_index_list()),
          in__.scalar(), "assigning variable sigma_k");}
      current_statement__ = 4;
      for (int sym1__ = 1; sym1__ <= K; ++sym1__) {
        current_statement__ = 4;
        assign(sigma_k, cons_list(index_uni(sym1__), nil_index_list()),
          stan::math::lb_constrain(sigma_k[(sym1__ - 1)], 0),
          "assigning variable sigma_k");}
      std::vector<Eigen::Matrix<double, -1, 1>> unalpha_tk;
      unalpha_tk = std::vector<Eigen::Matrix<double, -1, 1>>(T, Eigen::Matrix<double, -1, 1>(K));
      stan::math::fill(unalpha_tk, std::numeric_limits<double>::quiet_NaN());
      
      for (int sym1__ = 1; sym1__ <= K; ++sym1__) {
        vars__.emplace_back(p_1k[(sym1__ - 1)]);}
      for (int sym1__ = 1; sym1__ <= K; ++sym1__) {
        for (int sym2__ = 1; sym2__ <= K; ++sym2__) {
          vars__.emplace_back(A_ij[(sym2__ - 1)][(sym1__ - 1)]);}}
      for (int sym1__ = 1; sym1__ <= K; ++sym1__) {
        vars__.emplace_back(mu_k[(sym1__ - 1)]);}
      for (int sym1__ = 1; sym1__ <= K; ++sym1__) {
        vars__.emplace_back(sigma_k[(sym1__ - 1)]);}
      if (logical_negation((primitive_value(emit_transformed_parameters__) ||
            primitive_value(emit_generated_quantities__)))) {
        return ;
      } 
      {
        current_statement__ = 6;
        validate_non_negative_index("accumulator", "K", K);
        std::vector<double> accumulator;
        accumulator = std::vector<double>(K, std::numeric_limits<double>::quiet_NaN());
        
        current_statement__ = 12;
        if (logical_eq(est_sigma, 1)) {
          current_statement__ = 10;
          assign(unalpha_tk, cons_list(index_uni(1), nil_index_list()),
            add(stan::math::log(p_1k),
              normal_lpdf<false>(x_t[(1 - 1)], mu_k, sigma_k)),
            "assigning variable unalpha_tk");
        } else {
          current_statement__ = 8;
          assign(unalpha_tk, cons_list(index_uni(1), nil_index_list()),
            add(stan::math::log(p_1k),
              normal_lpdf<false>(x_t[(1 - 1)], mu_k, sigma_t[(1 - 1)])),
            "assigning variable unalpha_tk");
        }
        current_statement__ = 24;
        for (int t = 2; t <= T; ++t) {
          current_statement__ = 22;
          for (int j = 1; j <= K; ++j) {
            current_statement__ = 19;
            for (int i = 1; i <= K; ++i) {
              current_statement__ = 17;
              if (logical_eq(est_sigma, 1)) {
                current_statement__ = 15;
                assign(accumulator,
                  cons_list(index_uni(i), nil_index_list()),
                  ((unalpha_tk[((t - 1) - 1)][(i - 1)] +
                     stan::math::log(A_ij[(i - 1)][(j - 1)])) +
                    normal_lpdf<false>(x_t[(t - 1)], mu_k[(j - 1)],
                      sigma_k[(j - 1)])), "assigning variable accumulator");
              } else {
                current_statement__ = 13;
                assign(accumulator,
                  cons_list(index_uni(i), nil_index_list()),
                  ((unalpha_tk[((t - 1) - 1)][(i - 1)] +
                     stan::math::log(A_ij[(i - 1)][(j - 1)])) +
                    normal_lpdf<false>(x_t[(t - 1)], mu_k[(j - 1)],
                      sigma_t[(t - 1)])), "assigning variable accumulator");
              }}
            current_statement__ = 20;
            assign(unalpha_tk,
              cons_list(index_uni(t),
                cons_list(index_uni(j), nil_index_list())),
              log_sum_exp(accumulator), "assigning variable unalpha_tk");}}
      }
      if (emit_transformed_parameters__) {
        for (int sym1__ = 1; sym1__ <= K; ++sym1__) {
          for (int sym2__ = 1; sym2__ <= T; ++sym2__) {
            vars__.emplace_back(unalpha_tk[(sym2__ - 1)][(sym1__ - 1)]);}}
      } 
      if (logical_negation(emit_generated_quantities__)) {
        return ;
      } 
      std::vector<Eigen::Matrix<double, -1, 1>> unbeta_tk;
      unbeta_tk = std::vector<Eigen::Matrix<double, -1, 1>>(T, Eigen::Matrix<double, -1, 1>(K));
      stan::math::fill(unbeta_tk, std::numeric_limits<double>::quiet_NaN());
      
      std::vector<Eigen::Matrix<double, -1, 1>> ungamma_tk;
      ungamma_tk = std::vector<Eigen::Matrix<double, -1, 1>>(T, Eigen::Matrix<double, -1, 1>(K));
      stan::math::fill(ungamma_tk, std::numeric_limits<double>::quiet_NaN());
      
      std::vector<Eigen::Matrix<double, -1, 1>> alpha_tk;
      alpha_tk = std::vector<Eigen::Matrix<double, -1, 1>>(T, Eigen::Matrix<double, -1, 1>(K));
      stan::math::fill(alpha_tk, std::numeric_limits<double>::quiet_NaN());
      
      std::vector<Eigen::Matrix<double, -1, 1>> beta_tk;
      beta_tk = std::vector<Eigen::Matrix<double, -1, 1>>(T, Eigen::Matrix<double, -1, 1>(K));
      stan::math::fill(beta_tk, std::numeric_limits<double>::quiet_NaN());
      
      std::vector<Eigen::Matrix<double, -1, 1>> gamma_tk;
      gamma_tk = std::vector<Eigen::Matrix<double, -1, 1>>(T, Eigen::Matrix<double, -1, 1>(K));
      stan::math::fill(gamma_tk, std::numeric_limits<double>::quiet_NaN());
      
      Eigen::Matrix<double, -1, 1> log_lik;
      log_lik = Eigen::Matrix<double, -1, 1>(T);
      stan::math::fill(log_lik, std::numeric_limits<double>::quiet_NaN());
      
      std::vector<int> zstar_t;
      zstar_t = std::vector<int>(T, std::numeric_limits<int>::min());
      
      double logp_zstar_t;
      logp_zstar_t = std::numeric_limits<double>::quiet_NaN();
      
      {
        current_statement__ = 35;
        for (int t = 1; t <= T; ++t) {
          current_statement__ = 34;
          assign(alpha_tk, cons_list(index_uni(t), nil_index_list()),
            softmax(unalpha_tk[(t - 1)]), "assigning variable alpha_tk");}
      }
      {
        current_statement__ = 37;
        validate_non_negative_index("accumulator", "K", K);
        std::vector<double> accumulator;
        accumulator = std::vector<double>(K, std::numeric_limits<double>::quiet_NaN());
        
        current_statement__ = 40;
        for (int j = 1; j <= K; ++j) {
          current_statement__ = 39;
          assign(unbeta_tk,
            cons_list(index_uni(T),
              cons_list(index_uni(j), nil_index_list())), 1,
            "assigning variable unbeta_tk");}
        current_statement__ = 54;
        for (int tforward = 0; tforward <= (T - 2); ++tforward) {
          int t;
          t = std::numeric_limits<int>::min();
          
          current_statement__ = 42;
          t = (T - tforward);
          current_statement__ = 52;
          for (int j = 1; j <= K; ++j) {
            current_statement__ = 49;
            for (int i = 1; i <= K; ++i) {
              current_statement__ = 47;
              if (logical_eq(est_sigma, 1)) {
                current_statement__ = 45;
                assign(accumulator,
                  cons_list(index_uni(i), nil_index_list()),
                  ((unbeta_tk[(t - 1)][(i - 1)] +
                     stan::math::log(A_ij[(j - 1)][(i - 1)])) +
                    normal_lpdf<false>(x_t[(t - 1)], mu_k[(i - 1)],
                      sigma_k[(i - 1)])), "assigning variable accumulator");
              } else {
                current_statement__ = 43;
                assign(accumulator,
                  cons_list(index_uni(i), nil_index_list()),
                  ((unbeta_tk[(t - 1)][(i - 1)] +
                     stan::math::log(A_ij[(j - 1)][(i - 1)])) +
                    normal_lpdf<false>(x_t[(t - 1)], mu_k[(i - 1)],
                      sigma_t[(t - 1)])), "assigning variable accumulator");
              }}
            current_statement__ = 50;
            assign(unbeta_tk,
              cons_list(index_uni((t - 1)),
                cons_list(index_uni(j), nil_index_list())),
              log_sum_exp(accumulator), "assigning variable unbeta_tk");}}
        current_statement__ = 56;
        for (int t = 1; t <= T; ++t) {
          current_statement__ = 55;
          assign(beta_tk, cons_list(index_uni(t), nil_index_list()),
            softmax(unbeta_tk[(t - 1)]), "assigning variable beta_tk");}
      }
      {
        current_statement__ = 61;
        for (int t = 1; t <= T; ++t) {
          current_statement__ = 58;
          assign(ungamma_tk, cons_list(index_uni(t), nil_index_list()),
            elt_multiply(alpha_tk[(t - 1)], beta_tk[(t - 1)]),
            "assigning variable ungamma_tk");
          current_statement__ = 59;
          assign(gamma_tk, cons_list(index_uni(t), nil_index_list()),
            normalize(ungamma_tk[(t - 1)], pstream__),
            "assigning variable gamma_tk");}
        current_statement__ = 68;
        for (int t = 1; t <= T; ++t) {
          current_statement__ = 62;
          assign(log_lik, cons_list(index_uni(t), nil_index_list()), 0,
            "assigning variable log_lik");
          current_statement__ = 65;
          for (int j = 1; j <= K; ++j) {
            current_statement__ = 63;
            assign(log_lik, cons_list(index_uni(t), nil_index_list()),
              (log_lik[(t - 1)] +
                (gamma_tk[(t - 1)][(j - 1)] * alpha_tk[(t - 1)][(j - 1)])),
              "assigning variable log_lik");}
          current_statement__ = 66;
          assign(log_lik, cons_list(index_uni(t), nil_index_list()),
            stan::math::log(log_lik[(t - 1)]), "assigning variable log_lik");
        }
      }
      {
        current_statement__ = 70;
        validate_non_negative_index("a_tk", "T", T);
        current_statement__ = 71;
        validate_non_negative_index("a_tk", "K", K);
        std::vector<std::vector<int>> a_tk;
        a_tk = std::vector<std::vector<int>>(T, std::vector<int>(K, std::numeric_limits<int>::min()));
        
        current_statement__ = 73;
        validate_non_negative_index("delta_tk", "T", T);
        current_statement__ = 74;
        validate_non_negative_index("delta_tk", "K", K);
        std::vector<std::vector<double>> delta_tk;
        delta_tk = std::vector<std::vector<double>>(T, std::vector<double>(K, std::numeric_limits<double>::quiet_NaN()));
        
        current_statement__ = 82;
        if (logical_eq(est_sigma, 1)) {
          current_statement__ = 80;
          for (int j = 1; j <= K; ++j) {
            current_statement__ = 79;
            assign(delta_tk,
              cons_list(index_uni(1),
                cons_list(index_uni(K), nil_index_list())),
              normal_lpdf<false>(x_t[(1 - 1)], mu_k[(j - 1)],
                sigma_k[(j - 1)]), "assigning variable delta_tk");}
        } else {
          current_statement__ = 77;
          for (int j = 1; j <= K; ++j) {
            current_statement__ = 76;
            assign(delta_tk,
              cons_list(index_uni(1),
                cons_list(index_uni(K), nil_index_list())),
              normal_lpdf<false>(x_t[(1 - 1)], mu_k[(j - 1)],
                sigma_t[(1 - 1)]), "assigning variable delta_tk");}
        }
        current_statement__ = 99;
        for (int t = 2; t <= T; ++t) {
          current_statement__ = 97;
          for (int j = 1; j <= K; ++j) {
            current_statement__ = 83;
            assign(delta_tk,
              cons_list(index_uni(t),
                cons_list(index_uni(j), nil_index_list())),
              stan::math::negative_infinity(), "assigning variable delta_tk");
            current_statement__ = 95;
            for (int i = 1; i <= K; ++i) {
              double logp;
              logp = std::numeric_limits<double>::quiet_NaN();
              
              current_statement__ = 89;
              if (logical_eq(est_sigma, 1)) {
                current_statement__ = 87;
                logp = ((delta_tk[((t - 1) - 1)][(i - 1)] +
                          stan::math::log(A_ij[(i - 1)][(j - 1)])) +
                         normal_lpdf<false>(x_t[(t - 1)], mu_k[(j - 1)],
                           sigma_k[(j - 1)]));
              } else {
                current_statement__ = 85;
                logp = ((delta_tk[((t - 1) - 1)][(i - 1)] +
                          stan::math::log(A_ij[(i - 1)][(j - 1)])) +
                         normal_lpdf<false>(x_t[(t - 1)], mu_k[(j - 1)],
                           sigma_t[(t - 1)]));
              }
              current_statement__ = 93;
              if (logical_gt(logp, delta_tk[(t - 1)][(j - 1)])) {
                current_statement__ = 90;
                assign(a_tk,
                  cons_list(index_uni(t),
                    cons_list(index_uni(j), nil_index_list())), i,
                  "assigning variable a_tk");
                current_statement__ = 91;
                assign(delta_tk,
                  cons_list(index_uni(t),
                    cons_list(index_uni(j), nil_index_list())), logp,
                  "assigning variable delta_tk");
              } }}}
        current_statement__ = 100;
        logp_zstar_t = max(delta_tk[(T - 1)]);
        current_statement__ = 103;
        for (int j = 1; j <= K; ++j) {
          current_statement__ = 102;
          if (logical_eq(delta_tk[(T - 1)][(j - 1)], logp_zstar_t)) {
            current_statement__ = 101;
            assign(zstar_t, cons_list(index_uni(T), nil_index_list()), j,
              "assigning variable zstar_t");
          } }
        current_statement__ = 106;
        for (int t = 1; t <= (T - 1); ++t) {
          current_statement__ = 104;
          assign(zstar_t, cons_list(index_uni((T - t)), nil_index_list()),
            a_tk[(((T - t) + 1) - 1)][(zstar_t[(((T - t) + 1) - 1)] - 1)],
            "assigning variable zstar_t");}
      }
      current_statement__ = 32;
      for (int sym1__ = 1; sym1__ <= T; ++sym1__) {
        current_statement__ = 32;
        current_statement__ = 32;
        check_greater_or_equal(function__, "zstar_t[sym1__]",
                               zstar_t[(sym1__ - 1)], 1);}
      current_statement__ = 32;
      for (int sym1__ = 1; sym1__ <= T; ++sym1__) {
        current_statement__ = 32;
        current_statement__ = 32;
        check_less_or_equal(function__, "zstar_t[sym1__]",
                            zstar_t[(sym1__ - 1)], K);}
      for (int sym1__ = 1; sym1__ <= K; ++sym1__) {
        for (int sym2__ = 1; sym2__ <= T; ++sym2__) {
          vars__.emplace_back(unbeta_tk[(sym2__ - 1)][(sym1__ - 1)]);}}
      for (int sym1__ = 1; sym1__ <= K; ++sym1__) {
        for (int sym2__ = 1; sym2__ <= T; ++sym2__) {
          vars__.emplace_back(ungamma_tk[(sym2__ - 1)][(sym1__ - 1)]);}}
      for (int sym1__ = 1; sym1__ <= K; ++sym1__) {
        for (int sym2__ = 1; sym2__ <= T; ++sym2__) {
          vars__.emplace_back(alpha_tk[(sym2__ - 1)][(sym1__ - 1)]);}}
      for (int sym1__ = 1; sym1__ <= K; ++sym1__) {
        for (int sym2__ = 1; sym2__ <= T; ++sym2__) {
          vars__.emplace_back(beta_tk[(sym2__ - 1)][(sym1__ - 1)]);}}
      for (int sym1__ = 1; sym1__ <= K; ++sym1__) {
        for (int sym2__ = 1; sym2__ <= T; ++sym2__) {
          vars__.emplace_back(gamma_tk[(sym2__ - 1)][(sym1__ - 1)]);}}
      for (int sym1__ = 1; sym1__ <= T; ++sym1__) {
        vars__.emplace_back(log_lik[(sym1__ - 1)]);}
      for (int sym1__ = 1; sym1__ <= T; ++sym1__) {
        vars__.emplace_back(zstar_t[(sym1__ - 1)]);}
      vars__.emplace_back(logp_zstar_t);
    } catch (const std::exception& e) {
      stan::lang::rethrow_located(e, locations_array__[current_statement__]);
      // Next line prevents compiler griping about no return
      throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***"); 
    }
    } // write_array_impl() 
    
  template <typename VecVar, typename VecI, stan::require_std_vector_t<VecVar>* = nullptr, stan::require_vector_like_vt<std::is_integral, VecI>* = nullptr>
  inline void transform_inits_impl(const stan::io::var_context& context__,
                                   VecI& params_i__, VecVar& vars__,
                                   std::ostream* pstream__ = nullptr) const {
    using local_scalar_t__ = double;
    vars__.clear();
    vars__.reserve(num_params_r__);
    
    try {
      int pos__;
      pos__ = std::numeric_limits<int>::min();
      
      pos__ = 1;
      Eigen::Matrix<double, -1, 1> p_1k;
      p_1k = Eigen::Matrix<double, -1, 1>(K);
      stan::math::fill(p_1k, std::numeric_limits<double>::quiet_NaN());
      
      {
        std::vector<local_scalar_t__> p_1k_flat__;
        current_statement__ = 1;
        assign(p_1k_flat__, nil_index_list(), context__.vals_r("p_1k"),
          "assigning variable p_1k_flat__");
        current_statement__ = 1;
        pos__ = 1;
        current_statement__ = 1;
        for (int sym1__ = 1; sym1__ <= K; ++sym1__) {
          current_statement__ = 1;
          assign(p_1k, cons_list(index_uni(sym1__), nil_index_list()),
            p_1k_flat__[(pos__ - 1)], "assigning variable p_1k");
          current_statement__ = 1;
          pos__ = (pos__ + 1);}
      }
      Eigen::Matrix<double, -1, 1> p_1k_free__;
      p_1k_free__ = Eigen::Matrix<double, -1, 1>((K - 1));
      stan::math::fill(p_1k_free__, std::numeric_limits<double>::quiet_NaN());
      
      current_statement__ = 1;
      assign(p_1k_free__, nil_index_list(), stan::math::simplex_free(p_1k),
        "assigning variable p_1k_free__");
      std::vector<Eigen::Matrix<double, -1, 1>> A_ij;
      A_ij = std::vector<Eigen::Matrix<double, -1, 1>>(K, Eigen::Matrix<double, -1, 1>(K));
      stan::math::fill(A_ij, std::numeric_limits<double>::quiet_NaN());
      
      {
        std::vector<local_scalar_t__> A_ij_flat__;
        current_statement__ = 2;
        assign(A_ij_flat__, nil_index_list(), context__.vals_r("A_ij"),
          "assigning variable A_ij_flat__");
        current_statement__ = 2;
        pos__ = 1;
        current_statement__ = 2;
        for (int sym1__ = 1; sym1__ <= K; ++sym1__) {
          current_statement__ = 2;
          for (int sym2__ = 1; sym2__ <= K; ++sym2__) {
            current_statement__ = 2;
            assign(A_ij,
              cons_list(index_uni(sym2__),
                cons_list(index_uni(sym1__), nil_index_list())),
              A_ij_flat__[(pos__ - 1)], "assigning variable A_ij");
            current_statement__ = 2;
            pos__ = (pos__ + 1);}}
      }
      std::vector<Eigen::Matrix<double, -1, 1>> A_ij_free__;
      A_ij_free__ = std::vector<Eigen::Matrix<double, -1, 1>>(K, Eigen::Matrix<double, -1, 1>(
        (K - 1)));
      stan::math::fill(A_ij_free__, std::numeric_limits<double>::quiet_NaN());
      
      current_statement__ = 2;
      for (int sym1__ = 1; sym1__ <= K; ++sym1__) {
        current_statement__ = 2;
        assign(A_ij_free__, cons_list(index_uni(sym1__), nil_index_list()),
          stan::math::simplex_free(A_ij[(sym1__ - 1)]),
          "assigning variable A_ij_free__");}
      Eigen::Matrix<double, -1, 1> mu_k;
      mu_k = Eigen::Matrix<double, -1, 1>(K);
      stan::math::fill(mu_k, std::numeric_limits<double>::quiet_NaN());
      
      {
        std::vector<local_scalar_t__> mu_k_flat__;
        current_statement__ = 3;
        assign(mu_k_flat__, nil_index_list(), context__.vals_r("mu_k"),
          "assigning variable mu_k_flat__");
        current_statement__ = 3;
        pos__ = 1;
        current_statement__ = 3;
        for (int sym1__ = 1; sym1__ <= K; ++sym1__) {
          current_statement__ = 3;
          assign(mu_k, cons_list(index_uni(sym1__), nil_index_list()),
            mu_k_flat__[(pos__ - 1)], "assigning variable mu_k");
          current_statement__ = 3;
          pos__ = (pos__ + 1);}
      }
      Eigen::Matrix<double, -1, 1> mu_k_free__;
      mu_k_free__ = Eigen::Matrix<double, -1, 1>(K);
      stan::math::fill(mu_k_free__, std::numeric_limits<double>::quiet_NaN());
      
      current_statement__ = 3;
      assign(mu_k_free__, nil_index_list(), stan::math::ordered_free(mu_k),
        "assigning variable mu_k_free__");
      std::vector<double> sigma_k;
      sigma_k = std::vector<double>(K, std::numeric_limits<double>::quiet_NaN());
      
      current_statement__ = 4;
      assign(sigma_k, nil_index_list(), context__.vals_r("sigma_k"),
        "assigning variable sigma_k");
      std::vector<double> sigma_k_free__;
      sigma_k_free__ = std::vector<double>(K, std::numeric_limits<double>::quiet_NaN());
      
      current_statement__ = 4;
      for (int sym1__ = 1; sym1__ <= K; ++sym1__) {
        current_statement__ = 4;
        assign(sigma_k_free__,
          cons_list(index_uni(sym1__), nil_index_list()),
          stan::math::lb_free(sigma_k[(sym1__ - 1)], 0),
          "assigning variable sigma_k_free__");}
      for (int sym1__ = 1; sym1__ <= (K - 1); ++sym1__) {
        vars__.emplace_back(p_1k_free__[(sym1__ - 1)]);}
      for (int sym1__ = 1; sym1__ <= K; ++sym1__) {
        for (int sym2__ = 1; sym2__ <= (K - 1); ++sym2__) {
          vars__.emplace_back(A_ij_free__[(sym1__ - 1)][(sym2__ - 1)]);}}
      for (int sym1__ = 1; sym1__ <= K; ++sym1__) {
        vars__.emplace_back(mu_k_free__[(sym1__ - 1)]);}
      for (int sym1__ = 1; sym1__ <= K; ++sym1__) {
        vars__.emplace_back(sigma_k_free__[(sym1__ - 1)]);}
    } catch (const std::exception& e) {
      stan::lang::rethrow_located(e, locations_array__[current_statement__]);
      // Next line prevents compiler griping about no return
      throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***"); 
    }
    } // transform_inits_impl() 
    
  inline void get_param_names(std::vector<std::string>& names__) const {
    
    names__.clear();
    names__.emplace_back("p_1k");
    names__.emplace_back("A_ij");
    names__.emplace_back("mu_k");
    names__.emplace_back("sigma_k");
    names__.emplace_back("unalpha_tk");
    names__.emplace_back("unbeta_tk");
    names__.emplace_back("ungamma_tk");
    names__.emplace_back("alpha_tk");
    names__.emplace_back("beta_tk");
    names__.emplace_back("gamma_tk");
    names__.emplace_back("log_lik");
    names__.emplace_back("zstar_t");
    names__.emplace_back("logp_zstar_t");
    } // get_param_names() 
    
  inline void get_dims(std::vector<std::vector<size_t>>& dimss__) const {
    dimss__.clear();
    dimss__.emplace_back(std::vector<size_t>{static_cast<size_t>(K)});
    
    dimss__.emplace_back(std::vector<size_t>{static_cast<size_t>(K),
                                             static_cast<size_t>(K)});
    
    dimss__.emplace_back(std::vector<size_t>{static_cast<size_t>(K)});
    
    dimss__.emplace_back(std::vector<size_t>{static_cast<size_t>(K)});
    
    dimss__.emplace_back(std::vector<size_t>{static_cast<size_t>(T),
                                             static_cast<size_t>(K)});
    
    dimss__.emplace_back(std::vector<size_t>{static_cast<size_t>(T),
                                             static_cast<size_t>(K)});
    
    dimss__.emplace_back(std::vector<size_t>{static_cast<size_t>(T),
                                             static_cast<size_t>(K)});
    
    dimss__.emplace_back(std::vector<size_t>{static_cast<size_t>(T),
                                             static_cast<size_t>(K)});
    
    dimss__.emplace_back(std::vector<size_t>{static_cast<size_t>(T),
                                             static_cast<size_t>(K)});
    
    dimss__.emplace_back(std::vector<size_t>{static_cast<size_t>(T),
                                             static_cast<size_t>(K)});
    
    dimss__.emplace_back(std::vector<size_t>{static_cast<size_t>(T)});
    
    dimss__.emplace_back(std::vector<size_t>{static_cast<size_t>(T)});
    
    dimss__.emplace_back(std::vector<size_t>{});
    
    } // get_dims() 
    
  inline void constrained_param_names(
                                      std::vector<std::string>& param_names__,
                                      bool emit_transformed_parameters__ = true,
                                      bool emit_generated_quantities__ = true) const
    final {
    
    for (int sym1__ = 1; sym1__ <= K; ++sym1__) {
      {
        param_names__.emplace_back(std::string() + "p_1k" + '.' + std::to_string(sym1__));
      }}
    for (int sym1__ = 1; sym1__ <= K; ++sym1__) {
      {
        for (int sym2__ = 1; sym2__ <= K; ++sym2__) {
          {
            param_names__.emplace_back(std::string() + "A_ij" + '.' + std::to_string(sym2__) + '.' + std::to_string(sym1__));
          }}
      }}
    for (int sym1__ = 1; sym1__ <= K; ++sym1__) {
      {
        param_names__.emplace_back(std::string() + "mu_k" + '.' + std::to_string(sym1__));
      }}
    for (int sym1__ = 1; sym1__ <= K; ++sym1__) {
      {
        param_names__.emplace_back(std::string() + "sigma_k" + '.' + std::to_string(sym1__));
      }}
    if (emit_transformed_parameters__) {
      for (int sym1__ = 1; sym1__ <= K; ++sym1__) {
        {
          for (int sym2__ = 1; sym2__ <= T; ++sym2__) {
            {
              param_names__.emplace_back(std::string() + "unalpha_tk" + '.' + std::to_string(sym2__) + '.' + std::to_string(sym1__));
            }}
        }}
    }
    
    if (emit_generated_quantities__) {
      for (int sym1__ = 1; sym1__ <= K; ++sym1__) {
        {
          for (int sym2__ = 1; sym2__ <= T; ++sym2__) {
            {
              param_names__.emplace_back(std::string() + "unbeta_tk" + '.' + std::to_string(sym2__) + '.' + std::to_string(sym1__));
            }}
        }}
      for (int sym1__ = 1; sym1__ <= K; ++sym1__) {
        {
          for (int sym2__ = 1; sym2__ <= T; ++sym2__) {
            {
              param_names__.emplace_back(std::string() + "ungamma_tk" + '.' + std::to_string(sym2__) + '.' + std::to_string(sym1__));
            }}
        }}
      for (int sym1__ = 1; sym1__ <= K; ++sym1__) {
        {
          for (int sym2__ = 1; sym2__ <= T; ++sym2__) {
            {
              param_names__.emplace_back(std::string() + "alpha_tk" + '.' + std::to_string(sym2__) + '.' + std::to_string(sym1__));
            }}
        }}
      for (int sym1__ = 1; sym1__ <= K; ++sym1__) {
        {
          for (int sym2__ = 1; sym2__ <= T; ++sym2__) {
            {
              param_names__.emplace_back(std::string() + "beta_tk" + '.' + std::to_string(sym2__) + '.' + std::to_string(sym1__));
            }}
        }}
      for (int sym1__ = 1; sym1__ <= K; ++sym1__) {
        {
          for (int sym2__ = 1; sym2__ <= T; ++sym2__) {
            {
              param_names__.emplace_back(std::string() + "gamma_tk" + '.' + std::to_string(sym2__) + '.' + std::to_string(sym1__));
            }}
        }}
      for (int sym1__ = 1; sym1__ <= T; ++sym1__) {
        {
          param_names__.emplace_back(std::string() + "log_lik" + '.' + std::to_string(sym1__));
        }}
      for (int sym1__ = 1; sym1__ <= T; ++sym1__) {
        {
          param_names__.emplace_back(std::string() + "zstar_t" + '.' + std::to_string(sym1__));
        }}
      param_names__.emplace_back(std::string() + "logp_zstar_t");
    }
    
    } // constrained_param_names() 
    
  inline void unconstrained_param_names(
                                        std::vector<std::string>& param_names__,
                                        bool emit_transformed_parameters__ = true,
                                        bool emit_generated_quantities__ = true) const
    final {
    
    for (int sym1__ = 1; sym1__ <= (K - 1); ++sym1__) {
      {
        param_names__.emplace_back(std::string() + "p_1k" + '.' + std::to_string(sym1__));
      }}
    for (int sym1__ = 1; sym1__ <= (K - 1); ++sym1__) {
      {
        for (int sym2__ = 1; sym2__ <= K; ++sym2__) {
          {
            param_names__.emplace_back(std::string() + "A_ij" + '.' + std::to_string(sym2__) + '.' + std::to_string(sym1__));
          }}
      }}
    for (int sym1__ = 1; sym1__ <= K; ++sym1__) {
      {
        param_names__.emplace_back(std::string() + "mu_k" + '.' + std::to_string(sym1__));
      }}
    for (int sym1__ = 1; sym1__ <= K; ++sym1__) {
      {
        param_names__.emplace_back(std::string() + "sigma_k" + '.' + std::to_string(sym1__));
      }}
    if (emit_transformed_parameters__) {
      for (int sym1__ = 1; sym1__ <= K; ++sym1__) {
        {
          for (int sym2__ = 1; sym2__ <= T; ++sym2__) {
            {
              param_names__.emplace_back(std::string() + "unalpha_tk" + '.' + std::to_string(sym2__) + '.' + std::to_string(sym1__));
            }}
        }}
    }
    
    if (emit_generated_quantities__) {
      for (int sym1__ = 1; sym1__ <= K; ++sym1__) {
        {
          for (int sym2__ = 1; sym2__ <= T; ++sym2__) {
            {
              param_names__.emplace_back(std::string() + "unbeta_tk" + '.' + std::to_string(sym2__) + '.' + std::to_string(sym1__));
            }}
        }}
      for (int sym1__ = 1; sym1__ <= K; ++sym1__) {
        {
          for (int sym2__ = 1; sym2__ <= T; ++sym2__) {
            {
              param_names__.emplace_back(std::string() + "ungamma_tk" + '.' + std::to_string(sym2__) + '.' + std::to_string(sym1__));
            }}
        }}
      for (int sym1__ = 1; sym1__ <= K; ++sym1__) {
        {
          for (int sym2__ = 1; sym2__ <= T; ++sym2__) {
            {
              param_names__.emplace_back(std::string() + "alpha_tk" + '.' + std::to_string(sym2__) + '.' + std::to_string(sym1__));
            }}
        }}
      for (int sym1__ = 1; sym1__ <= K; ++sym1__) {
        {
          for (int sym2__ = 1; sym2__ <= T; ++sym2__) {
            {
              param_names__.emplace_back(std::string() + "beta_tk" + '.' + std::to_string(sym2__) + '.' + std::to_string(sym1__));
            }}
        }}
      for (int sym1__ = 1; sym1__ <= K; ++sym1__) {
        {
          for (int sym2__ = 1; sym2__ <= T; ++sym2__) {
            {
              param_names__.emplace_back(std::string() + "gamma_tk" + '.' + std::to_string(sym2__) + '.' + std::to_string(sym1__));
            }}
        }}
      for (int sym1__ = 1; sym1__ <= T; ++sym1__) {
        {
          param_names__.emplace_back(std::string() + "log_lik" + '.' + std::to_string(sym1__));
        }}
      for (int sym1__ = 1; sym1__ <= T; ++sym1__) {
        {
          param_names__.emplace_back(std::string() + "zstar_t" + '.' + std::to_string(sym1__));
        }}
      param_names__.emplace_back(std::string() + "logp_zstar_t");
    }
    
    } // unconstrained_param_names() 
    
  inline std::string get_constrained_sizedtypes() const {
    stringstream s__;
    s__ << "[{\"name\":\"p_1k\",\"type\":{\"name\":\"vector\",\"length\":" << K << "},\"block\":\"parameters\"},{\"name\":\"A_ij\",\"type\":{\"name\":\"array\",\"length\":" << K << ",\"element_type\":{\"name\":\"vector\",\"length\":" << K << "}},\"block\":\"parameters\"},{\"name\":\"mu_k\",\"type\":{\"name\":\"vector\",\"length\":" << K << "},\"block\":\"parameters\"},{\"name\":\"sigma_k\",\"type\":{\"name\":\"array\",\"length\":" << K << ",\"element_type\":{\"name\":\"real\"}},\"block\":\"parameters\"},{\"name\":\"unalpha_tk\",\"type\":{\"name\":\"array\",\"length\":" << T << ",\"element_type\":{\"name\":\"vector\",\"length\":" << K << "}},\"block\":\"transformed_parameters\"},{\"name\":\"unbeta_tk\",\"type\":{\"name\":\"array\",\"length\":" << T << ",\"element_type\":{\"name\":\"vector\",\"length\":" << K << "}},\"block\":\"generated_quantities\"},{\"name\":\"ungamma_tk\",\"type\":{\"name\":\"array\",\"length\":" << T << ",\"element_type\":{\"name\":\"vector\",\"length\":" << K << "}},\"block\":\"generated_quantities\"},{\"name\":\"alpha_tk\",\"type\":{\"name\":\"array\",\"length\":" << T << ",\"element_type\":{\"name\":\"vector\",\"length\":" << K << "}},\"block\":\"generated_quantities\"},{\"name\":\"beta_tk\",\"type\":{\"name\":\"array\",\"length\":" << T << ",\"element_type\":{\"name\":\"vector\",\"length\":" << K << "}},\"block\":\"generated_quantities\"},{\"name\":\"gamma_tk\",\"type\":{\"name\":\"array\",\"length\":" << T << ",\"element_type\":{\"name\":\"vector\",\"length\":" << K << "}},\"block\":\"generated_quantities\"},{\"name\":\"log_lik\",\"type\":{\"name\":\"vector\",\"length\":" << T << "},\"block\":\"generated_quantities\"},{\"name\":\"zstar_t\",\"type\":{\"name\":\"array\",\"length\":" << T << ",\"element_type\":{\"name\":\"int\"}},\"block\":\"generated_quantities\"},{\"name\":\"logp_zstar_t\",\"type\":{\"name\":\"real\"},\"block\":\"generated_quantities\"}]";
    return s__.str();
    } // get_constrained_sizedtypes() 
    
  inline std::string get_unconstrained_sizedtypes() const {
    stringstream s__;
    s__ << "[{\"name\":\"p_1k\",\"type\":{\"name\":\"vector\",\"length\":" << (K - 1) << "},\"block\":\"parameters\"},{\"name\":\"A_ij\",\"type\":{\"name\":\"array\",\"length\":" << K << ",\"element_type\":{\"name\":\"vector\",\"length\":" << (K - 1) << "}},\"block\":\"parameters\"},{\"name\":\"mu_k\",\"type\":{\"name\":\"vector\",\"length\":" << K << "},\"block\":\"parameters\"},{\"name\":\"sigma_k\",\"type\":{\"name\":\"array\",\"length\":" << K << ",\"element_type\":{\"name\":\"real\"}},\"block\":\"parameters\"},{\"name\":\"unalpha_tk\",\"type\":{\"name\":\"array\",\"length\":" << T << ",\"element_type\":{\"name\":\"vector\",\"length\":" << K << "}},\"block\":\"transformed_parameters\"},{\"name\":\"unbeta_tk\",\"type\":{\"name\":\"array\",\"length\":" << T << ",\"element_type\":{\"name\":\"vector\",\"length\":" << K << "}},\"block\":\"generated_quantities\"},{\"name\":\"ungamma_tk\",\"type\":{\"name\":\"array\",\"length\":" << T << ",\"element_type\":{\"name\":\"vector\",\"length\":" << K << "}},\"block\":\"generated_quantities\"},{\"name\":\"alpha_tk\",\"type\":{\"name\":\"array\",\"length\":" << T << ",\"element_type\":{\"name\":\"vector\",\"length\":" << K << "}},\"block\":\"generated_quantities\"},{\"name\":\"beta_tk\",\"type\":{\"name\":\"array\",\"length\":" << T << ",\"element_type\":{\"name\":\"vector\",\"length\":" << K << "}},\"block\":\"generated_quantities\"},{\"name\":\"gamma_tk\",\"type\":{\"name\":\"array\",\"length\":" << T << ",\"element_type\":{\"name\":\"vector\",\"length\":" << K << "}},\"block\":\"generated_quantities\"},{\"name\":\"log_lik\",\"type\":{\"name\":\"vector\",\"length\":" << T << "},\"block\":\"generated_quantities\"},{\"name\":\"zstar_t\",\"type\":{\"name\":\"array\",\"length\":" << T << ",\"element_type\":{\"name\":\"int\"}},\"block\":\"generated_quantities\"},{\"name\":\"logp_zstar_t\",\"type\":{\"name\":\"real\"},\"block\":\"generated_quantities\"}]";
    return s__.str();
    } // get_unconstrained_sizedtypes() 
    
  
    // Begin method overload boilerplate
    template <typename RNG>
    inline void write_array(RNG& base_rng,
                            Eigen::Matrix<double,Eigen::Dynamic,1>& params_r,
                            Eigen::Matrix<double,Eigen::Dynamic,1>& vars,
                            const bool emit_transformed_parameters = true,
                            const bool emit_generated_quantities = true,
                            std::ostream* pstream = nullptr) const {
      std::vector<double> vars_vec(vars.size());
      std::vector<int> params_i;
      write_array_impl(base_rng, params_r, params_i, vars_vec,
          emit_transformed_parameters, emit_generated_quantities, pstream);
      vars.resize(vars_vec.size());
      for (int i = 0; i < vars.size(); ++i) {
        vars.coeffRef(i) = vars_vec[i];
      }
    }
    template <typename RNG>
    inline void write_array(RNG& base_rng, std::vector<double>& params_r,
                            std::vector<int>& params_i,
                            std::vector<double>& vars,
                            bool emit_transformed_parameters = true,
                            bool emit_generated_quantities = true,
                            std::ostream* pstream = nullptr) const {
      write_array_impl(base_rng, params_r, params_i, vars, emit_transformed_parameters, emit_generated_quantities, pstream);
    }
    template <bool propto__, bool jacobian__, typename T_>
    inline T_ log_prob(Eigen::Matrix<T_,Eigen::Dynamic,1>& params_r,
                       std::ostream* pstream = nullptr) const {
      Eigen::Matrix<int, -1, 1> params_i;
      return log_prob_impl<propto__, jacobian__>(params_r, params_i, pstream);
    }
    template <bool propto__, bool jacobian__, typename T__>
    inline T__ log_prob(std::vector<T__>& params_r,
                        std::vector<int>& params_i,
                        std::ostream* pstream = nullptr) const {
      return log_prob_impl<propto__, jacobian__>(params_r, params_i, pstream);
    }
  
    inline void transform_inits(const stan::io::var_context& context,
                         Eigen::Matrix<double, Eigen::Dynamic, 1>& params_r,
                         std::ostream* pstream = nullptr) const final {
      std::vector<double> params_r_vec(params_r.size());
      std::vector<int> params_i;
      transform_inits_impl(context, params_i, params_r_vec, pstream);
      params_r.resize(params_r_vec.size());
      for (int i = 0; i < params_r.size(); ++i) {
        params_r.coeffRef(i) = params_r_vec[i];
      }
    }
    inline void transform_inits(const stan::io::var_context& context,
                                std::vector<int>& params_i,
                                std::vector<double>& vars,
                                std::ostream* pstream = nullptr) const final {
      transform_inits_impl(context, params_i, vars, pstream);
    }        
};
}
using stan_model = model_hmm_gaussian_namespace::model_hmm_gaussian;
#ifndef USING_R
// Boilerplate
stan::model::model_base& new_model(
        stan::io::var_context& data_context,
        unsigned int seed,
        std::ostream* msg_stream) {
  stan_model* m = new stan_model(data_context, seed, msg_stream);
  return *m;
}
stan::math::profile_map& get_stan_profile_data() {
  return model_hmm_gaussian_namespace::profiles__;
}
#endif
#endif
