% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lin_comb.R
\name{lin_comb}
\alias{lin_comb}
\title{Perform a linear combination of posterior samples}
\usage{
lin_comb(lin_comb, obj, cri_level = 0.9, rope = NULL)
}
\arguments{
\item{lin_comb}{A string specifying a linear combination of variables}

\item{obj}{An object of class \code{BGGM}, \code{bbcor}, or a \code{data.frame} of posterior samples}

\item{cri_level}{The level for which a credible interval should be computed}

\item{rope}{Specify a ROPE. Optional.}
}
\value{
An object of class \code{lin_comb}
}
\description{
Perform a linear combination of posterior samples
}
\examples{
# data
Y <- BGGM::ptsd

# names
colnames(Y) <- letters[1:20]

# estimate model
est <- BGGM::estimate(Y)

# test
bggm_comb <- lin_comb("a--c + a--d > b--c + b--d",
                       obj = est,
                       cri_level = 0.90,
                       rope = c(-0.1, 0.1))

# print
bggm_comb
}
