// Generated by rstantools.  Do not edit by hand.

/*
    bayeslist is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    bayeslist is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with bayeslist.  If not, see <http://www.gnu.org/licenses/>.
*/
#ifndef MODELS_HPP
#define MODELS_HPP
#define STAN__SERVICES__COMMAND_HPP
#ifndef USE_STANC3
#define USE_STANC3
#endif
#include <rstan/rstaninc.hpp>
// Code generated by stanc v2.26.1-4-gd72b68b7-dirty
#include <stan/model/model_header.hpp>
namespace model_model_predict_noaux_linear_namespace {
inline void validate_positive_index(const char* var_name, const char* expr,
                                    int val) {
  if (val < 1) {
    std::stringstream msg;
    msg << "Found dimension size less than one in simplex declaration"
        << "; variable=" << var_name << "; dimension size expression=" << expr
        << "; expression value=" << val;
    std::string msg_str(msg.str());
    throw std::invalid_argument(msg_str.c_str());
  }
}
inline void validate_unit_vector_index(const char* var_name, const char* expr,
                                       int val) {
  if (val <= 1) {
    std::stringstream msg;
    if (val == 1) {
      msg << "Found dimension size one in unit vector declaration."
          << " One-dimensional unit vector is discrete"
          << " but the target distribution must be continuous."
          << " variable=" << var_name << "; dimension size expression=" << expr;
    } else {
      msg << "Found dimension size less than one in unit vector declaration"
          << "; variable=" << var_name << "; dimension size expression=" << expr
          << "; expression value=" << val;
    }
    std::string msg_str(msg.str());
    throw std::invalid_argument(msg_str.c_str());
  }
}
using std::istream;
using std::string;
using std::stringstream;
using std::vector;
using std::pow;
using stan::io::dump;
using stan::math::lgamma;
using stan::model::model_base_crtp;
using stan::model::rvalue;
using stan::model::cons_list;
using stan::model::index_uni;
using stan::model::index_max;
using stan::model::index_min;
using stan::model::index_min_max;
using stan::model::index_multi;
using stan::model::index_omni;
using stan::model::nil_index_list;
using namespace stan::math;
using stan::math::pow; 
stan::math::profile_map profiles__;
static int current_statement__= 0;
static const std::vector<string> locations_array__ = {" (found before start of program)",
                                                      " (in 'model_predict_noaux_linear', line 29, column 1 to column 16)",
                                                      " (in 'model_predict_noaux_linear', line 31, column 1 to column 16)",
                                                      " (in 'model_predict_noaux_linear', line 32, column 1 to column 17)",
                                                      " (in 'model_predict_noaux_linear', line 33, column 1 to column 13)",
                                                      " (in 'model_predict_noaux_linear', line 34, column 1 to column 10)",
                                                      " (in 'model_predict_noaux_linear', line 35, column 1 to column 33)",
                                                      " (in 'model_predict_noaux_linear', line 37, column 1 to column 23)",
                                                      " (in 'model_predict_noaux_linear', line 40, column 1 to column 22)",
                                                      " (in 'model_predict_noaux_linear', line 41, column 1 to column 22)",
                                                      " (in 'model_predict_noaux_linear', line 42, column 1 to column 22)",
                                                      " (in 'model_predict_noaux_linear', line 43, column 1 to column 23)",
                                                      " (in 'model_predict_noaux_linear', line 44, column 1 to column 20)",
                                                      " (in 'model_predict_noaux_linear', line 45, column 1 to column 24)",
                                                      " (in 'model_predict_noaux_linear', line 54, column 3 to column 436)",
                                                      " (in 'model_predict_noaux_linear', line 53, column 9 to line 55, column 3)",
                                                      " (in 'model_predict_noaux_linear', line 52, column 3 to column 447)",
                                                      " (in 'model_predict_noaux_linear', line 51, column 27 to line 53, column 3)",
                                                      " (in 'model_predict_noaux_linear', line 51, column 9 to line 55, column 3)",
                                                      " (in 'model_predict_noaux_linear', line 50, column 3 to column 206)",
                                                      " (in 'model_predict_noaux_linear', line 49, column 44 to line 51, column 3)",
                                                      " (in 'model_predict_noaux_linear', line 49, column 9 to line 55, column 3)",
                                                      " (in 'model_predict_noaux_linear', line 48, column 3 to column 215)",
                                                      " (in 'model_predict_noaux_linear', line 47, column 34 to line 49, column 3)",
                                                      " (in 'model_predict_noaux_linear', line 47, column 2 to line 55, column 3)",
                                                      " (in 'model_predict_noaux_linear', line 46, column 15 to line 56, column 2)",
                                                      " (in 'model_predict_noaux_linear', line 46, column 1 to line 56, column 2)",
                                                      " (in 'model_predict_noaux_linear', line 18, column 1 to column 7)",
                                                      " (in 'model_predict_noaux_linear', line 19, column 1 to column 7)",
                                                      " (in 'model_predict_noaux_linear', line 20, column 18 to column 19)",
                                                      " (in 'model_predict_noaux_linear', line 20, column 1 to column 21)",
                                                      " (in 'model_predict_noaux_linear', line 21, column 1 to column 7)",
                                                      " (in 'model_predict_noaux_linear', line 22, column 8 to column 9)",
                                                      " (in 'model_predict_noaux_linear', line 22, column 10 to column 11)",
                                                      " (in 'model_predict_noaux_linear', line 22, column 1 to column 15)",
                                                      " (in 'model_predict_noaux_linear', line 23, column 11 to column 12)",
                                                      " (in 'model_predict_noaux_linear', line 23, column 1 to column 14)",
                                                      " (in 'model_predict_noaux_linear', line 24, column 14 to column 15)",
                                                      " (in 'model_predict_noaux_linear', line 24, column 1 to column 17)",
                                                      " (in 'model_predict_noaux_linear', line 29, column 8 to column 9)",
                                                      " (in 'model_predict_noaux_linear', line 31, column 8 to column 9)",
                                                      " (in 'model_predict_noaux_linear', line 32, column 8 to column 9)",
                                                      " (in 'model_predict_noaux_linear', line 4, column 2 to column 31)",
                                                      " (in 'model_predict_noaux_linear', line 3, column 16 to line 5, column 2)",
                                                      " (in 'model_predict_noaux_linear', line 7, column 2 to column 45)",
                                                      " (in 'model_predict_noaux_linear', line 6, column 46 to line 8, column 2)",
                                                      " (in 'model_predict_noaux_linear', line 10, column 2 to column 45)",
                                                      " (in 'model_predict_noaux_linear', line 9, column 46 to line 11, column 2)",
                                                      " (in 'model_predict_noaux_linear', line 14, column 2 to column 35)",
                                                      " (in 'model_predict_noaux_linear', line 13, column 37 to line 15, column 2)"};
template <typename T0__>
stan::promote_args_t<T0__>
gd(const T0__& p, std::ostream* pstream__) {
  using local_scalar_t__ = stan::promote_args_t<T0__>;
  const static bool propto__ = true;
  (void) propto__;
  local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
  (void) DUMMY_VAR__;  // suppress unused var warning
  
  try {
    current_statement__ = 42;
    return binomial_lpmf<false>(1, 1, p);
  } catch (const std::exception& e) {
    stan::lang::rethrow_located(e, locations_array__[current_statement__]);
      // Next line prevents compiler griping about no return
      throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***"); 
  }
  
}
struct gd_functor__ {
template <typename T0__>
stan::promote_args_t<T0__>
operator()(const T0__& p, std::ostream* pstream__)  const 
{
return gd(p, pstream__);
}
};
template <typename T2__, typename T3__>
stan::promote_args_t<T2__,
T3__>
h0d(const int& y, const int& J, const T2__& alpha, const T3__& beta,
    std::ostream* pstream__) {
  using local_scalar_t__ = stan::promote_args_t<T2__, T3__>;
  const static bool propto__ = true;
  (void) propto__;
  local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
  (void) DUMMY_VAR__;  // suppress unused var warning
  
  try {
    current_statement__ = 44;
    return beta_binomial_lpmf<false>(y, J, alpha, beta);
  } catch (const std::exception& e) {
    stan::lang::rethrow_located(e, locations_array__[current_statement__]);
      // Next line prevents compiler griping about no return
      throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***"); 
  }
  
}
struct h0d_functor__ {
template <typename T2__, typename T3__>
stan::promote_args_t<T2__,
T3__>
operator()(const int& y, const int& J, const T2__& alpha, const T3__& beta,
           std::ostream* pstream__)  const 
{
return h0d(y, J, alpha, beta, pstream__);
}
};
template <typename T2__, typename T3__>
stan::promote_args_t<T2__,
T3__>
h1d(const int& y, const int& J, const T2__& alpha, const T3__& beta,
    std::ostream* pstream__) {
  using local_scalar_t__ = stan::promote_args_t<T2__, T3__>;
  const static bool propto__ = true;
  (void) propto__;
  local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
  (void) DUMMY_VAR__;  // suppress unused var warning
  
  try {
    current_statement__ = 46;
    return beta_binomial_lpmf<false>(y, J, alpha, beta);
  } catch (const std::exception& e) {
    stan::lang::rethrow_located(e, locations_array__[current_statement__]);
      // Next line prevents compiler griping about no return
      throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***"); 
  }
  
}
struct h1d_functor__ {
template <typename T2__, typename T3__>
stan::promote_args_t<T2__,
T3__>
operator()(const int& y, const int& J, const T2__& alpha, const T3__& beta,
           std::ostream* pstream__)  const 
{
return h1d(y, J, alpha, beta, pstream__);
}
};
template <typename T0__, typename T1__, typename T2__>
stan::promote_args_t<T0__, T1__,
T2__>
fd(const T0__& y, const T1__& mu, const T2__& sigma, std::ostream* pstream__) {
  using local_scalar_t__ = stan::promote_args_t<T0__, T1__, T2__>;
  const static bool propto__ = true;
  (void) propto__;
  local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
  (void) DUMMY_VAR__;  // suppress unused var warning
  
  try {
    current_statement__ = 48;
    return normal_lpdf<false>(y, mu, sigma);
  } catch (const std::exception& e) {
    stan::lang::rethrow_located(e, locations_array__[current_statement__]);
      // Next line prevents compiler griping about no return
      throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***"); 
  }
  
}
struct fd_functor__ {
template <typename T0__, typename T1__, typename T2__>
stan::promote_args_t<T0__, T1__,
T2__>
operator()(const T0__& y, const T1__& mu, const T2__& sigma,
           std::ostream* pstream__)  const 
{
return fd(y, mu, sigma, pstream__);
}
};
#include <stan_meta_header.hpp>
class model_model_predict_noaux_linear final : public model_base_crtp<model_model_predict_noaux_linear> {
private:
  int N;
  int J;
  std::vector<int> Y;
  int K;
  Eigen::Matrix<double, -1, -1> X;
  std::vector<int> treat;
  std::vector<double> outcome;
 
public:
  ~model_model_predict_noaux_linear() { }
  
  inline std::string model_name() const final { return "model_model_predict_noaux_linear"; }
  inline std::vector<std::string> model_compile_info() const noexcept {
    return std::vector<std::string>{"stanc_version = stanc3 v2.26.1-4-gd72b68b7-dirty", "stancflags = "};
  }
  
  
  model_model_predict_noaux_linear(stan::io::var_context& context__,
                                   unsigned int random_seed__ = 0,
                                   std::ostream* pstream__ = nullptr) : model_base_crtp(0) {
    using local_scalar_t__ = double ;
    boost::ecuyer1988 base_rng__ = 
        stan::services::util::create_rng(random_seed__, 0);
    (void) base_rng__;  // suppress unused var warning
    static const char* function__ = "model_model_predict_noaux_linear_namespace::model_model_predict_noaux_linear";
    (void) function__;  // suppress unused var warning
    local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
    (void) DUMMY_VAR__;  // suppress unused var warning
    
    try {
      int pos__;
      pos__ = std::numeric_limits<int>::min();
      
      pos__ = 1;
      current_statement__ = 27;
      context__.validate_dims("data initialization","N","int",
          context__.to_vec());
      N = std::numeric_limits<int>::min();
      
      current_statement__ = 27;
      N = context__.vals_i("N")[(1 - 1)];
      current_statement__ = 28;
      context__.validate_dims("data initialization","J","int",
          context__.to_vec());
      J = std::numeric_limits<int>::min();
      
      current_statement__ = 28;
      J = context__.vals_i("J")[(1 - 1)];
      current_statement__ = 29;
      validate_non_negative_index("Y", "N", N);
      current_statement__ = 30;
      context__.validate_dims("data initialization","Y","int",
          context__.to_vec(N));
      Y = std::vector<int>(N, std::numeric_limits<int>::min());
      
      current_statement__ = 30;
      assign(Y, nil_index_list(), context__.vals_i("Y"),
        "assigning variable Y");
      current_statement__ = 30;
      for (int sym1__ = 1; sym1__ <= N; ++sym1__) {
        current_statement__ = 30;
        current_statement__ = 30;
        check_greater_or_equal(function__, "Y[sym1__]", Y[(sym1__ - 1)], 0);}
      current_statement__ = 31;
      context__.validate_dims("data initialization","K","int",
          context__.to_vec());
      K = std::numeric_limits<int>::min();
      
      current_statement__ = 31;
      K = context__.vals_i("K")[(1 - 1)];
      current_statement__ = 32;
      validate_non_negative_index("X", "N", N);
      current_statement__ = 33;
      validate_non_negative_index("X", "K", K);
      current_statement__ = 34;
      context__.validate_dims("data initialization","X","double",
          context__.to_vec(N, K));
      X = Eigen::Matrix<double, -1, -1>(N, K);
      stan::math::fill(X, std::numeric_limits<double>::quiet_NaN());
      
      {
        std::vector<local_scalar_t__> X_flat__;
        current_statement__ = 34;
        assign(X_flat__, nil_index_list(), context__.vals_r("X"),
          "assigning variable X_flat__");
        current_statement__ = 34;
        pos__ = 1;
        current_statement__ = 34;
        for (int sym1__ = 1; sym1__ <= K; ++sym1__) {
          current_statement__ = 34;
          for (int sym2__ = 1; sym2__ <= N; ++sym2__) {
            current_statement__ = 34;
            assign(X,
              cons_list(index_uni(sym2__),
                cons_list(index_uni(sym1__), nil_index_list())),
              X_flat__[(pos__ - 1)], "assigning variable X");
            current_statement__ = 34;
            pos__ = (pos__ + 1);}}
      }
      current_statement__ = 35;
      validate_non_negative_index("treat", "N", N);
      current_statement__ = 36;
      context__.validate_dims("data initialization","treat","int",
          context__.to_vec(N));
      treat = std::vector<int>(N, std::numeric_limits<int>::min());
      
      current_statement__ = 36;
      assign(treat, nil_index_list(), context__.vals_i("treat"),
        "assigning variable treat");
      current_statement__ = 37;
      validate_non_negative_index("outcome", "N", N);
      current_statement__ = 38;
      context__.validate_dims("data initialization","outcome","double",
          context__.to_vec(N));
      outcome = std::vector<double>(N, std::numeric_limits<double>::quiet_NaN());
      
      current_statement__ = 38;
      assign(outcome, nil_index_list(), context__.vals_r("outcome"),
        "assigning variable outcome");
      current_statement__ = 39;
      validate_non_negative_index("psi0", "K", K);
      current_statement__ = 40;
      validate_non_negative_index("psi2", "K", K);
      current_statement__ = 41;
      validate_non_negative_index("delta", "K", K);
    } catch (const std::exception& e) {
      stan::lang::rethrow_located(e, locations_array__[current_statement__]);
      // Next line prevents compiler griping about no return
      throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***"); 
    }
    num_params_r__ = 0U;
    
    try {
      num_params_r__ += K;
      num_params_r__ += K;
      num_params_r__ += K;
      num_params_r__ += 1;
      num_params_r__ += 1;
      num_params_r__ += 1;
      num_params_r__ += 1;
    } catch (const std::exception& e) {
      stan::lang::rethrow_located(e, locations_array__[current_statement__]);
      // Next line prevents compiler griping about no return
      throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***"); 
    }
  }
  template <bool propto__, bool jacobian__, typename VecR, typename VecI, stan::require_vector_like_t<VecR>* = nullptr, stan::require_vector_like_vt<std::is_integral, VecI>* = nullptr>
  inline stan::scalar_type_t<VecR> log_prob_impl(VecR& params_r__,
                                                 VecI& params_i__,
                                                 std::ostream* pstream__ = nullptr) const {
    using T__ = stan::scalar_type_t<VecR>;
    using local_scalar_t__ = T__;
    T__ lp__(0.0);
    stan::math::accumulator<T__> lp_accum__;
    static const char* function__ = "model_model_predict_noaux_linear_namespace::log_prob";
(void) function__;  // suppress unused var warning
    stan::io::reader<local_scalar_t__> in__(params_r__, params_i__);
    local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
    (void) DUMMY_VAR__;  // suppress unused var warning
    
    try {
      Eigen::Matrix<local_scalar_t__, -1, 1> psi0;
      psi0 = Eigen::Matrix<local_scalar_t__, -1, 1>(K);
      stan::math::fill(psi0, DUMMY_VAR__);
      
      current_statement__ = 1;
      psi0 = in__.vector(K);
      Eigen::Matrix<local_scalar_t__, -1, 1> psi2;
      psi2 = Eigen::Matrix<local_scalar_t__, -1, 1>(K);
      stan::math::fill(psi2, DUMMY_VAR__);
      
      current_statement__ = 2;
      psi2 = in__.vector(K);
      Eigen::Matrix<local_scalar_t__, -1, 1> delta;
      delta = Eigen::Matrix<local_scalar_t__, -1, 1>(K);
      stan::math::fill(delta, DUMMY_VAR__);
      
      current_statement__ = 3;
      delta = in__.vector(K);
      local_scalar_t__ gamma0;
      gamma0 = DUMMY_VAR__;
      
      current_statement__ = 4;
      gamma0 = in__.scalar();
      local_scalar_t__ phi;
      phi = DUMMY_VAR__;
      
      current_statement__ = 5;
      phi = in__.scalar();
      local_scalar_t__ rho0;
      rho0 = DUMMY_VAR__;
      
      current_statement__ = 6;
      rho0 = in__.scalar();
      current_statement__ = 6;
      if (jacobian__) {
        current_statement__ = 6;
        rho0 = stan::math::lub_constrain(rho0, 0, 1, lp__);
      } else {
        current_statement__ = 6;
        rho0 = stan::math::lub_constrain(rho0, 0, 1);
      }
      local_scalar_t__ sigma;
      sigma = DUMMY_VAR__;
      
      current_statement__ = 7;
      sigma = in__.scalar();
      current_statement__ = 7;
      if (jacobian__) {
        current_statement__ = 7;
        sigma = stan::math::lb_constrain(sigma, 0, lp__);
      } else {
        current_statement__ = 7;
        sigma = stan::math::lb_constrain(sigma, 0);
      }
      {
        current_statement__ = 8;
        lp_accum__.add(normal_lpdf<propto__>(delta, 0, 10));
        current_statement__ = 9;
        lp_accum__.add(normal_lpdf<propto__>(psi0, 0, 10));
        current_statement__ = 10;
        lp_accum__.add(normal_lpdf<propto__>(psi2, 0, 10));
        current_statement__ = 11;
        lp_accum__.add(normal_lpdf<propto__>(gamma0, 0, 10));
        current_statement__ = 12;
        lp_accum__.add(normal_lpdf<propto__>(phi, 0, 10));
        current_statement__ = 13;
        lp_accum__.add(cauchy_lpdf<propto__>(sigma, 0, 2.5));
        current_statement__ = 26;
        for (int i = 1; i <= N; ++i) {
          current_statement__ = 24;
          if ((primitive_value(logical_eq(treat[(i - 1)], 1)) &&
              primitive_value(logical_eq(Y[(i - 1)], 0)))) {
            current_statement__ = 22;
            lp_accum__.add(
              ((fd(outcome[(i - 1)],
                  ((multiply(
                      rvalue(X,
                        cons_list(index_uni(i),
                          cons_list(index_omni(), nil_index_list())), "X"),
                      psi2) + (Y[(i - 1)] * phi)) + (0 * gamma0)),
                  sigma, pstream__) +
                 stan::math::log(
                   (1 -
                     stan::math::exp(
                       gd(
                         inv_logit(
                           multiply(
                             rvalue(X,
                               cons_list(index_uni(i),
                                 cons_list(index_omni(), nil_index_list())),
                               "X"), delta)), pstream__))))) +
                h0d(0, J,
                  ((inv_logit(
                      multiply(
                        rvalue(X,
                          cons_list(index_uni(i),
                            cons_list(index_omni(), nil_index_list())), "X"),
                        psi0)) * (1 - rho0)) / rho0),
                  (((1 -
                      inv_logit(
                        multiply(
                          rvalue(X,
                            cons_list(index_uni(i),
                              cons_list(index_omni(), nil_index_list())),
                            "X"), psi0))) * (1 - rho0)) / rho0), pstream__)));
          } else {
            current_statement__ = 21;
            if ((primitive_value(logical_eq(treat[(i - 1)], 1)) &&
                primitive_value(logical_eq(Y[(i - 1)], (J + 1))))) {
              current_statement__ = 19;
              lp_accum__.add(
                ((fd(outcome[(i - 1)],
                    ((multiply(
                        rvalue(X,
                          cons_list(index_uni(i),
                            cons_list(index_omni(), nil_index_list())), "X"),
                        psi2) + ((Y[(i - 1)] - 1) * phi)) + (1 * gamma0)),
                    sigma, pstream__) +
                   gd(
                     inv_logit(
                       multiply(
                         rvalue(X,
                           cons_list(index_uni(i),
                             cons_list(index_omni(), nil_index_list())), "X"),
                         delta)), pstream__)) +
                  h1d(J, J,
                    ((inv_logit(
                        multiply(
                          rvalue(X,
                            cons_list(index_uni(i),
                              cons_list(index_omni(), nil_index_list())),
                            "X"), psi0)) * (1 - rho0)) / rho0),
                    (((1 -
                        inv_logit(
                          multiply(
                            rvalue(X,
                              cons_list(index_uni(i),
                                cons_list(index_omni(), nil_index_list())),
                              "X"), psi0))) * (1 - rho0)) / rho0), pstream__)));
            } else {
              current_statement__ = 18;
              if (logical_eq(treat[(i - 1)], 1)) {
                current_statement__ = 16;
                lp_accum__.add(
                  stan::math::log(
                    (((stan::math::exp(
                         fd(outcome[(i - 1)],
                           ((multiply(
                               rvalue(X,
                                 cons_list(index_uni(i),
                                   cons_list(index_omni(), nil_index_list())),
                                 "X"), psi2) + ((Y[(i - 1)] - 1) * phi)) +
                             (1 * gamma0)), sigma, pstream__)) *
                        stan::math::exp(
                          gd(
                            inv_logit(
                              multiply(
                                rvalue(X,
                                  cons_list(index_uni(i),
                                    cons_list(index_omni(), nil_index_list())),
                                  "X"), delta)), pstream__))) *
                       stan::math::exp(
                         h1d((Y[(i - 1)] - 1), J,
                           ((inv_logit(
                               multiply(
                                 rvalue(X,
                                   cons_list(index_uni(i),
                                     cons_list(index_omni(),
                                       nil_index_list())), "X"), psi0)) *
                              (1 - rho0)) / rho0),
                           (((1 -
                               inv_logit(
                                 multiply(
                                   rvalue(X,
                                     cons_list(index_uni(i),
                                       cons_list(index_omni(),
                                         nil_index_list())), "X"), psi0))) *
                              (1 - rho0)) / rho0), pstream__))) +
                      ((stan::math::exp(
                          fd(outcome[(i - 1)],
                            ((multiply(
                                rvalue(X,
                                  cons_list(index_uni(i),
                                    cons_list(index_omni(), nil_index_list())),
                                  "X"), psi2) + (Y[(i - 1)] * phi)) +
                              (0 * gamma0)), sigma, pstream__)) *
                         (1 -
                           stan::math::exp(
                             gd(
                               inv_logit(
                                 multiply(
                                   rvalue(X,
                                     cons_list(index_uni(i),
                                       cons_list(index_omni(),
                                         nil_index_list())), "X"), delta)), pstream__))))
                        *
                        stan::math::exp(
                          h0d(Y[(i - 1)], J,
                            ((inv_logit(
                                multiply(
                                  rvalue(X,
                                    cons_list(index_uni(i),
                                      cons_list(index_omni(),
                                        nil_index_list())), "X"), psi0)) *
                               (1 - rho0)) / rho0),
                            (((1 -
                                inv_logit(
                                  multiply(
                                    rvalue(X,
                                      cons_list(index_uni(i),
                                        cons_list(index_omni(),
                                          nil_index_list())), "X"), psi0))) *
                               (1 - rho0)) / rho0), pstream__))))));
              } else {
                current_statement__ = 14;
                lp_accum__.add(
                  stan::math::log(
                    (((stan::math::exp(
                         fd(outcome[(i - 1)],
                           ((multiply(
                               rvalue(X,
                                 cons_list(index_uni(i),
                                   cons_list(index_omni(), nil_index_list())),
                                 "X"), psi2) + (Y[(i - 1)] * phi)) +
                             (1 * gamma0)), sigma, pstream__)) *
                        stan::math::exp(
                          gd(
                            inv_logit(
                              multiply(
                                rvalue(X,
                                  cons_list(index_uni(i),
                                    cons_list(index_omni(), nil_index_list())),
                                  "X"), delta)), pstream__))) *
                       stan::math::exp(
                         h1d(Y[(i - 1)], J,
                           ((inv_logit(
                               multiply(
                                 rvalue(X,
                                   cons_list(index_uni(i),
                                     cons_list(index_omni(),
                                       nil_index_list())), "X"), psi0)) *
                              (1 - rho0)) / rho0),
                           (((1 -
                               inv_logit(
                                 multiply(
                                   rvalue(X,
                                     cons_list(index_uni(i),
                                       cons_list(index_omni(),
                                         nil_index_list())), "X"), psi0))) *
                              (1 - rho0)) / rho0), pstream__))) +
                      ((stan::math::exp(
                          fd(outcome[(i - 1)],
                            ((multiply(
                                rvalue(X,
                                  cons_list(index_uni(i),
                                    cons_list(index_omni(), nil_index_list())),
                                  "X"), psi2) + (Y[(i - 1)] * phi)) +
                              (0 * gamma0)), sigma, pstream__)) *
                         (1 -
                           stan::math::exp(
                             gd(
                               inv_logit(
                                 multiply(
                                   rvalue(X,
                                     cons_list(index_uni(i),
                                       cons_list(index_omni(),
                                         nil_index_list())), "X"), delta)), pstream__))))
                        *
                        stan::math::exp(
                          h0d(Y[(i - 1)], J,
                            ((inv_logit(
                                multiply(
                                  rvalue(X,
                                    cons_list(index_uni(i),
                                      cons_list(index_omni(),
                                        nil_index_list())), "X"), psi0)) *
                               (1 - rho0)) / rho0),
                            (((1 -
                                inv_logit(
                                  multiply(
                                    rvalue(X,
                                      cons_list(index_uni(i),
                                        cons_list(index_omni(),
                                          nil_index_list())), "X"), psi0))) *
                               (1 - rho0)) / rho0), pstream__))))));
              }
            }
          }}
      }
    } catch (const std::exception& e) {
      stan::lang::rethrow_located(e, locations_array__[current_statement__]);
      // Next line prevents compiler griping about no return
      throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***"); 
    }
    lp_accum__.add(lp__);
    return lp_accum__.sum();
    } // log_prob_impl() 
    
  template <typename RNG, typename VecR, typename VecI, typename VecVar, stan::require_vector_like_vt<std::is_floating_point, VecR>* = nullptr, stan::require_vector_like_vt<std::is_integral, VecI>* = nullptr, stan::require_std_vector_vt<std::is_floating_point, VecVar>* = nullptr>
  inline void write_array_impl(RNG& base_rng__, VecR& params_r__,
                               VecI& params_i__, VecVar& vars__,
                               const bool emit_transformed_parameters__ = true,
                               const bool emit_generated_quantities__ = true,
                               std::ostream* pstream__ = nullptr) const {
    using local_scalar_t__ = double;
    vars__.resize(0);
    stan::io::reader<local_scalar_t__> in__(params_r__, params_i__);
    static const char* function__ = "model_model_predict_noaux_linear_namespace::write_array";
(void) function__;  // suppress unused var warning
    (void) function__;  // suppress unused var warning
    double lp__ = 0.0;
    (void) lp__;  // dummy to suppress unused var warning
    stan::math::accumulator<double> lp_accum__;
    local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
    (void) DUMMY_VAR__;  // suppress unused var warning
    
    try {
      Eigen::Matrix<double, -1, 1> psi0;
      psi0 = Eigen::Matrix<double, -1, 1>(K);
      stan::math::fill(psi0, std::numeric_limits<double>::quiet_NaN());
      
      current_statement__ = 1;
      psi0 = in__.vector(K);
      Eigen::Matrix<double, -1, 1> psi2;
      psi2 = Eigen::Matrix<double, -1, 1>(K);
      stan::math::fill(psi2, std::numeric_limits<double>::quiet_NaN());
      
      current_statement__ = 2;
      psi2 = in__.vector(K);
      Eigen::Matrix<double, -1, 1> delta;
      delta = Eigen::Matrix<double, -1, 1>(K);
      stan::math::fill(delta, std::numeric_limits<double>::quiet_NaN());
      
      current_statement__ = 3;
      delta = in__.vector(K);
      double gamma0;
      gamma0 = std::numeric_limits<double>::quiet_NaN();
      
      current_statement__ = 4;
      gamma0 = in__.scalar();
      double phi;
      phi = std::numeric_limits<double>::quiet_NaN();
      
      current_statement__ = 5;
      phi = in__.scalar();
      double rho0;
      rho0 = std::numeric_limits<double>::quiet_NaN();
      
      current_statement__ = 6;
      rho0 = in__.scalar();
      current_statement__ = 6;
      rho0 = stan::math::lub_constrain(rho0, 0, 1);
      double sigma;
      sigma = std::numeric_limits<double>::quiet_NaN();
      
      current_statement__ = 7;
      sigma = in__.scalar();
      current_statement__ = 7;
      sigma = stan::math::lb_constrain(sigma, 0);
      for (int sym1__ = 1; sym1__ <= K; ++sym1__) {
        vars__.emplace_back(psi0[(sym1__ - 1)]);}
      for (int sym1__ = 1; sym1__ <= K; ++sym1__) {
        vars__.emplace_back(psi2[(sym1__ - 1)]);}
      for (int sym1__ = 1; sym1__ <= K; ++sym1__) {
        vars__.emplace_back(delta[(sym1__ - 1)]);}
      vars__.emplace_back(gamma0);
      vars__.emplace_back(phi);
      vars__.emplace_back(rho0);
      vars__.emplace_back(sigma);
      if (logical_negation((primitive_value(emit_transformed_parameters__) ||
            primitive_value(emit_generated_quantities__)))) {
        return ;
      } 
      if (logical_negation(emit_generated_quantities__)) {
        return ;
      } 
    } catch (const std::exception& e) {
      stan::lang::rethrow_located(e, locations_array__[current_statement__]);
      // Next line prevents compiler griping about no return
      throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***"); 
    }
    } // write_array_impl() 
    
  template <typename VecVar, typename VecI, stan::require_std_vector_t<VecVar>* = nullptr, stan::require_vector_like_vt<std::is_integral, VecI>* = nullptr>
  inline void transform_inits_impl(const stan::io::var_context& context__,
                                   VecI& params_i__, VecVar& vars__,
                                   std::ostream* pstream__ = nullptr) const {
    using local_scalar_t__ = double;
    vars__.clear();
    vars__.reserve(num_params_r__);
    
    try {
      int pos__;
      pos__ = std::numeric_limits<int>::min();
      
      pos__ = 1;
      Eigen::Matrix<double, -1, 1> psi0;
      psi0 = Eigen::Matrix<double, -1, 1>(K);
      stan::math::fill(psi0, std::numeric_limits<double>::quiet_NaN());
      
      {
        std::vector<local_scalar_t__> psi0_flat__;
        current_statement__ = 1;
        assign(psi0_flat__, nil_index_list(), context__.vals_r("psi0"),
          "assigning variable psi0_flat__");
        current_statement__ = 1;
        pos__ = 1;
        current_statement__ = 1;
        for (int sym1__ = 1; sym1__ <= K; ++sym1__) {
          current_statement__ = 1;
          assign(psi0, cons_list(index_uni(sym1__), nil_index_list()),
            psi0_flat__[(pos__ - 1)], "assigning variable psi0");
          current_statement__ = 1;
          pos__ = (pos__ + 1);}
      }
      Eigen::Matrix<double, -1, 1> psi2;
      psi2 = Eigen::Matrix<double, -1, 1>(K);
      stan::math::fill(psi2, std::numeric_limits<double>::quiet_NaN());
      
      {
        std::vector<local_scalar_t__> psi2_flat__;
        current_statement__ = 2;
        assign(psi2_flat__, nil_index_list(), context__.vals_r("psi2"),
          "assigning variable psi2_flat__");
        current_statement__ = 2;
        pos__ = 1;
        current_statement__ = 2;
        for (int sym1__ = 1; sym1__ <= K; ++sym1__) {
          current_statement__ = 2;
          assign(psi2, cons_list(index_uni(sym1__), nil_index_list()),
            psi2_flat__[(pos__ - 1)], "assigning variable psi2");
          current_statement__ = 2;
          pos__ = (pos__ + 1);}
      }
      Eigen::Matrix<double, -1, 1> delta;
      delta = Eigen::Matrix<double, -1, 1>(K);
      stan::math::fill(delta, std::numeric_limits<double>::quiet_NaN());
      
      {
        std::vector<local_scalar_t__> delta_flat__;
        current_statement__ = 3;
        assign(delta_flat__, nil_index_list(), context__.vals_r("delta"),
          "assigning variable delta_flat__");
        current_statement__ = 3;
        pos__ = 1;
        current_statement__ = 3;
        for (int sym1__ = 1; sym1__ <= K; ++sym1__) {
          current_statement__ = 3;
          assign(delta, cons_list(index_uni(sym1__), nil_index_list()),
            delta_flat__[(pos__ - 1)], "assigning variable delta");
          current_statement__ = 3;
          pos__ = (pos__ + 1);}
      }
      double gamma0;
      gamma0 = std::numeric_limits<double>::quiet_NaN();
      
      current_statement__ = 4;
      gamma0 = context__.vals_r("gamma0")[(1 - 1)];
      double phi;
      phi = std::numeric_limits<double>::quiet_NaN();
      
      current_statement__ = 5;
      phi = context__.vals_r("phi")[(1 - 1)];
      double rho0;
      rho0 = std::numeric_limits<double>::quiet_NaN();
      
      current_statement__ = 6;
      rho0 = context__.vals_r("rho0")[(1 - 1)];
      double rho0_free__;
      rho0_free__ = std::numeric_limits<double>::quiet_NaN();
      
      current_statement__ = 6;
      rho0_free__ = stan::math::lub_free(rho0, 0, 1);
      double sigma;
      sigma = std::numeric_limits<double>::quiet_NaN();
      
      current_statement__ = 7;
      sigma = context__.vals_r("sigma")[(1 - 1)];
      double sigma_free__;
      sigma_free__ = std::numeric_limits<double>::quiet_NaN();
      
      current_statement__ = 7;
      sigma_free__ = stan::math::lb_free(sigma, 0);
      for (int sym1__ = 1; sym1__ <= K; ++sym1__) {
        vars__.emplace_back(psi0[(sym1__ - 1)]);}
      for (int sym1__ = 1; sym1__ <= K; ++sym1__) {
        vars__.emplace_back(psi2[(sym1__ - 1)]);}
      for (int sym1__ = 1; sym1__ <= K; ++sym1__) {
        vars__.emplace_back(delta[(sym1__ - 1)]);}
      vars__.emplace_back(gamma0);
      vars__.emplace_back(phi);
      vars__.emplace_back(rho0_free__);
      vars__.emplace_back(sigma_free__);
    } catch (const std::exception& e) {
      stan::lang::rethrow_located(e, locations_array__[current_statement__]);
      // Next line prevents compiler griping about no return
      throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***"); 
    }
    } // transform_inits_impl() 
    
  inline void get_param_names(std::vector<std::string>& names__) const {
    
    names__.clear();
    names__.emplace_back("psi0");
    names__.emplace_back("psi2");
    names__.emplace_back("delta");
    names__.emplace_back("gamma0");
    names__.emplace_back("phi");
    names__.emplace_back("rho0");
    names__.emplace_back("sigma");
    } // get_param_names() 
    
  inline void get_dims(std::vector<std::vector<size_t>>& dimss__) const {
    dimss__.clear();
    dimss__.emplace_back(std::vector<size_t>{static_cast<size_t>(K)});
    
    dimss__.emplace_back(std::vector<size_t>{static_cast<size_t>(K)});
    
    dimss__.emplace_back(std::vector<size_t>{static_cast<size_t>(K)});
    
    dimss__.emplace_back(std::vector<size_t>{});
    
    dimss__.emplace_back(std::vector<size_t>{});
    
    dimss__.emplace_back(std::vector<size_t>{});
    
    dimss__.emplace_back(std::vector<size_t>{});
    
    } // get_dims() 
    
  inline void constrained_param_names(
                                      std::vector<std::string>& param_names__,
                                      bool emit_transformed_parameters__ = true,
                                      bool emit_generated_quantities__ = true) const
    final {
    
    for (int sym1__ = 1; sym1__ <= K; ++sym1__) {
      {
        param_names__.emplace_back(std::string() + "psi0" + '.' + std::to_string(sym1__));
      }}
    for (int sym1__ = 1; sym1__ <= K; ++sym1__) {
      {
        param_names__.emplace_back(std::string() + "psi2" + '.' + std::to_string(sym1__));
      }}
    for (int sym1__ = 1; sym1__ <= K; ++sym1__) {
      {
        param_names__.emplace_back(std::string() + "delta" + '.' + std::to_string(sym1__));
      }}
    param_names__.emplace_back(std::string() + "gamma0");
    param_names__.emplace_back(std::string() + "phi");
    param_names__.emplace_back(std::string() + "rho0");
    param_names__.emplace_back(std::string() + "sigma");
    if (emit_transformed_parameters__) {
      
    }
    
    if (emit_generated_quantities__) {
      
    }
    
    } // constrained_param_names() 
    
  inline void unconstrained_param_names(
                                        std::vector<std::string>& param_names__,
                                        bool emit_transformed_parameters__ = true,
                                        bool emit_generated_quantities__ = true) const
    final {
    
    for (int sym1__ = 1; sym1__ <= K; ++sym1__) {
      {
        param_names__.emplace_back(std::string() + "psi0" + '.' + std::to_string(sym1__));
      }}
    for (int sym1__ = 1; sym1__ <= K; ++sym1__) {
      {
        param_names__.emplace_back(std::string() + "psi2" + '.' + std::to_string(sym1__));
      }}
    for (int sym1__ = 1; sym1__ <= K; ++sym1__) {
      {
        param_names__.emplace_back(std::string() + "delta" + '.' + std::to_string(sym1__));
      }}
    param_names__.emplace_back(std::string() + "gamma0");
    param_names__.emplace_back(std::string() + "phi");
    param_names__.emplace_back(std::string() + "rho0");
    param_names__.emplace_back(std::string() + "sigma");
    if (emit_transformed_parameters__) {
      
    }
    
    if (emit_generated_quantities__) {
      
    }
    
    } // unconstrained_param_names() 
    
  inline std::string get_constrained_sizedtypes() const {
    stringstream s__;
    s__ << "[{\"name\":\"psi0\",\"type\":{\"name\":\"vector\",\"length\":" << K << "},\"block\":\"parameters\"},{\"name\":\"psi2\",\"type\":{\"name\":\"vector\",\"length\":" << K << "},\"block\":\"parameters\"},{\"name\":\"delta\",\"type\":{\"name\":\"vector\",\"length\":" << K << "},\"block\":\"parameters\"},{\"name\":\"gamma0\",\"type\":{\"name\":\"real\"},\"block\":\"parameters\"},{\"name\":\"phi\",\"type\":{\"name\":\"real\"},\"block\":\"parameters\"},{\"name\":\"rho0\",\"type\":{\"name\":\"real\"},\"block\":\"parameters\"},{\"name\":\"sigma\",\"type\":{\"name\":\"real\"},\"block\":\"parameters\"}]";
    return s__.str();
    } // get_constrained_sizedtypes() 
    
  inline std::string get_unconstrained_sizedtypes() const {
    stringstream s__;
    s__ << "[{\"name\":\"psi0\",\"type\":{\"name\":\"vector\",\"length\":" << K << "},\"block\":\"parameters\"},{\"name\":\"psi2\",\"type\":{\"name\":\"vector\",\"length\":" << K << "},\"block\":\"parameters\"},{\"name\":\"delta\",\"type\":{\"name\":\"vector\",\"length\":" << K << "},\"block\":\"parameters\"},{\"name\":\"gamma0\",\"type\":{\"name\":\"real\"},\"block\":\"parameters\"},{\"name\":\"phi\",\"type\":{\"name\":\"real\"},\"block\":\"parameters\"},{\"name\":\"rho0\",\"type\":{\"name\":\"real\"},\"block\":\"parameters\"},{\"name\":\"sigma\",\"type\":{\"name\":\"real\"},\"block\":\"parameters\"}]";
    return s__.str();
    } // get_unconstrained_sizedtypes() 
    
  
    // Begin method overload boilerplate
    template <typename RNG>
    inline void write_array(RNG& base_rng,
                            Eigen::Matrix<double,Eigen::Dynamic,1>& params_r,
                            Eigen::Matrix<double,Eigen::Dynamic,1>& vars,
                            const bool emit_transformed_parameters = true,
                            const bool emit_generated_quantities = true,
                            std::ostream* pstream = nullptr) const {
      std::vector<double> vars_vec(vars.size());
      std::vector<int> params_i;
      write_array_impl(base_rng, params_r, params_i, vars_vec,
          emit_transformed_parameters, emit_generated_quantities, pstream);
      vars.resize(vars_vec.size());
      for (int i = 0; i < vars.size(); ++i) {
        vars.coeffRef(i) = vars_vec[i];
      }
    }
    template <typename RNG>
    inline void write_array(RNG& base_rng, std::vector<double>& params_r,
                            std::vector<int>& params_i,
                            std::vector<double>& vars,
                            bool emit_transformed_parameters = true,
                            bool emit_generated_quantities = true,
                            std::ostream* pstream = nullptr) const {
      write_array_impl(base_rng, params_r, params_i, vars, emit_transformed_parameters, emit_generated_quantities, pstream);
    }
    template <bool propto__, bool jacobian__, typename T_>
    inline T_ log_prob(Eigen::Matrix<T_,Eigen::Dynamic,1>& params_r,
                       std::ostream* pstream = nullptr) const {
      Eigen::Matrix<int, -1, 1> params_i;
      return log_prob_impl<propto__, jacobian__>(params_r, params_i, pstream);
    }
    template <bool propto__, bool jacobian__, typename T__>
    inline T__ log_prob(std::vector<T__>& params_r,
                        std::vector<int>& params_i,
                        std::ostream* pstream = nullptr) const {
      return log_prob_impl<propto__, jacobian__>(params_r, params_i, pstream);
    }
  
    inline void transform_inits(const stan::io::var_context& context,
                         Eigen::Matrix<double, Eigen::Dynamic, 1>& params_r,
                         std::ostream* pstream = nullptr) const final {
      std::vector<double> params_r_vec(params_r.size());
      std::vector<int> params_i;
      transform_inits_impl(context, params_i, params_r_vec, pstream);
      params_r.resize(params_r_vec.size());
      for (int i = 0; i < params_r.size(); ++i) {
        params_r.coeffRef(i) = params_r_vec[i];
      }
    }
    inline void transform_inits(const stan::io::var_context& context,
                                std::vector<int>& params_i,
                                std::vector<double>& vars,
                                std::ostream* pstream = nullptr) const final {
      transform_inits_impl(context, params_i, vars, pstream);
    }        
};
}
using stan_model = model_model_predict_noaux_linear_namespace::model_model_predict_noaux_linear;
#ifndef USING_R
// Boilerplate
stan::model::model_base& new_model(
        stan::io::var_context& data_context,
        unsigned int seed,
        std::ostream* msg_stream) {
  stan_model* m = new stan_model(data_context, seed, msg_stream);
  return *m;
}
stan::math::profile_map& get_stan_profile_data() {
  return model_model_predict_noaux_linear_namespace::profiles__;
}
#endif
#endif
