% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/parsnip-exp_smoothing_reg.R
\name{exp_smoothing_stan_fit_impl}
\alias{exp_smoothing_stan_fit_impl}
\title{Low-Level ARIMA function for translating modeltime to forecast}
\usage{
exp_smoothing_stan_fit_impl(
  x,
  y,
  seasonality = 1,
  seasonality2 = 1,
  seasonality.type = "multiplicative",
  error.size.method = "std",
  level.method = "HW",
  ...
)
}
\arguments{
\item{x}{A dataframe of xreg (exogenous regressors)}

\item{y}{A numeric vector of values to fit}

\item{seasonality}{Seasonality}

\item{seasonality2}{Second seasonality}

\item{seasonality.type}{Either "multiplicative" (default) or "generalized".
The latter seasonality generalizes additive and multiplicative seasonality types.}

\item{error.size.method}{Either "std" (monotonically, but slower than proportionally,
growing with the series values) or "innov" (proportional to a smoothed abs size of innovations, i.e. surprises)}

\item{level.method}{"HW", "seasAvg", "HW_sAvg"}

\item{...}{Additional arguments passed to \code{forecast::Arima}}
}
\value{
A modeltime model
}
\description{
Low-Level ARIMA function for translating modeltime to forecast
}
