% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/createResiduals.R
\name{createResiduals}
\alias{createResiduals}
\title{Calculate GAM residuals}
\usage{
createResiduals(
  df,
  dep,
  residualModel = "doy_flw_sal",
  analySpec = analySpec,
  gamTable = FALSE,
  gamPlot = FALSE,
  flow.detrended = NA,
  salinity.detrended = NA,
  width = 10,
  height = 3.5,
  folder_r = "pltResiduals",
  ProjRoot
)
}
\arguments{
\item{df}{data frame}

\item{dep}{variable}

\item{residualModel}{which gam formula is used to compute . Default: 'doy_flw_sal'.}

\item{analySpec}{analytical specifications}

\item{gamTable}{gam table setting (set to FALSE to turn off table output)}

\item{gamPlot}{gam plot setting (set to FALSE to turn off plotting)}

\item{flow.detrended}{data generated by detrended.flow.  Default = NA.}

\item{salinity.detrended}{data generated by detrended.flow.  Default = NA.}

\item{width}{width of png figure (inches). Default = 10}

\item{height}{height of png figure (inches). Default = 3.5}

\item{folder_r}{folder to store residual plots}

\item{ProjRoot}{Root folder for project.}
}
\value{
Returns df with appended column of data
}
\description{
Use GAM analysis to compute residuals. Relies on mgcv::gam to perform general additive model.
}
