% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stopif.R
\name{stopif}
\alias{stopif}
\title{Ensure that R expressions are false}
\usage{
stopif(...)
}
\arguments{
\item{...}{Any number of (logical) R expressions, 
which should evaluate to \code{TRUE}.}
}
\value{
(\code{NULL} if all statements in \code{...} are \code{FALSE}.)
}
\description{
If any of the expressions in \code{...} are not all \code{FALSE}, 
stop is called, producing an error message indicating 
the first of the elements of \code{...} which were not false.
}
\examples{
\dontrun{
stopif(is.empty(c(2,1)), 4 < 3) # all FALSE
stopif(is.empty(numeric(0)))
}

}
\seealso{
\code{\link[base]{stopifnot}} from package \pkg{base}.
}
