% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bbl_s3.R
\name{bbl.fit}
\alias{bbl.fit}
\title{bbl Inference with model matrix}
\usage{
bbl.fit(x, y, qJ = NULL, freq = NULL, xlevels = NULL, verbose = 1,
  method = "pseudo", ...)
}
\arguments{
\item{x}{Data frame of factors with each predictor in columns.}

\item{y}{Vector of response variables.}

\item{qJ}{Matrix of logicals indicating which predictor combinations
are interacting.}

\item{freq}{Vector of non-negative integer frequencies, recoding
the number of times each row of data must be repeated.
If \code{NULL}, assumed to be all 1. Fractional weights are not
supported.}

\item{xlevels}{List of factor levels for predictors. If \code{NULL},
will be inferred from data with factor levels ordered alphanumerically.}

\item{verbose}{Verbosity level of output. Will be propagated to
\code{\link{mlestimate}} with one level down.}

\item{method}{\code{c('pseudo','mf')}; inference method.}

\item{...}{Other arguments to \code{\link{mlestimate}}.}
}
\value{
List of named components \code{h}, \code{J}, \code{lkh}, and
\code{lz}; see \code{\link{bbl}} for information regarding these
components.
}
\description{
Performs bbl inference using response vector and predictor matrix
}
\details{
This function would normally be called by \code{\link{bbl}} rather than
directly. Expects the predictor data \code{x} and response vector \code{y}
instead of formula input to \code{\link{bbl}}.
}
\examples{
titanic <- as.data.frame(Titanic)
freq <- titanic$Freq
x <- titanic[,1:3]
y <- titanic$Survived
b <- bbl.fit(x=x,y=y, freq=freq)
b
}
