% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/OptimizerGenSA.R
\name{mlr_optimizers_gensa}
\alias{mlr_optimizers_gensa}
\alias{OptimizerGenSA}
\title{Optimization via Generalized Simulated Annealing}
\source{
Tsallis C, Stariolo DA (1996).
\dQuote{Generalized simulated annealing.}
\emph{Physica A: Statistical Mechanics and its Applications}, \bold{233}(1-2), 395--406.
\doi{10.1016/s0378-4371(96)00271-3}.

Xiang Y, Gubian S, Suomela B, Hoeng J (2013).
\dQuote{Generalized Simulated Annealing for Global Optimization: The GenSA Package.}
\emph{The R Journal}, \bold{5}(1), 13.
\doi{10.32614/rj-2013-002}.
}
\description{
\code{OptimizerGenSA} class that implements generalized simulated annealing. Calls
\code{\link[GenSA:GenSA]{GenSA::GenSA()}} from package \CRANpkg{GenSA}.
}
\section{Dictionary}{

This \link{Optimizer} can be instantiated via the \link[mlr3misc:Dictionary]{dictionary}
\link{mlr_optimizers} or with the associated sugar function \code{\link[=opt]{opt()}}:\preformatted{mlr_optimizers$get("gensa")
opt("gensa")
}
}

\section{Parameters}{

\describe{
\item{\code{smooth}}{\code{logical(1)}}
\item{\code{temperature}}{\code{numeric(1)}}
\item{\code{acceptance.param}}{\code{numeric(1)}}
\item{\code{verbose}}{\code{logical(1)}}
\item{\code{trace.mat}}{\code{logical(1)}}
}

For the meaning of the control parameters, see \code{\link[GenSA:GenSA]{GenSA::GenSA()}}. Note that we
have removed all control parameters which refer to the termination of the
algorithm and where our terminators allow to obtain the same behavior.
}

\section{Progress Bars}{

\verb{$optimize()} supports progress bars via the package \CRANpkg{progressr}
combined with a \link{Terminator}. Simply wrap the function in
\code{progressr::with_progress()} to enable them. We recommend to use package
\CRANpkg{progress} as backend; enable with \code{progressr::handlers("progress")}.
}

\examples{
if (requireNamespace("GenSA")) {

  search_space = domain = ps(x = p_dbl(lower = -1, upper = 1))

  codomain = ps(y = p_dbl(tags = "minimize"))

  objective_function = function(xs) {
    list(y = as.numeric(xs)^2)
  }

  objective = ObjectiveRFun$new(
    fun = objective_function,
    domain = domain,
    codomain = codomain)

  instance = OptimInstanceSingleCrit$new(
    objective = objective,
    search_space = search_space,
    terminator = trm("evals", n_evals = 10))

  optimizer = opt("cmaes")

  # Modifies the instance by reference
  optimizer$optimize(instance)

  # Returns best scoring evaluation
  instance$result

  # Allows access of data.table of full path of all evaluations
  as.data.table(instance$archive$data)
}
}
\section{Super class}{
\code{\link[bbotk:Optimizer]{bbotk::Optimizer}} -> \code{OptimizerGenSA}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-new}{\code{OptimizerGenSA$new()}}
\item \href{#method-clone}{\code{OptimizerGenSA$clone()}}
}
}
\if{html}{
\out{<details open ><summary>Inherited methods</summary>}
\itemize{
\item \out{<span class="pkg-link" data-pkg="bbotk" data-topic="Optimizer" data-id="format">}\href{../../bbotk/html/Optimizer.html#method-format}{\code{bbotk::Optimizer$format()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="bbotk" data-topic="Optimizer" data-id="optimize">}\href{../../bbotk/html/Optimizer.html#method-optimize}{\code{bbotk::Optimizer$optimize()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="bbotk" data-topic="Optimizer" data-id="print">}\href{../../bbotk/html/Optimizer.html#method-print}{\code{bbotk::Optimizer$print()}}\out{</span>}
}
\out{</details>}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-new"></a>}}
\if{latex}{\out{\hypertarget{method-new}{}}}
\subsection{Method \code{new()}}{
Creates a new instance of this \link[R6:R6Class]{R6} class.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{OptimizerGenSA$new()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-clone"></a>}}
\if{latex}{\out{\hypertarget{method-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{OptimizerGenSA$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
