% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Gaussian_Inference.r
\name{dPosterior.GaussianInvWishart}
\alias{dPosterior.GaussianInvWishart}
\title{Density function of the posterior distribution of a "GaussianInvWishart" object}
\usage{
\method{dPosterior}{GaussianInvWishart}(obj, Sigma, LOG = TRUE, ...)
}
\arguments{
\item{obj}{A "GaussianInvWishart" object.}

\item{Sigma}{matrix.}

\item{LOG}{Return the log density if set to "TRUE".}

\item{...}{Additional arguments to be passed to other inherited types.}
}
\value{
numeric, the posterior density of Sigma.
}
\description{
Generate the the density value of the posterior distribution of the following structure:
    \deqn{x ~ Gaussian(mu,Sigma)}
    \deqn{Sigma ~ InvWishart(v,S)}
mu is known. Gaussian() is the Gaussian distribution. See \code{?dGaussian} and \code{?dInvWishart} for the definition of the distributions.\cr
The model structure and prior parameters are stored in a "GaussianInvWishart" object. \cr
Posterior density is the density function of InvWishart(Sigma|v,S).
}
\examples{
obj <- GaussianInvWishart(gamma=list(mu=c(-1.5,1.5),v=3,S=diag(2)))
Sigma <- rInvWishart(df = 3,scale = diag(2))
dPosterior(obj = obj,Sigma=Sigma)
}
\seealso{
\code{\link{GaussianInvWishart}}, \code{\link{rPosterior.GaussianInvWishart}}
}
