% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Categorical_Inference.r
\name{posteriorDiscard.CatDirichlet}
\alias{posteriorDiscard.CatDirichlet}
\title{Update a "CatDirichlet" object with sample sufficient statistics}
\usage{
\method{posteriorDiscard}{CatDirichlet}(obj, ss, w = NULL, ...)
}
\arguments{
\item{obj}{A "CatDirichlet" object.}

\item{ss}{Sufficient statistics of x. In Categorical-Dirichlet case the sufficient statistic of sample x can be either x itself, of an "ssCat" object generated by the function sufficientStatistics.CatDirichlet().}

\item{w}{Sample weights,default NULL.}

\item{...}{Additional arguments to be passed to other inherited types.}
}
\value{
None. the prior parameters stored in "obj" will be updated with the information in "ss".
}
\description{
Contrary to posterior(), this function will update alpha by removing the information of observed samples x for the model structure:
     \deqn{pi|alpha \sim Dir(alpha)}
     \deqn{x|pi \sim Categorical(pi)}
Where Dir() is the Dirichlet distribution, Categorical() is the Categorical distribution. See \code{?dDir} and \code{dCategorical} for the definitions of these distribution. \cr
The model structure and prior parameters are stored in a "CatDirichlet" object, the prior parameters in this object will be updated after running this function.
}
\examples{
obj <- CatDirichlet(gamma=list(alpha=rep(1,26),uniqueLabels = letters))
x <- sample(letters,size = 20,replace = TRUE)
w <- runif(20)
posterior(obj=obj,ss=x)
obj
posteriorDiscard(obj=obj,ss=x)
obj
## weighted sample
posterior(obj=obj,ss=x,w=w)
obj
posteriorDiscard(obj=obj,ss=x,w=w)
obj
}
\references{
Murphy, Kevin P. Machine learning: a probabilistic perspective. MIT press, 2012.
}
\seealso{
\code{\link{CatDirichlet}},\code{\link{posterior.CatDirichlet}}
}
