% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Gaussian_Inference.r
\name{rPosterior.GaussianNIG}
\alias{rPosterior.GaussianNIG}
\title{Generate ramdom samples from the posterior distribution of a "GaussianNIG" object}
\usage{
\method{rPosterior}{GaussianNIG}(obj, ...)
}
\arguments{
\item{obj}{A "GaussianNIG" object.}

\item{...}{Additional arguments to be passed to other inherited types.}
}
\value{
list(beta,sigma2), where beta is a numeric vector, sigma is a scalar value.
}
\description{
Generate random samples from the posterior distribution of the following structure:
Generate the the density value of the posterior distribution of the following structure:
   \deqn{x \sim Gaussian(X beta,sigma^2)}
   \deqn{sigma^2 \sim InvGamma(a,b)}
   \deqn{beta \sim Gaussian(m,sigma^2 V)}
Where X is a row vector, or a design matrix where each row is an obervation. InvGamma() is the Inverse-Gamma distribution, Gaussian() is the Gaussian distribution. See \code{?dInvGamma} and \code{dGaussian} for the definitions of these distribution.\cr
The model structure and prior parameters are stored in a "GaussianNIG" object. \cr
Posterior distribution is the distribution of beta,sigma^2|m,V,a,b.
}
\examples{
obj <- GaussianNIG(gamma=list(m=c(0,0),V=diag(2),a=1,b=1))
rPosterior(obj = obj)
}
\seealso{
\code{\link{GaussianNIG}}, \code{\link{dPosterior.GaussianNIG}}
}
