% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Gaussian_Inference.r
\name{sufficientStatistics_Weighted.GaussianNIG}
\alias{sufficientStatistics_Weighted.GaussianNIG}
\title{Weighted sufficient statistics of a "GaussianNIG" object}
\usage{
\method{sufficientStatistics_Weighted}{GaussianNIG}(obj, x, w, X, foreach = FALSE, ...)
}
\arguments{
\item{obj}{A "GaussianNIG" object.}

\item{x}{numeric, must satisfy length(x) = nrow(X).}

\item{w}{numeric, sample weights.}

\item{X}{matrix, must satisfy length(x) = nrow(X).}

\item{foreach}{logical, if foreach=TRUE, will return a list of sufficient statistics for each (x,X), otherwise will return the sufficient statistics as a whole.}

\item{...}{Additional arguments to be passed to other inherited types.}
}
\value{
If foreach=TRUE, will return a list of sufficient statistics for each row of (x,X), otherwise will return the sufficient statistics of (x,X) as a whole.
}
\description{
For following Gaussian-NIG model structure:
   \deqn{x \sim Gaussian(X beta,sigma^2)}
   \deqn{sigma^2 \sim InvGamma(a,b)}
   \deqn{beta \sim Gaussian(m,sigma^2 V)}
Where X is a row vector, or a design matrix where each row is an obervation. InvGamma() is the Inverse-Gamma distribution, Gaussian() is the Gaussian distribution. See \code{?dInvGamma} and \code{dGaussian} for the definitions of these distribution.\cr
The model structure and prior parameters are stored in a "GaussianNIG" object. \cr
This object will be used as a place for recording and accumulating information in the related inference/sampling functions such as posterior(), posteriorDiscard(), MAP(), marginalLikelihood(), dPosteriorPredictive(), rPosteriorPredictive() and so on. \cr
The sufficient statistics of a set of samples (x,X) and weights ware:
\itemize{
 \item the effective number of samples N=sum(w); \cr
 \item the covariance of X and x SXx=t(w*X)%*%x \cr
 \item the covariance of X SX=t(w*X)%*%X \cr
 \item the covariance of x Sx=t(w*x)%*%x
}
}
\examples{
obj <- GaussianNIG(gamma=list(m=0,V=1,a=1,b=0))
X <- 1:20
x <- rnorm(20)+ X*0.3
w <- runif(20)
sufficientStatistics_Weighted(obj = obj,X=X,x=x,w=w)
sufficientStatistics_Weighted(obj = obj,X=X,x=x,w=w,foreach = TRUE)
}
\references{
Banerjee, Sudipto. "Bayesian Linear Model: Gory Details." Downloaded from http://www. biostat. umn. edu/~ph7440 (2008).
}
\seealso{
\code{\link{GaussianNIG}}, \code{\link{sufficientStatistics.GaussianNIG}}
}
