% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{decorate}
\alias{decorate}
\title{Decorate a function for use in a web service}
\usage{
decorate(FUN, content_type = "text/html", strict = FALSE)
}
\arguments{
\item{FUN}{Function to decorate.}

\item{content_type}{HTTP "content-type" of the function output.
(\emph{e.g.} "text/plain", "text/html" or other mime type)}

\item{strict}{Boolean, requiring strict parameter matching.}
}
\value{
A \emph{decorated} middleware function.
}
\description{
The \code{decorate()} function can be used to prepare a function
for easy use in a beakr pipeline.

Decorating a function associates the specified function and its parameters
with \code{req}, \code{res}, and \code{err} objects and assigns a
content-type to the response object. This prepares a standard R function to
be used in \code{Beakr} instances and accept requests.
}
\examples{
\donttest{
# Create an new Beakr instance
beakr <- newBeakr()
# Create simple hello and goodbye function
hello <- function(name) { paste0("Hello, ", name, "!") }
goodbye <- function(text = "Adios") { paste0(text, ", dear friend.") }

# Create a web service from these functions
beakr \%>\%
  httpGET(path = "/hello", decorate(hello)) \%>\%
  httpGET(path = "/goodbye", decorate(goodbye)) \%>\%
  handleErrors() \%>\%
  listen(host = '127.0.0.1', port = 25118, daemon = TRUE)

# ------------------------------------------------------------
# POINT YOUR BROWSER AT:
# * http://127.0.0.1:25118/hello?name=Honeydew
# * http://127.0.0.1:25118/goodbye
# ------------------------------------------------------------

# Stop the beakr instance server
stopServer(beakr)
}
}
