% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/check_inference_model.R
\name{check_inference_model}
\alias{check_inference_model}
\title{Check if the supplied object is a valid
Bayesian phylogenetic inference model.}
\usage{
check_inference_model(inference_model)
}
\arguments{
\item{inference_model}{a Bayesian phylogenetic inference model.
An inference model is the complete model setup in which a site model,
clock model, tree prior and more are specified.
Use \link{create_inference_model} to create an inference model.
Use \link{check_inference_model} to check if  an inference model is valid.
Use \link{rename_inference_model_filenames} to rename the files in an
inference model.}
}
\value{
nothing
}
\description{
Calls \code{stop} if the supplied object is not a valid
  Bayesian phylogenetic inference model.
}
\examples{
 testthat::expect_silent(check_inference_model(create_inference_model()))

 # Must stop on non-MCMCs
 testthat::expect_error(check_inference_model(inference_model = "nonsense"))
 testthat::expect_error(check_inference_model(inference_model = NULL))
 testthat::expect_error(check_inference_model(inference_model = NA))
}
\seealso{
Use \link{create_inference_model} to create a valid Bayesian
  phylogenetic inference model
}
\author{
Richèl J.C. Bilderbeek
}
