% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/create_test_inference_model.R
\name{create_test_inference_model}
\alias{create_test_inference_model}
\title{Create a simple inference model with a short MCMC chain}
\usage{
create_test_inference_model(
  site_model = create_jc69_site_model(),
  clock_model = create_strict_clock_model(),
  tree_prior = create_yule_tree_prior(),
  mrca_prior = NA,
  mcmc = create_test_mcmc(),
  beauti_options = create_beauti_options(),
  tipdates_filename = NA
)
}
\arguments{
\item{site_model}{a site model,
as returned by \code{\link{create_site_model}}}

\item{clock_model}{a clock model,
as returned by \code{\link{create_clock_model}}}

\item{tree_prior}{a tree priors,
as returned by \code{\link{create_tree_prior}}}

\item{mrca_prior}{a Most Recent Common Ancestor prior,
as returned by \code{\link{create_mrca_prior}}}

\item{mcmc}{one MCMC.
Use \code{\link{create_mcmc}} to create an MCMC.
Use \code{\link{create_ns_mcmc}} to create an MCMC
  for a Nested Sampling run.
Use \code{\link{check_mcmc}} to check if an MCMC is valid.
Use \code{\link{rename_mcmc_filenames}} to rename the filenames in an MCMC.}

\item{beauti_options}{one BEAUti options object,
as returned by \code{\link{create_beauti_options}}}

\item{tipdates_filename}{name of the file containing the tip dates.
This file is assumed to have two columns, separated by a tab.
The first column contains the taxa names, the second column contains
the date.}
}
\value{
an inference model
}
\description{
Create a simple inference model with a short MCMC chain
}
\examples{
library(testthat)

inference_model <- create_test_inference_model()

beast2_input_file <- tempfile(fileext = ".xml")
create_beast2_input_file_from_model(
  get_fasta_filename(),
  beast2_input_file,
  inference_model = inference_model
)
expect_true(file.exists(beast2_input_file))
}
\seealso{
Use \link{create_inference_model} to create the
  BEAST2 default inference model
}
\author{
Richèl J.C. Bilderbeek
}
