% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/is_distr.R
\name{is_distr}
\alias{is_distr}
\title{Determine if the object is a valid distribution}
\usage{
is_distr(x)
}
\arguments{
\item{x}{an object, to be determined if it is a valid
distribution}
}
\value{
TRUE if x is a valid distribution,
  FALSE otherwise
}
\description{
Determine if the object is a valid distribution
}
\examples{
# TRUE
is_distr(create_beta_distr())
is_distr(create_exp_distr())
is_distr(create_gamma_distr())
is_distr(create_inv_gamma_distr())
is_distr(create_laplace_distr())
is_distr(create_log_normal_distr())
is_distr(create_normal_distr())
is_distr(create_one_div_x_distr())
is_distr(create_poisson_distr())
is_distr(create_uniform_distr())

# FALSE
is_distr(NA)
is_distr(NULL)
is_distr("nonsense")
}
\seealso{
use
 \code{\link{is_beta_distr}},
 \code{\link{is_exp_distr}},
 \code{\link{is_gamma_distr}},
 \code{\link{is_inv_gamma_distr}},
 \code{\link{is_laplace_distr}},
 \code{\link{is_log_normal_distr}},
 \code{\link{is_normal_distr}},
 \code{\link{is_one_div_x_distr}},
 \code{\link{is_poisson_distr}},
 or \code{\link{is_uniform_distr}},
 to check for more specific distribution
}
\author{
Richèl J.C. Bilderbeek
}
