% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/are_fasta_filenames.R
\name{are_fasta_filenames}
\alias{are_fasta_filenames}
\title{Checks if all filenames have a FASTA filename extension}
\usage{
are_fasta_filenames(filenames)
}
\arguments{
\item{filenames}{filenames}
}
\value{
TRUE if all filenames have a FASTA filename extension
}
\description{
Checks if all filenames have a FASTA filename extension
}
\examples{
check_empty_beautier_folder()

# TRUE
are_fasta_filenames("1.fas")
are_fasta_filenames("1.fasta")
are_fasta_filenames("1.FAS")
are_fasta_filenames("1.FASTA")
are_fasta_filenames(c("1.fas", "2.fas"))

# FALSE
are_fasta_filenames("")
are_fasta_filenames(NA)
are_fasta_filenames(NULL)
are_fasta_filenames(Inf)
are_fasta_filenames("1.fasX")
are_fasta_filenames(c("1.fas", "2.exe"))
are_fasta_filenames(c("1.bat", "2.exe"))

check_empty_beautier_folder()
}
\author{
Richèl J.C. Bilderbeek
}
