% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/create_tree_prior.R
\name{create_tree_prior}
\alias{create_tree_prior}
\title{Internal function to create a tree prior}
\usage{
create_tree_prior(name, id, ...)
}
\arguments{
\item{name}{the tree prior name. Can be any name
in \code{get_tree_prior_names}}

\item{id}{the ID of the alignment}

\item{...}{specific tree prior parameters}
}
\value{
a tree_prior
}
\description{
Internal function to create a tree prior
}
\note{
Prefer the use the named functions
  \code{\link{create_bd_tree_prior}},
  \code{\link{create_cbs_tree_prior}},
  \code{\link{create_ccp_tree_prior}}
  \code{\link{create_cep_tree_prior}}
  and \code{\link{create_yule_tree_prior}}
  instead
}
\examples{
check_empty_beautier_folder()

beast2_input_file <- get_beautier_tempfilename()

bd_tree_prior <- create_bd_tree_prior()
cbs_tree_prior <- create_cbs_tree_prior()
ccp_tree_prior <- create_ccp_tree_prior()
cep_tree_prior <- create_cep_tree_prior()
yule_tree_prior <- create_yule_tree_prior()

# Use any of the above tree priors
create_beast2_input_file(
  input_filename = get_fasta_filename(),
  beast2_input_file,
  tree_prior = bd_tree_prior
)
file.remove(beast2_input_file)

remove_beautier_folder()
check_empty_beautier_folder()
}
\seealso{
See
  \code{\link{create_bd_tree_prior}},
  \code{\link{create_cbs_tree_prior}},
  \code{\link{create_ccp_tree_prior}}
  \code{\link{create_cep_tree_prior}}
  and \code{\link{create_yule_tree_prior}}
  for more examples using those functions
}
\author{
Richèl J.C. Bilderbeek
}
