% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/workout.R
\name{workout}
\alias{workout}
\title{Workout a group of expressions individually}
\usage{
workout(expr, description = NULL)
}
\arguments{
\item{expr}{one or more expressions to workout, use \code{{}} to pass multiple
expressions.}

\item{description}{A name to label each expression, if not supplied the
deparsed expression will be used.}
}
\description{
Given an block of expressions in \code{{}} \code{\link[=workout]{workout()}} individually times each
expression in the group.
}
\examples{
workout({
  x <- 1:1000
  evens <- x \%\% 2 == 0
  y <- x[evens]
  length(y)
  length(which(evens))
  sum(evens)
})
}
