% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/betafunctions.R
\name{rGammaBinom}
\alias{rGammaBinom}
\title{Random number generation under the Gamma-extended Binomial distribution.}
\usage{
rGammaBinom(n, size, prob, precision = 1e-04)
}
\arguments{
\item{n}{Number of observations.}

\item{size}{Number of "trials" (zero or more). Need not be integer.}

\item{prob}{Probability of "success" on each "trial". Need not be integer.}

\item{precision}{The precision with which the quantile is to be calculated. Default is 1e-4 (i.e., search terminates when there is no registered change in estimate at the fourth decimal). Tuning this value will impact the time it takes for the search algorithm to arrive at an estimate.}
}
\description{
Random number generation under the Gamma-extended Binomial distribution.
}
\note{
Calls \code{qGammaBinom()}, which makes the random draw slower than what one might be used to (since \code{qGammaBinom()} calls \code{pGammaBinom()} and employs a search-algorithm to find the appropriate value down to a specifiable level of precision).
}
\examples{
# Assume some variable follows a Gamma-Binomial distribution with
# "number of trials" = 10.5 and probability of "success" for each "trial"
# = 0.75 To draw a random value from this distribution:
rGammaBinom(n = 1, size = 10, prob = 0.75)
}
