% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/classification.R
\name{MC.out.tabular}
\alias{MC.out.tabular}
\title{Tabular organization of accuracy and consistency output from the \code{LL.CA.MC()} function.}
\usage{
MC.out.tabular(x)
}
\arguments{
\item{x}{The list-output from the \code{LL.CA.MC()} function.}
}
\description{
Function that takes the output from the \code{LL.CA.MC()} function and organizes it in a table with accuracy and consistency indices represented by columns and categories as rows.
}
\examples{
# Generate some fictional data. Say, 1000 individuals take a test with a
# maximum score of 100 and a minimum score of 0.
set.seed(1234)
p.success <- rBeta.4P(1000, 0.1, 0.95, 5, 3)
for (i in 1:100) {
  if (i == 1) {
    rawdata <- matrix(nrow = 1000, ncol = 100)
  }
  rawdata[, i] <- rbinom(1000, 1, p.success)
}

# Estimate accuracy and consistency where the lowest category are scores
# below 50, second lowest 60, then 70, 80, and 90. Using the cba() function
# to estimate the reliability of this test, to use the LL.CA.MC() function
# or estimating diagnostic performance and consistency indices of
# classifications when using several cut-points:
output <- LL.CA.MC(rowSums(rawdata), cba(rawdata), seq(50, 90, 10), 0, 100)

# As this output can get quite verbose as the number of categories increase,
# the MC.out.tabular() function can be used to organize the output more
# concisely in a tabular format.
MC.out.tabular(output)
}
