% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lm_betaselect_methods.R
\name{coef.lm_betaselect}
\alias{coef.lm_betaselect}
\alias{coef.glm_betaselect}
\title{Coefficients of
Beta-Select in Linear Models}
\usage{
\method{coef}{lm_betaselect}(
  object,
  complete = FALSE,
  type = c("beta", "standardized", "raw", "unstandardized"),
  ...
)

\method{coef}{glm_betaselect}(
  object,
  complete = FALSE,
  type = c("beta", "standardized", "raw", "unstandardized"),
  ...
)
}
\arguments{
\item{object}{The output of
\code{\link[=lm_betaselect]{lm_betaselect()}} or
\code{\link[=glm_betaselect]{glm_betaselect()}}, or an
\code{lm_betaselect}-class or
\code{glm_betaselect}-class object.}

\item{complete}{If \code{TRUE}, it returns
the full vector of coefficients,
including those of terms dropped in
an over-determined system. See
\code{\link[stats:coef]{stats::coef()}} for further
information. Default is \code{FALSE}.}

\item{type}{String. If \code{"unstandardized"}
or \code{"raw"}, the coefficients \emph{before}
standardization are returned. If
\code{"beta"} or \code{"standardized"}, then
the coefficients \emph{after} selected
variables standardized are returned.
Default is \code{"beta"}.}

\item{...}{Other arguments. Ignored.}
}
\value{
A numeric vector: The estimate of
regression coefficients.
}
\description{
Return the estimates of
coefficients in an
\code{lm_betaselect}-class or
\code{glm_betaselect}-class object.
}
\details{
By default, it extracts the
regression coefficients \emph{after} the
selected variables have been
standardized. If requested, it can
also return the regression
coefficients \emph{before}
standardization.
}
\examples{

data(data_test_mod_cat)

lm_beta_x <- lm_betaselect(dv ~ iv*mod + cov1 + cat1,
                           data = data_test_mod_cat,
                           to_standardize = "iv")
coef(lm_beta_x)
coef(lm_beta_x, type = "raw")


data_test_mod_cat$p <- scale(data_test_mod_cat$dv)[, 1]
data_test_mod_cat$p <- ifelse(data_test_mod_cat$p > 0,
                              yes = 1,
                              no = 0)
logistic_beta_x <- glm_betaselect(p ~ iv*mod + cov1 + cat1,
                                  data = data_test_mod_cat,
                                  family = binomial,
                                  to_standardize = "iv")
coef(logistic_beta_x)
coef(logistic_beta_x, type = "raw")

}
\seealso{
\code{\link[=lm_betaselect]{lm_betaselect()}} and
\code{\link[=glm_betaselect]{glm_betaselect()}}
}
\author{
Shu Fai Cheung \url{https://orcid.org/0000-0002-9871-9448}
}
