% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/varma.R
\name{psd_varma}
\alias{psd_varma}
\title{VARMA(p,q) spectral density function}
\usage{
psd_varma(freq, ar = matrix(nrow = nrow(Sigma), ncol = 0),
  ma = matrix(nrow = nrow(Sigma), ncol = 0), Sigma)
}
\arguments{
\item{freq}{numeric vector of frequencies to evaluate the psd, 0 <= freq < pi}

\item{ar}{autoregressive coeffient matrix (d times p*d) of VARMA model, defaults to empty VAR component}

\item{ma}{moving average coeffient matrix (d times p*d) of VARMA model, defaults to empty VAR component}

\item{Sigma}{positive definite innovation covariance matrix (d times d)}
}
\value{
an array containing the values of the varma psd matrix at freq
}
\description{
Evaluate the VARMA(p,q) spectral density at some frequencies freq in [0,pi).
Note that no test for model stationarity is performed.
}
\details{
See section 11.5 in the referenced book
}
\references{
P. J. Brockwell and R. Davis (1996)
\emph{Time Series: Theory and Methods (Second Edition)}
}
