% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/isi2df.R
\name{isi2df}
\alias{isi2df}
\title{Convert an ISI WoK Export file into a data frame}
\usage{
isi2df(D)
}
\arguments{
\item{D}{is a character array containing data read from a ISI Export file (in plain text format).}
}
\value{
a data frame with cases corresponding to articles and variables to Field Tag in the original ISI file.
}
\description{
It converts an ISI Wok Export file and create a data frame from it, with cases corresponding to articles and variables to Field Tag in the original file.
}
\examples{
# A group of ISI Export files can be read using \\code{\\link{readFiles}} function:

# largechar <- readFiles('filename1.txt','filename2.txt','filename3.txt')

# scientometrics_text <- readFiles('http://www.bibliometrix.org/datasets/scientometrics.txt')
# data(scientometrics_text)
# scient_df <- isi2df(scientometrics_text)

}
\seealso{
\code{\link{scopus2df}} for converting SCOPUS Export file (in bibtex format)

Other converting functions: \code{\link{bib2df}},
  \code{\link{cochrane2df}}, \code{\link{convert2df}},
  \code{\link{isibib2df}}, \code{\link{pubmed2df}},
  \code{\link{scopus2df}}
}
\concept{converting functions}
