% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bfa.boot.ci.R
\name{bfa.boot.ci}
\alias{bfa.boot.ci}
\title{Standard Normal Bootstrap Confidence Interval Function}
\usage{
bfa.boot.ci(a1.ls, a1.ls.star, conf.level = 0.95)
}
\arguments{
\item{a1.ls}{A numeric value of the least squares estimator of bifurcating autoregressive model}

\item{a1.ls.star}{A numeric vector representing B replicates of the least squares estimator}

\item{conf.level}{A numeric value representing the confidence level. Defaults to 0.95.}
}
\value{
A numeric vector representing the lower and upper limits of the confidence interval
}
\description{
This function calculates the standard normal bootstrap CI for the least squares estimator of the
bifurcating autoregressive model.
}
\examples{
a1.ls <- 0.7
a1.ls.star <- c(rnorm(100,0.7,0.05))
bfa.boot.ci(a1.ls, a1.ls.star, conf.level= 0.95)
}
