% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/datasets.R
\name{bqr_copy_dataset}
\alias{bqr_copy_dataset}
\title{Copy datasets}
\usage{
bqr_copy_dataset(source_datasetid, destination_datasetid,
  source_projectid = bqr_get_global_project(),
  destination_projectid = bqr_get_global_project(),
  createDisposition = c("CREATE_IF_NEEDED", "CREATE_NEVER"),
  writeDisposition = c("WRITE_TRUNCATE", "WRITE_APPEND", "WRITE_EMPTY"),
  destination_prefix = NULL)
}
\arguments{
\item{source_datasetid}{source datasetId}

\item{destination_datasetid}{destination datasetId}

\item{source_projectid}{source table's projectId}

\item{destination_projectid}{destination table's projectId}

\item{createDisposition}{Create table's behaviour}

\item{writeDisposition}{Write to an existing table's behaviour}

\item{destination_prefix}{A prefix appended to the destination tableIds}
}
\value{
A named list of jobs of the source datasets, with details of job started.
}
\description{
Uses \link{bqr_copy_table} to copy all the tables in a dataset.
}
\details{
You can not copy across dataset regions (e.g. EU to US), or copy BigQuery Views.
}
\examples{

\dontrun{

  bqr_copy_dataset("source_dataset", "destination_dataset")

}
}
