% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/meteorological_variables.r
\name{wetbulb.temp}
\alias{wetbulb.temp}
\title{Wet-Bulb Temperature}
\usage{
wetbulb.temp(Tair, pressure, VPD, accuracy = 0.001,
  Esat.formula = c("Sonntag_1990", "Alduchov_1996", "Allen_1998"),
  constants = bigleaf.constants())
}
\arguments{
\item{Tair}{Air temperature (deg C)}

\item{pressure}{Atmospheric pressure (kPa)}

\item{VPD}{Vapor pressure deficit (kPa)}

\item{accuracy}{Accuracy of the result (deg C)}

\item{Esat.formula}{Optional: formula to be used for the calculation of esat and the slope of esat.
One of \code{"Sonntag_1990"} (Default), \code{"Alduchov_1996"}, or \code{"Allen_1998"}.
See \code{\link{Esat.slope}}.}

\item{constants}{cp - specific heat of air for constant pressure (J K-1 kg-1) \cr
eps - ratio of the molecular weight of water vapor to dry air (-)}
}
\value{
\item{Tw -}{wet-bulb temperature (degC)}
}
\description{
calculates the wet bulb temperature, i.e. the temperature
             that the air would have if it was saturated.
}
\details{
Wet-bulb temperature (Tw) is calculated from the following expression:
         
           \deqn{e = Esat(Tw) - gamma* (Tair - Tw)}
         
         The equation is solved for Tw using \code{\link[stats]{optimize}}.
         Actual vapor pressure e (kPa) is calculated from VPD using the function \code{\link{VPD.to.e}}.
         The psychrometric constant gamma (kPa K-1) is calculated from \code{\link{psychrometric.constant}}.
}
\examples{
wetbulb.temp(Tair=c(20,25),pressure=100,VPD=c(1,1.6))             
       
}
\references{
Monteith J.L., Unsworth M.H., 2008: Principles of Environmental Physics.
            3rd edition. Academic Press, London.
}
