% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SCT.R
\name{seq_log}
\alias{seq_log}
\title{Sequence, evenly spaced on a logarithmic scale}
\usage{
seq_log(from, to, length.out)
}
\arguments{
\item{from}{the starting and (maximal) end values of the
    sequence.  Of length \code{1} unless just \code{from} is supplied as
    an unnamed argument.}

\item{to}{the starting and (maximal) end values of the
    sequence.  Of length \code{1} unless just \code{from} is supplied as
    an unnamed argument.}

\item{length.out}{desired length of the sequence.  A
    non-negative number, which for \code{seq} and \code{seq.int} will be
    rounded up if fractional.}
}
\value{
A sequence of length \code{length.out}, evenly spaced on a logarithmic scale
between \code{from} and \code{to}.
}
\description{
Sequence, evenly spaced on a logarithmic scale
}
\examples{
seq_log(1, 1000, 4)
seq_log(1, 100, 5)

}
