% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mult-mat.R
\name{big_cprodMat}
\alias{big_cprodMat}
\alias{crossprod,FBM,matrix-method}
\alias{tcrossprod,FBM,matrix-method}
\alias{crossprod,matrix,FBM-method}
\alias{tcrossprod,matrix,FBM-method}
\title{Cross-product with a matrix}
\usage{
big_cprodMat(
  X,
  A.row,
  ind.row = rows_along(X),
  ind.col = cols_along(X),
  ncores = 1,
  block.size = block_size(nrow(X), ncores),
  center = NULL,
  scale = NULL
)

\S4method{crossprod}{FBM,matrix}(x, y)

\S4method{tcrossprod}{FBM,matrix}(x, y)

\S4method{crossprod}{matrix,FBM}(x, y)

\S4method{tcrossprod}{matrix,FBM}(x, y)
}
\arguments{
\item{X}{An object of class \link[=FBM-class]{FBM}.}

\item{A.row}{A matrix with \code{length(ind.row)} rows.}

\item{ind.row}{An optional vector of the row indices that are used.
If not specified, all rows are used. \strong{Don't use negative indices.}}

\item{ind.col}{An optional vector of the column indices that are used.
If not specified, all columns are used. \strong{Don't use negative indices.}}

\item{ncores}{Number of cores used. Default doesn't use parallelism.
You may use \link{nb_cores}.}

\item{block.size}{Maximum number of columns read at once.
Default uses \link{block_size}.}

\item{center}{Vector of same length of \code{ind.col} to subtract from columns of \code{X}.}

\item{scale}{Vector of same length of \code{ind.col} to divide from columns of \code{X}.}

\item{x}{A 'double' FBM or a matrix.}

\item{y}{A 'double' FBM or a matrix.}
}
\value{
\eqn{X^T \cdot A}.
}
\description{
Cross-product between a Filebacked Big Matrix and a matrix.
}
\section{Matrix parallelization}{

Large matrix computations are made block-wise and won't be parallelized
in order to not have to reduce the size of these blocks.
Instead, you may use \href{https://mran.microsoft.com/open/}{Microsoft R Open}
or OpenBLAS in order to accelerate these block matrix computations.
You can also control the number of cores used with
\code{bigparallelr::set_blas_ncores()}.
}

\examples{
X <- big_attachExtdata()
n <- nrow(X)
m <- ncol(X)
A <- matrix(0, n, 10); A[] <- rnorm(length(A))

test <- big_cprodMat(X, A)
true <- crossprod(X[], A)
all.equal(test, true)

X2 <- big_copy(X, type = "double")
all.equal(crossprod(X2, A), true)

# subsetting
ind.row <- sample(n, n/2)
ind.col <- sample(m, m/2)

tryCatch(test2 <- big_cprodMat(X, A, ind.row, ind.col),
         error = function(e) print(e))
# returns an error. You need to use the subset of A:
test2 <- big_cprodMat(X, A[ind.row, ], ind.row, ind.col)
true2 <- crossprod(X[ind.row, ind.col], A[ind.row, ])
all.equal(test2, true2)

}
