% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bb_utils.R
\name{bb_subchart}
\alias{bb_subchart}
\title{Subchart property for a Billboard.js chart}
\usage{
bb_subchart(bb, ...)
}
\arguments{
\item{bb}{A \code{billboard} \code{htmlwidget} object.}

\item{...}{See \url{https://naver.github.io/billboard.js/release/latest/doc/Options.html#.subchart}}
}
\value{
A \code{billboard} \code{htmlwidget} object.
}
\description{
Create a subchart allowing to zoom and navigate on the chart.
}
\examples{

data("equilibre_mensuel")

billboarder() \%>\% 
  bb_linechart(data = equilibre_mensuel[, c("date", "production")], type = "spline") \%>\% 
  bb_subchart(show = TRUE)

}
