% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Inf.Dorf.R
\name{inf.dorf.measures}
\alias{inf.dorf.measures}
\title{Operating characteristics for informative two-stage 
hierarchical (Dorfman) testing}
\usage{
inf.dorf.measures(prob, se, sp, N, pool.sizes)
}
\arguments{
\item{prob}{vector of probabilities corresponding to each individual's 
risk of disease.}

\item{se}{the sensitivity of the diagnostic test.}

\item{sp}{the specificity of the diagnostic test.}

\item{N}{block size/initial group size that is not tested. This
is the total number of individuals being tested. The 
details of \kbd{block.sz} are given under 'Details'.}

\item{pool.sizes}{a vector of pool sizes for the first stage 
of testing.}
}
\value{
A list containing:
\item{e}{the expected number of tests needed to decode all N
individuals.}
\item{v}{the variance of the total number of tests needed to 
decode all N individuals.}
\item{summary}{a matrix containing the pool, probability of 
disease, pooling sensitivity, pooling specificity, pooling 
positive predictive value, and pooling negative predictive 
value for each individual. The pool column identifies which 
pool each individual is contained in for the first stage of
testing.}
}
\description{
Calculate the expected number of tests and accuracy 
measures for each individual using informative two-stage 
hierarchical (Dorfman) testing, given a vector of individual 
probabilities and a testing configuration.
}
\details{
This function utilizes the equations given by McMahan et al. 
(2012) for informative two-stage hierarchical (Dorfman) testing. 
It also repurposes functions written by Christopher S. McMahan (see
\url{http://chrisbilder.com/grouptesting})
for the implementation of informative Dorfman testing and directly 
uses functions written for the calculation of the associated operating 
characteristics. This function calculates the operating characteristics 
for informative two-stage hierarchical (Dorfman) testing. Operating 
characteristics calculated are expected number of tests, and pooling 
sensitivity, pooling specificity, pooling positive predictive value, 
and pooling negative predictive value for each individual.

The specified \kbd{N} represents the block size used in the pool-specific
optimal Dorfman (PSOD) method. This is the total number of individuals being
tested by the algorithm. This block is not initially tested. Instead, 
multiple initial pool sizes within this block are found and tested in 
the first stage of testing. The second stage of testing consists of individual
retesting. For more information on block size specification, see McMahan et
al. (2012).
}
\section{Note}{
 This function returns the pooling positive and negative
predictive values for all individuals even though these measures are 
diagnostic specific; i.e., PPPV (PNPV) should only be considered
for those individuals who have tested positive (negative).
}

\examples{
# Calculate the operating characteristics for 
#   informative two-stage hierarchical (Dorfman) testing
#   with an overall disease prevalence of E(p(i)) = 0.01,
#   where a block size of 50 is split into initial pools
#   of 18, 13, 11, and 8 individuals.
# This example takes less than 1 second to run.
# Estimated running time was calculated using a 
#   computer with 16 GB of RAM and one core of an 
#   Intel i7-6500U processor.
set.seed(8791)
inf.dorf.measures(prob=beta.dist(p=0.01, alpha=2, 
grp.sz=50, simul=TRUE), se=0.95, sp=0.95, N=50, 
pool.sizes=c(18, 13, 11, 8))
}
\references{
\insertRef{McMahan2012a}{binGroup}
}
\seealso{
\code{\link{Array.Measures}} for calculating operating characteristics
under array testing without master pooling, 
\code{\link{MasterPool.Array.Measures}} for non-informative array 
testing with master pooling, and \code{\link{inf.dorf.measures}} 
for informative two-stage hierarchical testing. See 
\code{\link{p.vec.func}} for generating a vector of 
individual risk probabilities for informative group testing. 

This function repurposed code from \code{\link{opt.info.dorf}} so that
PSOD testing could be implemented using all possible testing configurations
instead of a greedy algorithm. This function also used
\code{\link{characteristics.pool}} and \code{\link{accuracy.dorf}}
to calculate operating characteristics for the optimal set of 
pool sizes.

\url{http://chrisbilder.com/grouptesting}

Other Operating characteristic functions: \code{\link{Array.Measures}},
  \code{\link{MasterPool.Array.Measures}},
  \code{\link{hierarchical.desc2}}

Other Informative Dorfman functions: \code{\link{accuracy.dorf}},
  \code{\link{characteristics.pool}},
  \code{\link{opt.info.dorf}}, \code{\link{opt.pool.size}},
  \code{\link{pool.specific.dorf}},
  \code{\link{thresh.val.dorf}}
}
\author{
The majority of this function was originally written by 
Christopher S. McMahan for McMahan et al. (2012). The function was 
obtained from \url{http://chrisbilder.com/grouptesting}. Minor modifications 
were made to the function for inclusion in the binGroup package.
}
